/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter.config;

import com.devexperts.logging.Logging;
import com.devexperts.mars2micrometer.marsadapter.MarsMetricsFilter;
import com.devexperts.mars2micrometer.marsadapter.NumericValuesFilter;
import com.devexperts.mars2micrometer.marsadapter.PrefixesMetricsFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class MarsMetricsFilterParser {
    public static final String WHITELIST = "whitelist:";
    public static final String BLACKLIST = "blacklist:";
    private static final Logging log = Logging.getLogging(MarsMetricsFilterParser.class);

    private MarsMetricsFilterParser() {
    }

    public static MarsMetricsFilter parseFilter(String marsRoot, String prefixesFilterStr) {
        boolean isBlackList;
        Objects.requireNonNull(marsRoot, "marsRoot must not be null");
        MarsMetricsFilter filter = new NumericValuesFilter();
        if (prefixesFilterStr == null || prefixesFilterStr.isEmpty()) {
            return filter;
        }
        boolean isWhiteList = prefixesFilterStr.startsWith(WHITELIST);
        boolean bl = isBlackList = !isWhiteList && prefixesFilterStr.startsWith(BLACKLIST);
        if (!isWhiteList && !isBlackList) {
            log.warn("Invalid PrefixesMetricsFilter format. Expected <whitelist:prefix[,prefixes...]|blacklist:prefix[,prefixes...]>, got " + prefixesFilterStr);
            return filter;
        }
        if (isWhiteList) {
            PrefixesMetricsFilter whiteListFilter = PrefixesMetricsFilter.whitelistFilter(marsRoot, MarsMetricsFilterParser.prefixCollection(prefixesFilterStr.substring(WHITELIST.length())));
            filter = whiteListFilter.and(filter);
        } else {
            PrefixesMetricsFilter blackListFilter = PrefixesMetricsFilter.blacklistFilter(marsRoot, MarsMetricsFilterParser.prefixCollection(prefixesFilterStr.substring(BLACKLIST.length())));
            filter = blackListFilter.and(filter);
        }
        return filter;
    }

    private static Collection<String> prefixCollection(String prefixFilterStr) {
        return prefixFilterStr.isEmpty() ? Arrays.asList(new String[0]) : Arrays.asList(prefixFilterStr.split(","));
    }
}

