/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.mars.common.MARSScheduler;
import com.devexperts.mars2micrometer.marsadapter.MarsNodeMeta;
import com.devexperts.mars2micrometer.marsadapter.MarsToMicrometerNameConverter;
import com.devexperts.mars2micrometer.marsadapter.ResolvedMarsNodesListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class LoggingMarsMetricsExporter
implements ResolvedMarsNodesListener {
    private static final Logging log = Logging.getLogging(LoggingMarsMetricsExporter.class);
    private final MARS mars;
    private final MarsToMicrometerNameConverter metricNameConverter = new MarsToMicrometerNameConverter(MARSNode.getRoot().getName(), true);
    private final Map<String, Supplier<String>> meters = new ConcurrentHashMap<String, Supplier<String>>();

    public LoggingMarsMetricsExporter(MARS mars) {
        this.mars = mars;
        MARSScheduler.schedule(() -> this.meters.forEach((nodeName, valueSupplier) -> log.info(String.format("Metric[name=%s]=%s", this.metricNameConverter.convert((String)nodeName), valueSupplier.get()))), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public void marsNodeResolved(MarsNodeMeta nodeMeta) {
        assert (nodeMeta != null) : "nodeMeta must not be null";
        this.meters.put(nodeMeta.getName(), () -> this.mars.getValue(nodeMeta.getMarsValueNode()));
    }
}

