/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.auth.util;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Base64;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignedToken {
    public static final String MAC_ALGORITHM = "HmacSHA256";
    public static final String MAC_CHARSET = "UTF-8";
    static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private final String issuer;
    private final String subject;
    private final Instant expiration;
    private final Instant notBefore;
    private final Instant issuedAt;
    private final String message;
    private final transient String rawToken;

    protected SignedToken(String issuer, String subject, String message, Instant notBefore, Instant expiration, Instant issuedAt, String rawToken) {
        this.issuer = SignedToken.validate(issuer, "issuer");
        this.subject = SignedToken.validate(subject, "subject");
        this.message = message;
        this.notBefore = SignedToken.validateTime(notBefore);
        this.expiration = SignedToken.validateTime(Objects.requireNonNull(expiration, "expiration"));
        this.issuedAt = SignedToken.validateTime(issuedAt);
        this.rawToken = rawToken;
        if (notBefore != null && notBefore.isAfter(expiration)) {
            throw new IllegalArgumentException("Not-before time must not be after expiration time");
        }
    }

    public static SignedToken valueOf(String token) {
        Objects.requireNonNull(token, "token");
        int separatorIndex = token.indexOf(46);
        if (separatorIndex <= 0) {
            throw new IllegalArgumentException("Illegal token: " + token);
        }
        try {
            byte[] payload = DECODER.decode(token.substring(0, separatorIndex));
            byte[] signature = DECODER.decode(token.substring(separatorIndex + 1));
            String payloadString = new String(payload, MAC_CHARSET);
            String[] values = payloadString.split(",", 6);
            if (values.length < 6) {
                throw new IllegalArgumentException("Illegal token: " + token);
            }
            String issuer = values[0];
            String subject = values[1];
            Instant nbfTime = SignedToken.parseTime(values[2]);
            Instant expTime = SignedToken.parseTime(values[3]);
            Instant iatTime = SignedToken.parseTime(values[4]);
            String message = values[5];
            return new SignedToken(issuer, subject, message, nbfTime, expTime, iatTime, token);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String issuer, String subject, Instant expiration) {
        return new Builder().setIssuer(issuer).setSubject(subject).setExpiration(expiration);
    }

    public static Builder newBuilder(String issuer, String subject, TemporalAmount amount) {
        return new Builder().setIssuer(issuer).setSubject(subject).setExpirationFromNow(amount);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isIssuedBefore(SignedToken token) {
        Instant issued = this.getIssuedAt();
        Instant otherIssued = Objects.requireNonNull(token, "token").getIssuedAt();
        return issued != null && otherIssued != null && issued.isBefore(otherIssued);
    }

    public String signToken(String secret) {
        try {
            byte[] payload = ENCODER.encode(this.createPayload().getBytes(MAC_CHARSET));
            byte[] signature = ENCODER.encode(SignedToken.computeMac(payload, secret.getBytes(MAC_CHARSET)));
            return new String(payload) + "." + new String(signature);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error generating token", e);
        }
    }

    @Deprecated
    public boolean verifyToken(String secret) {
        return this.verifyToken(secret, Instant.now());
    }

    @Deprecated
    public boolean verifyToken(String secret, Instant now) {
        if ((now = Objects.requireNonNull(now, "now").truncatedTo(ChronoUnit.SECONDS)).isAfter(this.expiration) || this.notBefore != null && now.isBefore(this.notBefore)) {
            return false;
        }
        return this.verifySignature(secret);
    }

    public boolean verifySignature(String secret) {
        if (this.rawToken == null) {
            return true;
        }
        return this.signToken(secret).equals(this.rawToken);
    }

    public boolean verifyTime(Instant time) {
        Instant truncatedTime = time.truncatedTo(ChronoUnit.SECONDS);
        return !(this.notBefore != null && truncatedTime.isBefore(this.notBefore) || this.expiration != null && truncatedTime.isAfter(this.expiration));
    }

    public String toString() {
        return "SignedToken{iss=" + this.issuer + ", sub=" + this.subject + ", exp=" + this.expiration + ", nbf=" + this.notBefore + ", iat=" + this.issuedAt + ", msg=" + this.message + "}";
    }

    private String createPayload() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.issuer).append(',').append(this.subject).append(',');
        if (this.notBefore != null) {
            buff.append(this.notBefore.getEpochSecond());
        }
        buff.append(',').append(this.expiration.getEpochSecond()).append(',');
        if (this.issuedAt != null) {
            buff.append(this.issuedAt.getEpochSecond());
        }
        buff.append(',').append(this.message != null ? this.message : "");
        return buff.toString();
    }

    private static String validate(String s, String name) {
        Objects.requireNonNull(s, name);
        if (s.indexOf(44) >= 0) {
            throw new IllegalArgumentException(name + " must not contain commas");
        }
        return s;
    }

    private static Instant validateTime(Instant instant) {
        return instant != null ? instant.truncatedTo(ChronoUnit.SECONDS) : null;
    }

    private static Instant parseTime(String s) {
        return s.isEmpty() ? null : Instant.ofEpochSecond(Long.valueOf(s));
    }

    private static byte[] computeMac(byte[] payload, byte[] secret) {
        try {
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(new SecretKeySpec(secret, MAC_ALGORITHM));
            return mac.doFinal(payload);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder {
        private String issuer;
        private String subject;
        private Instant expiration;
        private Instant notBefore;
        private Instant issued;
        private String message;

        protected Builder() {
        }

        public SignedToken toToken() {
            return new SignedToken(this.issuer, this.subject, this.message, this.notBefore, this.expiration, this.issued, null);
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Builder setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public String getSubject() {
            return this.subject;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Instant getExpiration() {
            return this.expiration;
        }

        public Builder setExpiration(Instant expiration) {
            this.expiration = SignedToken.validateTime(expiration);
            return this;
        }

        public Builder setExpirationFromNow(TemporalAmount amount) {
            this.expiration = SignedToken.validateTime(Instant.now().plus(amount));
            return this;
        }

        public Instant getNotBefore() {
            return this.notBefore;
        }

        public Builder setNotBefore(Instant notBefore) {
            this.notBefore = SignedToken.validateTime(notBefore);
            return this;
        }

        public Instant getIssued() {
            return this.issued;
        }

        public Builder setIssued(Instant issued) {
            this.issued = SignedToken.validateTime(issued);
            return this;
        }

        public Builder setIssuedNow() {
            this.issued = Instant.now();
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setUser(String user) {
            this.setMessage(user);
            return this;
        }

        public Builder setUser(String user, Set<String> feeds) {
            String feedString = feeds.stream().collect(Collectors.joining(";"));
            this.message = user + (feedString.isEmpty() ? "" : "," + feedString);
            return this;
        }
    }
}

