/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.custom.NuamOrder;
import com.dxfeed.event.custom.NuamOrderType;
import com.dxfeed.event.custom.NuamTimeInForceType;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NuamOrderTest {
    private static final String SYMBOL = "TEST";
    private static final String WEIRD_EXCHANGE_INFO_1 = "weird\u0002\u0001\u0000";
    private static final String WEIRD_EXCHANGE_INFO_2 = "\u0000\u0000";
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<NuamOrder> sub;
    private final BlockingQueue<NuamOrder> queue = new ArrayBlockingQueue<NuamOrder>(10);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = feed.createSubscription(NuamOrder.class);
        this.sub.addEventListener(this.queue::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testNuamOrder() throws InterruptedException {
        NuamOrder order = new NuamOrder(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        order.setActorId(1);
        order.setParticipantId(2);
        order.setSubmitterId(3);
        order.setOnBehalfOfSubmitterId(4);
        order.setClientOrderId("ClientOrderId");
        order.setCustomerAccount("CustomerAccount");
        order.setCustomerInfo("CustomerInfo");
        order.setExchangeInfo(WEIRD_EXCHANGE_INFO_1);
        order.setTimeInForce(NuamTimeInForceType.NUMBER_OF_DAYS);
        order.setTimeInForceData(5);
        order.setTriggerOrderBookId(13);
        order.setTriggerPrice(155.0);
        order.setTriggerSessionType(1);
        order.setOrderQuantity(100.0);
        order.setDisplayQuantity(20.0);
        order.setRefreshQuantity(40.0);
        order.setLeavesQuantity(50.0);
        order.setMatchedQuantity(10.0);
        order.setOrderType(NuamOrderType.IMBALANCE);
        this.publisher.publishEvents(Collections.singleton(order));
        NuamOrder received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)received.getOrderSide());
        Assert.assertEquals((Object)Scope.ORDER, (Object)received.getScope());
        Assert.assertEquals((double)10.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getSize());
        Assert.assertEquals((long)1L, (long)received.getActorId());
        Assert.assertEquals((long)2L, (long)received.getParticipantId());
        Assert.assertEquals((long)3L, (long)received.getSubmitterId());
        Assert.assertEquals((long)4L, (long)received.getOnBehalfOfSubmitterId());
        Assert.assertEquals((Object)"ClientOrderId", (Object)received.getClientOrderId());
        Assert.assertEquals((Object)"CustomerAccount", (Object)received.getCustomerAccount());
        Assert.assertEquals((Object)"CustomerInfo", (Object)received.getCustomerInfo());
        Assert.assertEquals((Object)WEIRD_EXCHANGE_INFO_1, (Object)received.getExchangeInfo());
        Assert.assertEquals((Object)NuamTimeInForceType.NUMBER_OF_DAYS, (Object)received.getTimeInForce());
        Assert.assertEquals((long)5L, (long)received.getTimeInForceData());
        Assert.assertEquals((long)13L, (long)received.getTriggerOrderBookId());
        Assert.assertEquals((double)155.0, (double)received.getTriggerPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getTriggerSessionType());
        Assert.assertEquals((double)100.0, (double)received.getOrderQuantity(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)received.getDisplayQuantity(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)received.getRefreshQuantity(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)received.getLeavesQuantity(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)received.getMatchedQuantity(), (double)0.0);
        Assert.assertEquals((Object)NuamOrderType.IMBALANCE, (Object)received.getOrderType());
        Assert.assertEquals((Object)order.toString(), (Object)received.toString());
        order.setOrderType(NuamOrderType.MARKET);
        order.setTimeInForce(NuamTimeInForceType.REST_OF_DAY);
        order.setExchangeInfo(WEIRD_EXCHANGE_INFO_2);
        order.setTimeInForceData(0);
        this.publisher.publishEvents(Collections.singleton(order));
        received = this.queue.take();
        Assert.assertEquals((Object)NuamOrderType.MARKET, (Object)received.getOrderType());
        Assert.assertEquals((Object)NuamTimeInForceType.REST_OF_DAY, (Object)received.getTimeInForce());
        Assert.assertEquals((long)0L, (long)received.getTimeInForceData());
        Assert.assertEquals((Object)WEIRD_EXCHANGE_INFO_2, (Object)received.getExchangeInfo());
        Assert.assertEquals((Object)order.toString(), (Object)received.toString());
    }

    @Test
    public void testOrderNotReceived() throws InterruptedException {
        Order order = new Order(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(order));
        Order received = (Order)this.queue.poll(1L, TimeUnit.SECONDS);
        Assert.assertNull((Object)received);
    }

    @Test
    public void testEmptyNuamOrder() {
        NuamOrder order = new NuamOrder();
        Assert.assertNull((Object)order.getEventSymbol());
        Assert.assertNull((Object)order.getMarketMaker());
        Assert.assertEquals((long)0L, (long)order.getActorId());
        Assert.assertEquals((long)0L, (long)order.getParticipantId());
        Assert.assertEquals((long)0L, (long)order.getSubmitterId());
        Assert.assertEquals((long)0L, (long)order.getOnBehalfOfSubmitterId());
        Assert.assertNull((Object)order.getClientOrderId());
        Assert.assertNull((Object)order.getCustomerAccount());
        Assert.assertNull((Object)order.getCustomerInfo());
        Assert.assertNull((Object)order.getExchangeInfo());
        Assert.assertEquals((Object)NuamTimeInForceType.UNDEFINED, (Object)order.getTimeInForce());
        Assert.assertEquals((long)0L, (long)order.getTimeInForceData());
        Assert.assertEquals((long)0L, (long)order.getTriggerOrderBookId());
        Assert.assertEquals((double)Double.NaN, (double)order.getTriggerPrice(), (double)0.0);
        Assert.assertEquals((long)0L, (long)order.getTriggerSessionType());
        Assert.assertEquals((double)Double.NaN, (double)order.getOrderQuantity(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)order.getDisplayQuantity(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)order.getRefreshQuantity(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)order.getLeavesQuantity(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)order.getMatchedQuantity(), (double)0.0);
        Assert.assertEquals((Object)NuamOrderType.UNDEFINED, (Object)order.getOrderType());
    }
}

