/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.custom.NuamTimeAndSale;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NuamTimeAndSaleTest {
    private static final String SYMBOL = "TEST";
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<NuamTimeAndSale> sub;
    private final BlockingQueue<NuamTimeAndSale> queue = new ArrayBlockingQueue<NuamTimeAndSale>(10);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = feed.createSubscription(NuamTimeAndSale.class);
        this.sub.addEventListener(this.queue::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testNuamTimeAndSale() throws InterruptedException {
        NuamTimeAndSale tns = new NuamTimeAndSale(SYMBOL);
        tns.setTime(1000L);
        tns.setPrice(100.0);
        tns.setMatchId(1L);
        tns.setTradeId(2L);
        this.publisher.publishEvents(Collections.singleton(tns));
        NuamTimeAndSale received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((long)1000L, (long)received.getTime());
        Assert.assertEquals((double)100.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getMatchId());
        Assert.assertEquals((long)2L, (long)received.getTradeId());
        Assert.assertEquals((Object)tns.toString(), (Object)received.toString());
        tns.setTime(2000L);
        tns.setPrice(200.0);
        tns.setMatchId(1L);
        tns.setTradeId(2L);
        this.publisher.publishEvents(Collections.singleton(tns));
        received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((long)2000L, (long)received.getTime());
        Assert.assertEquals((double)200.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getMatchId());
        Assert.assertEquals((long)2L, (long)received.getTradeId());
        Assert.assertEquals((Object)tns.toString(), (Object)received.toString());
    }

    @Test
    public void testEmptyNuamTimeAndSale() {
        NuamTimeAndSale tns = new NuamTimeAndSale();
        Assert.assertNull((Object)tns.getEventSymbol());
        Assert.assertEquals((long)0L, (long)tns.getMatchId());
        Assert.assertEquals((long)0L, (long)tns.getTradeId());
    }
}

