/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.impl.QuoteMapping;

import java.util.EnumSet;

public class QuoteDelegate extends MarketEventDelegateImpl<Quote> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final QuoteMapping m;

    public QuoteDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(QuoteMapping.class);
    }

    @Override
    public QuoteMapping getMapping() {
        return m;
    }

    @Override
    public Quote createEvent() {
        return new Quote();
    }

    @Override
    public Quote getEvent(Quote event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeNanoPart(m.getTimeNanoPart(cursor));
        event.setBidTime(m.getBidTimeMillis(cursor));
        event.setBidExchangeCode(m.getBidExchangeCode(cursor));
        event.setBidPrice(m.getBidPrice(cursor));
        event.setBidSizeAsDouble(m.getBidSizeDouble(cursor));
        event.setAskTime(m.getAskTimeMillis(cursor));
        event.setAskExchangeCode(m.getAskExchangeCode(cursor));
        event.setAskPrice(m.getAskPrice(cursor));
        event.setAskSizeAsDouble(m.getAskSizeDouble(cursor));
        event.setTimeMillisSequence(m.getSequence(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Quote event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        m.setBidTimeMillis(cursor, event.getBidTime());
        m.setBidExchangeCode(cursor, event.getBidExchangeCode());
        m.setBidPrice(cursor, event.getBidPrice());
        m.setBidSizeDouble(cursor, event.getBidSizeAsDouble());
        m.setAskTimeMillis(cursor, event.getAskTime());
        m.setAskExchangeCode(cursor, event.getAskExchangeCode());
        m.setAskPrice(cursor, event.getAskPrice());
        m.setAskSizeDouble(cursor, event.getAskSizeAsDouble());
        m.setSequence(cursor, event.getTimeMillisSequence());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
