/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.custom;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.custom.impl.NuamTradeMapping;
import com.dxfeed.event.market.Direction;
import com.dxfeed.event.market.MarketEventDelegateImpl;

import java.util.EnumSet;

public final class NuamTradeDelegate extends MarketEventDelegateImpl<NuamTrade> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final NuamTradeMapping m;

    public NuamTradeDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(NuamTradeMapping.class);
    }

    @Override
    public NuamTradeMapping getMapping() {
        return m;
    }

    @Override
    public NuamTrade createEvent() {
        return new NuamTrade();
    }

    @Override
    public NuamTrade getEvent(NuamTrade event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setTimeNanoPart(m.getTimeNanoPart(cursor));
        event.setExchangeCode(m.getExchangeCode(cursor));
        event.setPrice(m.getPrice(cursor));
        event.setSizeAsDouble(m.getSizeDouble(cursor));
        event.setChange(m.getChange(cursor));
        event.setDayId(m.getDayId(cursor));
        event.setDayVolumeAsDouble(m.getDayVolumeDouble(cursor));
        event.setDayTurnover(m.getDayTurnover(cursor));
        event.setFlags(m.getFlags(cursor));
        if (event.getTickDirection() == Direction.UNDEFINED) {
            // if direction is not provided via flags field - compute it from tick field if provided
            int tick = m.getTick(cursor);
            if (tick == 1)
                event.setTickDirection(Direction.ZERO_UP);
            else if (tick == 2)
                event.setTickDirection(Direction.ZERO_DOWN);
        }
        event.setTradeStatTime(m.getTradeStatTimeMillis(cursor));
        event.setLastSignificantPrice(m.getLastSignificantPrice(cursor));
        event.setLastPriceForAll(m.getLastPriceForAll(cursor));
        event.setNumberOfTrades(m.getNumberOfTrades(cursor));
        event.setVWAP(m.getVWAP(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(NuamTrade event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        m.setExchangeCode(cursor, event.getExchangeCode());
        m.setPrice(cursor, event.getPrice());
        m.setSizeDouble(cursor, event.getSizeAsDouble());
        m.setChange(cursor, event.getChange());
        m.setDayId(cursor, event.getDayId());
        m.setDayVolumeDouble(cursor, event.getDayVolumeAsDouble());
        m.setDayTurnover(cursor, event.getDayTurnover());
        m.setFlags(cursor, event.getFlags());
        Direction d = event.getTickDirection();
        m.setTick(cursor, d == Direction.UP || d == Direction.ZERO_UP ? 1 : d == Direction.DOWN || d == Direction.ZERO_DOWN ? 2 : 0);
        m.setTradeStatTimeMillis(cursor, event.getTradeStatTime());
        m.setLastSignificantPrice(cursor, event.getLastSignificantPrice());
        m.setLastPriceForAll(cursor, event.getLastPriceForAll());
        m.setNumberOfTrades(cursor, event.getNumberOfTrades());
        m.setVWAP(cursor, event.getVWAP());
        return cursor;
    }
// END: CODE AUTOMATICALLY GENERATED
}
