/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class OrderImbalanceMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iTime;
    private final int iSequence;
    private final int iRefPrice;
    private final int iPairedSize;
    private final int iImbalanceSize;
    private final int iNearPrice;
    private final int iFarPrice;
    private final int iFlags;

    public OrderImbalanceMapping(DataRecord record) {
        super(record);
        iTime = MappingUtil.findIntField(record, "Time", false);
        iSequence = MappingUtil.findIntField(record, "Sequence", false);
        iRefPrice = findIntField("RefPrice", true);
        iPairedSize = findIntField("PairedSize", true);
        iImbalanceSize = findIntField("ImbalanceSize", true);
        iNearPrice = findIntField("NearPrice", false);
        iFarPrice = findIntField("FarPrice", false);
        iFlags = MappingUtil.findIntField(record, "Flags", true);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (iSequence < 0)
            return 0;
        return getInt(cursor, iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (iSequence < 0)
            return;
        setInt(cursor, iSequence, sequence);
    }

    public double getRefPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iRefPrice);
    }

    public void setRefPrice(RecordCursor cursor, double refPrice) {
        setAsDouble(cursor, iRefPrice, refPrice);
    }

    public int getRefPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iRefPrice);
    }

    public void setRefPriceDecimal(RecordCursor cursor, int refPrice) {
        setAsTinyDecimal(cursor, iRefPrice, refPrice);
    }

    public long getRefPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iRefPrice);
    }

    public void setRefPriceWideDecimal(RecordCursor cursor, long refPrice) {
        setAsWideDecimal(cursor, iRefPrice, refPrice);
    }

    public int getPairedSize(RecordCursor cursor) {
        return getAsInt(cursor, iPairedSize);
    }

    public void setPairedSize(RecordCursor cursor, int pairedSize) {
        setAsInt(cursor, iPairedSize, pairedSize);
    }

    public long getPairedSizeLong(RecordCursor cursor) {
        return getAsLong(cursor, iPairedSize);
    }

    public void setPairedSizeLong(RecordCursor cursor, long pairedSize) {
        setAsLong(cursor, iPairedSize, pairedSize);
    }

    public double getPairedSizeDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iPairedSize);
    }

    public void setPairedSizeDouble(RecordCursor cursor, double pairedSize) {
        setAsDouble(cursor, iPairedSize, pairedSize);
    }

    public int getPairedSizeDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPairedSize);
    }

    public void setPairedSizeDecimal(RecordCursor cursor, int pairedSize) {
        setAsTinyDecimal(cursor, iPairedSize, pairedSize);
    }

    public long getPairedSizeWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPairedSize);
    }

    public void setPairedSizeWideDecimal(RecordCursor cursor, long pairedSize) {
        setAsWideDecimal(cursor, iPairedSize, pairedSize);
    }

    public int getImbalanceSize(RecordCursor cursor) {
        return getAsInt(cursor, iImbalanceSize);
    }

    public void setImbalanceSize(RecordCursor cursor, int imbalanceSize) {
        setAsInt(cursor, iImbalanceSize, imbalanceSize);
    }

    public long getImbalanceSizeLong(RecordCursor cursor) {
        return getAsLong(cursor, iImbalanceSize);
    }

    public void setImbalanceSizeLong(RecordCursor cursor, long imbalanceSize) {
        setAsLong(cursor, iImbalanceSize, imbalanceSize);
    }

    public double getImbalanceSizeDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iImbalanceSize);
    }

    public void setImbalanceSizeDouble(RecordCursor cursor, double imbalanceSize) {
        setAsDouble(cursor, iImbalanceSize, imbalanceSize);
    }

    public int getImbalanceSizeDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iImbalanceSize);
    }

    public void setImbalanceSizeDecimal(RecordCursor cursor, int imbalanceSize) {
        setAsTinyDecimal(cursor, iImbalanceSize, imbalanceSize);
    }

    public long getImbalanceSizeWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iImbalanceSize);
    }

    public void setImbalanceSizeWideDecimal(RecordCursor cursor, long imbalanceSize) {
        setAsWideDecimal(cursor, iImbalanceSize, imbalanceSize);
    }

    public double getNearPrice(RecordCursor cursor) {
        if (iNearPrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iNearPrice);
    }

    public void setNearPrice(RecordCursor cursor, double nearPrice) {
        if (iNearPrice < 0)
            return;
        setAsDouble(cursor, iNearPrice, nearPrice);
    }

    public int getNearPriceDecimal(RecordCursor cursor) {
        if (iNearPrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iNearPrice);
    }

    public void setNearPriceDecimal(RecordCursor cursor, int nearPrice) {
        if (iNearPrice < 0)
            return;
        setAsTinyDecimal(cursor, iNearPrice, nearPrice);
    }

    public long getNearPriceWideDecimal(RecordCursor cursor) {
        if (iNearPrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iNearPrice);
    }

    public void setNearPriceWideDecimal(RecordCursor cursor, long nearPrice) {
        if (iNearPrice < 0)
            return;
        setAsWideDecimal(cursor, iNearPrice, nearPrice);
    }

    public double getFarPrice(RecordCursor cursor) {
        if (iFarPrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iFarPrice);
    }

    public void setFarPrice(RecordCursor cursor, double farPrice) {
        if (iFarPrice < 0)
            return;
        setAsDouble(cursor, iFarPrice, farPrice);
    }

    public int getFarPriceDecimal(RecordCursor cursor) {
        if (iFarPrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iFarPrice);
    }

    public void setFarPriceDecimal(RecordCursor cursor, int farPrice) {
        if (iFarPrice < 0)
            return;
        setAsTinyDecimal(cursor, iFarPrice, farPrice);
    }

    public long getFarPriceWideDecimal(RecordCursor cursor) {
        if (iFarPrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iFarPrice);
    }

    public void setFarPriceWideDecimal(RecordCursor cursor, long farPrice) {
        if (iFarPrice < 0)
            return;
        setAsWideDecimal(cursor, iFarPrice, farPrice);
    }

    public int getFlags(RecordCursor cursor) {
        return getInt(cursor, iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        setInt(cursor, iFlags, flags);
    }
// END: CODE AUTOMATICALLY GENERATED
}
