/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.test.isolated.Isolated;
import com.devexperts.test.isolated.IsolatedParametersRunnerFactory;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderByMarketMakerAskDelegate;
import com.dxfeed.event.market.OrderByMarketMakerBidDelegate;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.QuoteDelegate;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=IsolatedParametersRunnerFactory.class)
@Isolated(value={"com.dxfeed.api", "com.dxfeed.event", "com.devexperts.qd"})
public class BidAskTimeMappingTest {
    public static final Logging log = Logging.getLogging(BidAskTimeMappingTest.class);
    @Parameterized.Parameter(value=0)
    public TimeUnit precision;
    @Parameterized.Parameter(value=1)
    public String property;
    private DataScheme scheme;
    private Properties oldProps;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({TimeUnit.SECONDS, ""}, {TimeUnit.SECONDS, "dxscheme.bat=seconds"}, {TimeUnit.MILLISECONDS, "dxscheme.bat=millis"});
    }

    @Before
    public void setup() {
        if (this.property.isEmpty()) {
            return;
        }
        this.oldProps = System.getProperties();
        System.setProperties((Properties)this.oldProps.clone());
        String[] kv = this.property.split("=", 2);
        System.setProperty(kv[0], kv[1]);
    }

    @After
    public void tearDown() {
        if (this.oldProps != null) {
            System.setProperties(this.oldProps);
        }
        this.oldProps = null;
    }

    @Test
    public void testMappings() {
        Assert.assertNull((Object)SystemProperties.getProperty((String)"scheme", null));
        this.scheme = QDFactory.createDefaultScheme((ClassLoader)this.getClass().getClassLoader());
        log.info("Internal digest: " + this.scheme.getDigest());
        this.doTestQuoteMapping();
        this.doTestMarketMakerMapping();
    }

    private void doTestQuoteMapping() {
        DataRecord quoteRecord = this.scheme.findRecordByName("Quote");
        RecordBuffer buffer = new RecordBuffer();
        QuoteDelegate quoteDelegate = new QuoteDelegate(quoteRecord, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB));
        Quote fromQuote = quoteDelegate.createEvent();
        fromQuote.setEventSymbol("AAPL");
        fromQuote.setAskExchangeCode('A');
        fromQuote.setBidExchangeCode('B');
        fromQuote.setAskTime(10123L);
        fromQuote.setBidTime(20456L);
        RecordCursor cursor = quoteDelegate.putEvent(fromQuote, buffer);
        Quote toQuote = (Quote)quoteDelegate.createEvent(cursor);
        if (this.precision == TimeUnit.MILLISECONDS) {
            Assert.assertEquals((long)fromQuote.getAskTime(), (long)toQuote.getAskTime());
            Assert.assertEquals((long)fromQuote.getBidTime(), (long)toQuote.getBidTime());
        } else {
            Assert.assertEquals((long)10000L, (long)toQuote.getAskTime());
            Assert.assertEquals((long)20000L, (long)toQuote.getBidTime());
        }
    }

    private void doTestMarketMakerMapping() {
        DataRecord quoteRecord = this.scheme.findRecordByName("MarketMaker");
        RecordBuffer buffer = new RecordBuffer();
        OrderByMarketMakerAskDelegate askDelegate = new OrderByMarketMakerAskDelegate(quoteRecord, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB));
        OrderByMarketMakerBidDelegate bidDelegate = new OrderByMarketMakerBidDelegate(quoteRecord, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB));
        MarketMakerMapping mapping = (MarketMakerMapping)quoteRecord.getMapping(MarketMakerMapping.class);
        String symbol = "XXX";
        RecordCursor cursor = buffer.add(quoteRecord, this.scheme.getCodec().encode(symbol), symbol);
        mapping.setAskTimeMillis(cursor, 10123L);
        mapping.setBidTimeMillis(cursor, 20456L);
        Order askOrder = (Order)askDelegate.createEvent(cursor);
        Order bidOrder = (Order)bidDelegate.createEvent(cursor);
        if (this.precision == TimeUnit.MILLISECONDS) {
            Assert.assertEquals((long)10123L, (long)askOrder.getTime());
            Assert.assertEquals((long)20456L, (long)bidOrder.getTime());
        } else {
            Assert.assertEquals((long)10000L, (long)askOrder.getTime());
            Assert.assertEquals((long)20000L, (long)bidOrder.getTime());
        }
    }
}

