/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderThreadingTest {
    private static final String SYMBOL = "TEST";
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private DXFeedSubscription<Order> sub;
    private final BlockingQueue<Order> queue = new ArrayBlockingQueue<Order>(10);
    private final ConcurrentLinkedQueue<Runnable> executorQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger counterCallback = new AtomicInteger(0);
    private final long t0 = System.currentTimeMillis() / 1000L * 1000L;
    private final long t1 = this.t0 - 1000L;
    private final long t2 = this.t0 + 1000L;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = this.feed.createSubscription(Order.class);
        this.endpoint.executor(this.executorQueue::add);
        this.sub.addEventListener(orders -> {
            this.counterCallback.getAndIncrement();
            this.queue.addAll(orders);
        });
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testConcurrency() {
        Runnable task;
        Quote composite = new Quote(SYMBOL);
        composite.setBidExchangeCode('A');
        composite.setBidPrice(12.34);
        composite.setBidSize(10L);
        composite.setBidTime(this.t0);
        composite.setAskExchangeCode('B');
        composite.setAskPrice(12.35);
        composite.setAskSize(11L);
        composite.setAskTime(this.t1);
        this.publisher.publishEvents(Collections.singleton(composite));
        Assert.assertEquals((long)1L, (long)this.executorQueue.size());
        Order order = new Order(SYMBOL);
        order.setScope(Scope.ORDER);
        order.setOrderSide(Side.SELL);
        order.setExchangeCode('C');
        order.setMarketMaker("NSDQ");
        order.setPrice(12.36);
        order.setSize(25L);
        order.setTime(this.t2);
        this.publisher.publishEvents(Collections.singleton(order));
        while ((task = this.executorQueue.poll()) != null) {
            task.run();
        }
        Assert.assertEquals((long)1L, (long)this.counterCallback.get());
        Assert.assertEquals((long)0L, (long)this.executorQueue.size());
        Assert.assertEquals((long)3L, (long)this.queue.size());
    }
}

