/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.custom;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.event.custom.impl.NuamOrderMapping;
import com.dxfeed.event.custom.impl.NuamTimeAndSaleMapping;
import com.dxfeed.event.custom.impl.NuamTradeMapping;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.impl.OrderBaseMapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public final class CustomFactoryImpl extends EventDelegateFactory implements RecordMappingFactory {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    @Override
    public void buildScheme(SchemeBuilder builder) {
        builder.addOptionalField("NuamTrade", "Last.Time", SerialFieldType.TIME_SECONDS, "NuamTrade", "Time", true);
        builder.addOptionalField("NuamTrade", "Last.Sequence", SerialFieldType.SEQUENCE, "NuamTrade", "Sequence", true);
        builder.addOptionalField("NuamTrade", "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "NuamTrade", "TimeNanoPart", false);
        builder.addOptionalField("NuamTrade", "Last.Exchange", SerialFieldType.UTF_CHAR, "NuamTrade", "ExchangeCode", true);
        builder.addRequiredField("NuamTrade", "Last.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTrade", "Last.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("NuamTrade", "Last.Tick", SerialFieldType.COMPACT_INT, "NuamTrade", "Tick", true);
        builder.addOptionalField("NuamTrade", "Last.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "NuamTrade", "Change", true);
        builder.addOptionalField("NuamTrade", "DayId", SerialFieldType.DATE, "NuamTrade", "DayId", true);
        builder.addOptionalField("NuamTrade", "Volume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "NuamTrade", "DayVolume", true);
        builder.addOptionalField("NuamTrade", "DayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "NuamTrade", "DayTurnover", true);
        builder.addOptionalField("NuamTrade", "Last.Flags", SerialFieldType.COMPACT_INT, "NuamTrade", "Flags", true);
        builder.addOptionalField("NuamTrade", "TradeId", SerialFieldType.LONG, "NuamTrade", "TradeId", true);
        builder.addOptionalField("NuamTrade", "Date", SerialFieldType.COMPACT_INT, "NuamTrade", "Date", SystemProperties.getBooleanProperty("reuters.phantom", false));
        builder.addOptionalField("NuamTrade", "Operation", SerialFieldType.COMPACT_INT, "NuamTrade", "Operation", SystemProperties.getBooleanProperty("reuters.phantom", false));
        builder.addRequiredField("NuamTrade", "TradeStatTime", SerialFieldType.TIME_MILLIS);
        builder.addRequiredField("NuamTrade", "LastSignificantPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTrade", "LastPriceForAll", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTrade", "NumberOfTrades", SerialFieldType.COMPACT_INT);
        builder.addRequiredField("NuamTrade", "VWAP", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        for (char exchange : getExchanges("com.dxfeed.event.custom.impl.NuamTrade.exchanges")) {
            String recordName = "NuamTrade&" + exchange;
            builder.addOptionalField(recordName, "Last.Time", SerialFieldType.TIME_SECONDS, "NuamTrade", "Time", true);
            builder.addOptionalField(recordName, "Last.Sequence", SerialFieldType.SEQUENCE, "NuamTrade", "Sequence", true);
            builder.addOptionalField(recordName, "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "NuamTrade", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "Last.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Last.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "Last.Tick", SerialFieldType.COMPACT_INT, "NuamTrade", "Tick", true);
            builder.addOptionalField(recordName, "Last.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "NuamTrade", "Change", true);
            builder.addOptionalField(recordName, "DayId", SerialFieldType.DATE, "NuamTrade", "DayId", true);
            builder.addOptionalField(recordName, "Volume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "NuamTrade", "DayVolume", true);
            builder.addOptionalField(recordName, "DayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "NuamTrade", "DayTurnover", true);
            builder.addOptionalField(recordName, "Last.Flags", SerialFieldType.COMPACT_INT, "NuamTrade", "Flags", true);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "NuamTrade", "TradeId", true);
            builder.addRequiredField(recordName, "TradeStatTime", SerialFieldType.TIME_MILLIS);
            builder.addRequiredField(recordName, "LastSignificantPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "LastPriceForAll", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "NumberOfTrades", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "VWAP", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        }

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.custom.impl.NuamOrder.suffixes", "|#NUAM|#nuam").split("\\|")) {
            String recordName = "NuamOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "NuamOrder", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "NuamOrder", "ActionTime", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "NuamOrder", "OrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "NuamOrder", "AuxOrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "NuamOrder", "ExecutedSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "Count", selectDecimal(SerialFieldType.COMPACT_INT), "NuamOrder", "Count", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.NuamOrder.suffixes.count", "")));
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "NuamOrder", "TradeId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradePrice", selectDecimal(SerialFieldType.DECIMAL), "NuamOrder", "TradePrice", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradeSize", selectDecimal(SerialFieldType.DECIMAL), "NuamOrder", "TradeSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "ActorId", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "ParticipantId", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "SubmitterId", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "OnBehalfOfSubmitterId", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "ClientOrderId", SerialFieldType.UTF_CHAR_ARRAY);
            builder.addRequiredField(recordName, "CustomerAccount", SerialFieldType.UTF_CHAR_ARRAY);
            builder.addRequiredField(recordName, "CustomerInfo", SerialFieldType.UTF_CHAR_ARRAY);
            builder.addRequiredField(recordName, "ExchangeInfo", SerialFieldType.UTF_CHAR_ARRAY);
            builder.addRequiredField(recordName, "TimeInForceData", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "TriggerOrderBookId", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "TriggerPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "TriggerSessionType", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "OrderQuantity", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "DisplayQuantity", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "RefreshQuantity", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "LeavesQuantity", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "MatchedQuantity", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "NuamFlags", SerialFieldType.COMPACT_INT);
        }

        builder.addRequiredField("NuamTimeAndSale", "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("NuamTimeAndSale", "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("NuamTimeAndSale", "TimeNanoPart", SerialFieldType.COMPACT_INT, "NuamTimeAndSale", "TimeNanoPart", false);
        builder.addRequiredField("NuamTimeAndSale", "Exchange", SerialFieldType.UTF_CHAR);
        builder.addRequiredField("NuamTimeAndSale", "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTimeAndSale", "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addRequiredField("NuamTimeAndSale", "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTimeAndSale", "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("NuamTimeAndSale", "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
        builder.addRequiredField("NuamTimeAndSale", "Flags", SerialFieldType.COMPACT_INT);
        builder.addOptionalField("NuamTimeAndSale", "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "NuamTimeAndSale", "Buyer", false);
        builder.addOptionalField("NuamTimeAndSale", "Seller", SerialFieldType.UTF_CHAR_ARRAY, "NuamTimeAndSale", "Seller", false);
        builder.addRequiredField("NuamTimeAndSale", "TradeId", SerialFieldType.LONG);
        builder.addRequiredField("NuamTimeAndSale", "MatchId", SerialFieldType.LONG);
        for (char exchange : getExchanges("com.dxfeed.event.custom.impl.NuamTimeAndSale.exchanges")) {
            String recordName = "NuamTimeAndSale&" + exchange;
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "NuamTimeAndSale", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "Exchange", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "NuamTimeAndSale", "Buyer", false);
            builder.addOptionalField(recordName, "Seller", SerialFieldType.UTF_CHAR_ARRAY, "NuamTimeAndSale", "Seller", false);
            builder.addRequiredField(recordName, "TradeId", SerialFieldType.LONG);
            builder.addRequiredField(recordName, "MatchId", SerialFieldType.LONG);
        }
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(NuamTradeMapping.class) != null) {
            result.add(new NuamTradeDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new NuamTradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(NuamOrderMapping.class) != null) {
            result.add(new NuamOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new NuamOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(NuamTimeAndSaleMapping.class) != null) {
            result.add(new NuamTimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new NuamTimeAndSaleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(NuamTradeMapping.class) != null) {
            result.add(new NuamTradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(NuamOrderMapping.class) != null) {
            result.add(new NuamOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(NuamTimeAndSaleMapping.class) != null) {
            result.add(new NuamTimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = getBaseRecordName(record.getName());
        if (baseRecordName.equals("NuamTrade"))
            return new NuamTradeMapping(record);
        if (baseRecordName.equals("NuamOrder"))
            return new NuamOrderMapping(record);
        if (baseRecordName.equals("NuamTimeAndSale"))
            return new NuamTimeAndSaleMapping(record);
        return null;
    }
// END: CODE AUTOMATICALLY GENERATED

    @Override
    protected String getBaseRecordName(String recordName) {
        String s = MarketEventSymbols.getBaseSymbol(recordName);
        int i = s.lastIndexOf(OrderBaseMapping.SOURCE_ID_SEPARATOR);
        return i < 0 ? s : s.substring(0, i);
    }
}
