/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.AuctionType;
import com.dxfeed.event.market.ImbalanceSide;
import com.dxfeed.event.market.OrderImbalance;
import com.dxfeed.event.market.OrderSource;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderImbalanceTest {
    private static final String SYMBOL = "TEST";
    private static final OrderSource SOURCE = OrderSource.NUAM;
    private static final long TIME = 1752675383000L;
    private final Queue<OrderImbalance> receivedEvents = new ArrayDeque<OrderImbalance>();
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<OrderImbalance> sub;

    @Before
    public void setUp() {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.endpoint.executor(Runnable::run);
        this.publisher = this.endpoint.getPublisher();
        this.sub = this.endpoint.getFeed().createSubscription(OrderImbalance.class);
        this.sub.addEventListener(this.receivedEvents::addAll);
    }

    @After
    public void tearDown() {
        this.sub.close();
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testOrderImbalanceWithSource() {
        this.sub.addSymbols((Object)new IndexedEventSubscriptionSymbol((Object)SYMBOL, (IndexedEventSource)SOURCE));
        OrderImbalance imbalance = this.createOrderImbalance();
        imbalance.setSource(SOURCE);
        this.publisher.publishEvents(Collections.singleton(imbalance));
        this.assertEvent(imbalance, this.receivedEvents.poll());
        imbalance.setSource(OrderSource.DEFAULT);
        this.publisher.publishEvents(Collections.singleton(imbalance));
        Assert.assertTrue((boolean)this.receivedEvents.isEmpty());
    }

    @Test
    public void testOrderImbalanceWithoutSource() {
        this.sub.addSymbols((Object)SYMBOL);
        OrderImbalance imbalance = this.createOrderImbalance();
        imbalance.setSource(SOURCE);
        this.publisher.publishEvents(Collections.singleton(imbalance));
        this.assertEvent(imbalance, this.receivedEvents.poll());
        imbalance.setSource(OrderSource.DEFAULT);
        this.publisher.publishEvents(Collections.singleton(imbalance));
        this.assertEvent(imbalance, this.receivedEvents.poll());
    }

    private OrderImbalance createOrderImbalance() {
        OrderImbalance imbalance = new OrderImbalance(SYMBOL);
        imbalance.setTime(1752675383000L);
        imbalance.setSequence(2);
        imbalance.setRefPrice(1.2);
        imbalance.setPairedSize(3.4);
        imbalance.setImbalanceSize(5.6);
        imbalance.setNearPrice(7.8);
        imbalance.setFarPrice(9.0);
        imbalance.setImbalanceSide(ImbalanceSide.BUY);
        imbalance.setAuctionType(AuctionType.OTHER);
        return imbalance;
    }

    private void assertEvent(OrderImbalance expected, OrderImbalance actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)expected.getEventSymbol(), (Object)actual.getEventSymbol());
        Assert.assertEquals((Object)expected.getSource(), (Object)actual.getSource());
        Assert.assertEquals((long)1752675383000L, (long)actual.getTime());
        Assert.assertEquals((long)expected.getSequence(), (long)actual.getSequence());
        Assert.assertEquals((double)expected.getPairedSize(), (double)actual.getPairedSize(), (double)0.0);
        Assert.assertEquals((double)expected.getImbalanceSize(), (double)actual.getImbalanceSize(), (double)0.0);
        Assert.assertEquals((double)expected.getNearPrice(), (double)actual.getNearPrice(), (double)0.0);
        Assert.assertEquals((double)expected.getFarPrice(), (double)actual.getFarPrice(), (double)0.0);
        Assert.assertEquals((double)expected.getRefPrice(), (double)actual.getRefPrice(), (double)0.0);
        Assert.assertEquals((Object)expected.getImbalanceSide(), (Object)actual.getImbalanceSide());
        Assert.assertEquals((Object)expected.getAuctionType(), (Object)actual.getAuctionType());
    }
}

