/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.impl.OrderImbalanceMapping;

import java.util.EnumSet;

public final class OrderImbalanceDelegate extends OrderImbalanceDelegateImpl<OrderImbalance> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final OrderImbalanceMapping m;

    public OrderImbalanceDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(OrderImbalanceMapping.class);
    }

    @Override
    public OrderImbalanceMapping getMapping() {
        return m;
    }

    @Override
    public OrderImbalance createEvent() {
        return new OrderImbalance();
    }

    @Override
    public OrderImbalance getEvent(OrderImbalance event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setSource(m.getRecordSource());
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setRefPrice(m.getRefPrice(cursor));
        event.setPairedSize(m.getPairedSizeDouble(cursor));
        event.setImbalanceSize(m.getImbalanceSizeDouble(cursor));
        event.setNearPrice(m.getNearPrice(cursor));
        event.setFarPrice(m.getFarPrice(cursor));
        event.setFlags(m.getFlags(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(OrderImbalance event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setRefPrice(cursor, event.getRefPrice());
        m.setPairedSizeDouble(cursor, event.getPairedSize());
        m.setImbalanceSizeDouble(cursor, event.getImbalanceSize());
        m.setNearPrice(cursor, event.getNearPrice());
        m.setFarPrice(cursor, event.getFarPrice());
        m.setFlags(cursor, event.getFlags());
        return cursor;
    }

    @Override
    public IndexedEventSource getSource() {
        return m.getRecordSource();
    }
// END: CODE AUTOMATICALLY GENERATED
}
