/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2022 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.qd.util.ShortString;
import com.devexperts.util.TimeUtil;

public class OptionSaleMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iIndex;
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iExchangeCode;
    private final int iPrice;
    private final int iSize;
    private final int iBidPrice;
    private final int iAskPrice;
    private final int iExchangeSaleConditions;
    private final int iFlags;
    private final int iUnderlyingPrice;
    private final int iVolatility;
    private final int iDelta;
    private final int oOptionSymbol;

    public OptionSaleMapping(DataRecord record) {
        super(record);
        iIndex = MappingUtil.findIntField(record, "Index", true);
        iTime = MappingUtil.findIntField(record, "Time", true);
        iSequence = MappingUtil.findIntField(record, "Sequence", true);
        iTimeNanoPart = MappingUtil.findIntField(record, "TimeNanoPart", false);
        iExchangeCode = MappingUtil.findIntField(record, "ExchangeCode", true);
        iPrice = findIntField("Price", true);
        iSize = findIntField("Size", true);
        iBidPrice = findIntField("BidPrice", true);
        iAskPrice = findIntField("AskPrice", true);
        iExchangeSaleConditions = MappingUtil.findIntField(record, "ExchangeSaleConditions", true);
        iFlags = MappingUtil.findIntField(record, "Flags", true);
        iUnderlyingPrice = findIntField("UnderlyingPrice", true);
        iVolatility = findIntField("Volatility", true);
        iDelta = findIntField("Delta", true);
        oOptionSymbol = MappingUtil.findObjField(record, "OptionSymbol", true);
    }

    public int getIndex(RecordCursor cursor) {
        return getInt(cursor, iIndex);
    }

    public void setIndex(RecordCursor cursor, int index) {
        setInt(cursor, iIndex, index);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        setInt(cursor, iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return getInt(cursor, iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        setInt(cursor, iSequence, sequence);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (iTimeNanoPart < 0)
            return 0;
        return getInt(cursor, iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (iTimeNanoPart < 0)
            return;
        setInt(cursor, iTimeNanoPart, timeNanoPart);
    }

    public char getExchangeCode(RecordCursor cursor) {
        return (char) getInt(cursor, iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        setInt(cursor, iExchangeCode, exchangeCode);
    }

    public double getPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        setAsDouble(cursor, iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        setAsTinyDecimal(cursor, iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        setAsWideDecimal(cursor, iPrice, price);
    }

    public long getSize(RecordCursor cursor) {
        return getAsLong(cursor, iSize);
    }

    public void setSize(RecordCursor cursor, long size) {
        setAsLong(cursor, iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return getAsDouble(cursor, iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        setAsDouble(cursor, iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        setAsTinyDecimal(cursor, iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        setAsWideDecimal(cursor, iSize, size);
    }

    public double getBidPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iBidPrice);
    }

    public void setBidPrice(RecordCursor cursor, double bidPrice) {
        setAsDouble(cursor, iBidPrice, bidPrice);
    }

    public int getBidPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iBidPrice);
    }

    public void setBidPriceDecimal(RecordCursor cursor, int bidPrice) {
        setAsTinyDecimal(cursor, iBidPrice, bidPrice);
    }

    public long getBidPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iBidPrice);
    }

    public void setBidPriceWideDecimal(RecordCursor cursor, long bidPrice) {
        setAsWideDecimal(cursor, iBidPrice, bidPrice);
    }

    public double getAskPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iAskPrice);
    }

    public void setAskPrice(RecordCursor cursor, double askPrice) {
        setAsDouble(cursor, iAskPrice, askPrice);
    }

    public int getAskPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iAskPrice);
    }

    public void setAskPriceDecimal(RecordCursor cursor, int askPrice) {
        setAsTinyDecimal(cursor, iAskPrice, askPrice);
    }

    public long getAskPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iAskPrice);
    }

    public void setAskPriceWideDecimal(RecordCursor cursor, long askPrice) {
        setAsWideDecimal(cursor, iAskPrice, askPrice);
    }

    public String getExchangeSaleConditionsString(RecordCursor cursor) {
        return ShortString.decode(getInt(cursor, iExchangeSaleConditions));
    }

    public void setExchangeSaleConditionsString(RecordCursor cursor, String exchangeSaleConditions) {
        setInt(cursor, iExchangeSaleConditions, (int) ShortString.encode(exchangeSaleConditions));
    }

    public int getExchangeSaleConditions(RecordCursor cursor) {
        return getInt(cursor, iExchangeSaleConditions);
    }

    public void setExchangeSaleConditions(RecordCursor cursor, int exchangeSaleConditions) {
        setInt(cursor, iExchangeSaleConditions, exchangeSaleConditions);
    }

    public int getFlags(RecordCursor cursor) {
        return getInt(cursor, iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        setInt(cursor, iFlags, flags);
    }

    public double getUnderlyingPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iUnderlyingPrice);
    }

    public void setUnderlyingPrice(RecordCursor cursor, double underlyingPrice) {
        setAsDouble(cursor, iUnderlyingPrice, underlyingPrice);
    }

    public int getUnderlyingPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iUnderlyingPrice);
    }

    public void setUnderlyingPriceDecimal(RecordCursor cursor, int underlyingPrice) {
        setAsTinyDecimal(cursor, iUnderlyingPrice, underlyingPrice);
    }

    public long getUnderlyingPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iUnderlyingPrice);
    }

    public void setUnderlyingPriceWideDecimal(RecordCursor cursor, long underlyingPrice) {
        setAsWideDecimal(cursor, iUnderlyingPrice, underlyingPrice);
    }

    public double getVolatility(RecordCursor cursor) {
        return getAsDouble(cursor, iVolatility);
    }

    public void setVolatility(RecordCursor cursor, double volatility) {
        setAsDouble(cursor, iVolatility, volatility);
    }

    public int getVolatilityDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iVolatility);
    }

    public void setVolatilityDecimal(RecordCursor cursor, int volatility) {
        setAsTinyDecimal(cursor, iVolatility, volatility);
    }

    public long getVolatilityWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iVolatility);
    }

    public void setVolatilityWideDecimal(RecordCursor cursor, long volatility) {
        setAsWideDecimal(cursor, iVolatility, volatility);
    }

    public double getDelta(RecordCursor cursor) {
        return getAsDouble(cursor, iDelta);
    }

    public void setDelta(RecordCursor cursor, double delta) {
        setAsDouble(cursor, iDelta, delta);
    }

    public int getDeltaDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iDelta);
    }

    public void setDeltaDecimal(RecordCursor cursor, int delta) {
        setAsTinyDecimal(cursor, iDelta, delta);
    }

    public long getDeltaWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iDelta);
    }

    public void setDeltaWideDecimal(RecordCursor cursor, long delta) {
        setAsWideDecimal(cursor, iDelta, delta);
    }

    public String getOptionSymbol(RecordCursor cursor) {
        return (String) getObj(cursor, oOptionSymbol);
    }

    public void setOptionSymbol(RecordCursor cursor, String optionSymbol) {
        setObj(cursor, oOptionSymbol, optionSymbol);
    }
// END: CODE AUTOMATICALLY GENERATED
}
