/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class ProfileMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iBeta;
    private final int iEps;
    private final int iDivFreq;
    private final int iExdDivAmount;
    private final int iExdDivDate;
    private final int iHighPrice52;
    private final int iLowPrice52;
    private final int iShares;
    private final int iFreeFloat;
    private final int iHighLimitPrice;
    private final int iLowLimitPrice;
    private final int iHaltStartTime;
    private final int iHaltEndTime;
    private final int iFlags;
    private final int oDescription;
    private final int oStatusReason;

    public ProfileMapping(DataRecord record) {
        super(record);
        iBeta = findIntField("Beta", false);
        iEps = findIntField("Eps", false);
        iDivFreq = findIntField("DivFreq", false);
        iExdDivAmount = findIntField("ExdDiv.Amount", false);
        iExdDivDate = MappingUtil.findIntField(record, "ExdDiv.Date", false);
        iHighPrice52 = findIntField("52High.Price", false);
        iLowPrice52 = findIntField("52Low.Price", false);
        iShares = findIntField("Shares", false);
        iFreeFloat = findIntField("FreeFloat", false);
        iHighLimitPrice = findIntField("HighLimitPrice", false);
        iLowLimitPrice = findIntField("LowLimitPrice", false);
        iHaltStartTime = MappingUtil.findIntField(record, "Halt.StartTime", false);
        iHaltEndTime = MappingUtil.findIntField(record, "Halt.EndTime", false);
        iFlags = MappingUtil.findIntField(record, "Flags", false);
        oDescription = MappingUtil.findObjField(record, "Description", true);
        oStatusReason = MappingUtil.findObjField(record, "StatusReason", false);
        putNonDefaultPropertyName("52High.Price", "HighPrice52");
        putNonDefaultPropertyName("52Low.Price", "LowPrice52");
    }

    public double getBeta(RecordCursor cursor) {
        if (iBeta < 0)
            return Double.NaN;
        return getAsDouble(cursor, iBeta);
    }

    public void setBeta(RecordCursor cursor, double beta) {
        if (iBeta < 0)
            return;
        setAsDouble(cursor, iBeta, beta);
    }

    public int getBetaDecimal(RecordCursor cursor) {
        if (iBeta < 0)
            return 0;
        return getAsTinyDecimal(cursor, iBeta);
    }

    public void setBetaDecimal(RecordCursor cursor, int beta) {
        if (iBeta < 0)
            return;
        setAsTinyDecimal(cursor, iBeta, beta);
    }

    public long getBetaWideDecimal(RecordCursor cursor) {
        if (iBeta < 0)
            return 0;
        return getAsWideDecimal(cursor, iBeta);
    }

    public void setBetaWideDecimal(RecordCursor cursor, long beta) {
        if (iBeta < 0)
            return;
        setAsWideDecimal(cursor, iBeta, beta);
    }

    public double getEps(RecordCursor cursor) {
        if (iEps < 0)
            return Double.NaN;
        return getAsDouble(cursor, iEps);
    }

    public void setEps(RecordCursor cursor, double eps) {
        if (iEps < 0)
            return;
        setAsDouble(cursor, iEps, eps);
    }

    public int getEpsDecimal(RecordCursor cursor) {
        if (iEps < 0)
            return 0;
        return getAsTinyDecimal(cursor, iEps);
    }

    public void setEpsDecimal(RecordCursor cursor, int eps) {
        if (iEps < 0)
            return;
        setAsTinyDecimal(cursor, iEps, eps);
    }

    public long getEpsWideDecimal(RecordCursor cursor) {
        if (iEps < 0)
            return 0;
        return getAsWideDecimal(cursor, iEps);
    }

    public void setEpsWideDecimal(RecordCursor cursor, long eps) {
        if (iEps < 0)
            return;
        setAsWideDecimal(cursor, iEps, eps);
    }

    public int getDivFreq(RecordCursor cursor) {
        if (iDivFreq < 0)
            return 0;
        return getAsInt(cursor, iDivFreq);
    }

    public void setDivFreq(RecordCursor cursor, int divFreq) {
        if (iDivFreq < 0)
            return;
        setAsInt(cursor, iDivFreq, divFreq);
    }

    public long getDivFreqLong(RecordCursor cursor) {
        if (iDivFreq < 0)
            return 0;
        return getAsLong(cursor, iDivFreq);
    }

    public void setDivFreqLong(RecordCursor cursor, long divFreq) {
        if (iDivFreq < 0)
            return;
        setAsLong(cursor, iDivFreq, divFreq);
    }

    public double getDivFreqDouble(RecordCursor cursor) {
        if (iDivFreq < 0)
            return Double.NaN;
        return getAsDouble(cursor, iDivFreq);
    }

    public void setDivFreqDouble(RecordCursor cursor, double divFreq) {
        if (iDivFreq < 0)
            return;
        setAsDouble(cursor, iDivFreq, divFreq);
    }

    public int getDivFreqDecimal(RecordCursor cursor) {
        if (iDivFreq < 0)
            return 0;
        return getAsTinyDecimal(cursor, iDivFreq);
    }

    public void setDivFreqDecimal(RecordCursor cursor, int divFreq) {
        if (iDivFreq < 0)
            return;
        setAsTinyDecimal(cursor, iDivFreq, divFreq);
    }

    public long getDivFreqWideDecimal(RecordCursor cursor) {
        if (iDivFreq < 0)
            return 0;
        return getAsWideDecimal(cursor, iDivFreq);
    }

    public void setDivFreqWideDecimal(RecordCursor cursor, long divFreq) {
        if (iDivFreq < 0)
            return;
        setAsWideDecimal(cursor, iDivFreq, divFreq);
    }

    public double getExdDivAmount(RecordCursor cursor) {
        if (iExdDivAmount < 0)
            return Double.NaN;
        return getAsDouble(cursor, iExdDivAmount);
    }

    public void setExdDivAmount(RecordCursor cursor, double exdDivAmount) {
        if (iExdDivAmount < 0)
            return;
        setAsDouble(cursor, iExdDivAmount, exdDivAmount);
    }

    public int getExdDivAmountDecimal(RecordCursor cursor) {
        if (iExdDivAmount < 0)
            return 0;
        return getAsTinyDecimal(cursor, iExdDivAmount);
    }

    public void setExdDivAmountDecimal(RecordCursor cursor, int exdDivAmount) {
        if (iExdDivAmount < 0)
            return;
        setAsTinyDecimal(cursor, iExdDivAmount, exdDivAmount);
    }

    public long getExdDivAmountWideDecimal(RecordCursor cursor) {
        if (iExdDivAmount < 0)
            return 0;
        return getAsWideDecimal(cursor, iExdDivAmount);
    }

    public void setExdDivAmountWideDecimal(RecordCursor cursor, long exdDivAmount) {
        if (iExdDivAmount < 0)
            return;
        setAsWideDecimal(cursor, iExdDivAmount, exdDivAmount);
    }

    public int getExdDivDate(RecordCursor cursor) {
        if (iExdDivDate < 0)
            return 0;
        return getInt(cursor, iExdDivDate);
    }

    public void setExdDivDate(RecordCursor cursor, int exdDivDate) {
        if (iExdDivDate < 0)
            return;
        setInt(cursor, iExdDivDate, exdDivDate);
    }

    @Deprecated
    public double get52HighPrice(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return Double.NaN;
        return getAsDouble(cursor, iHighPrice52);
    }

    @Deprecated
    public void set52HighPrice(RecordCursor cursor, double _52HighPrice) {
        if (iHighPrice52 < 0)
            return;
        setAsDouble(cursor, iHighPrice52, _52HighPrice);
    }

    @Deprecated
    public int get52HighPriceDecimal(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return 0;
        return getAsTinyDecimal(cursor, iHighPrice52);
    }

    @Deprecated
    public void set52HighPriceDecimal(RecordCursor cursor, int _52HighPrice) {
        if (iHighPrice52 < 0)
            return;
        setAsTinyDecimal(cursor, iHighPrice52, _52HighPrice);
    }

    @Deprecated
    public long get52HighPriceWideDecimal(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return 0;
        return getAsWideDecimal(cursor, iHighPrice52);
    }

    @Deprecated
    public void set52HighPriceWideDecimal(RecordCursor cursor, long _52HighPrice) {
        if (iHighPrice52 < 0)
            return;
        setAsWideDecimal(cursor, iHighPrice52, _52HighPrice);
    }

    public double getHighPrice52(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return Double.NaN;
        return getAsDouble(cursor, iHighPrice52);
    }

    public void setHighPrice52(RecordCursor cursor, double highPrice52) {
        if (iHighPrice52 < 0)
            return;
        setAsDouble(cursor, iHighPrice52, highPrice52);
    }

    public int getHighPrice52Decimal(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return 0;
        return getAsTinyDecimal(cursor, iHighPrice52);
    }

    public void setHighPrice52Decimal(RecordCursor cursor, int highPrice52) {
        if (iHighPrice52 < 0)
            return;
        setAsTinyDecimal(cursor, iHighPrice52, highPrice52);
    }

    public long getHighPrice52WideDecimal(RecordCursor cursor) {
        if (iHighPrice52 < 0)
            return 0;
        return getAsWideDecimal(cursor, iHighPrice52);
    }

    public void setHighPrice52WideDecimal(RecordCursor cursor, long highPrice52) {
        if (iHighPrice52 < 0)
            return;
        setAsWideDecimal(cursor, iHighPrice52, highPrice52);
    }

    @Deprecated
    public double get52LowPrice(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return Double.NaN;
        return getAsDouble(cursor, iLowPrice52);
    }

    @Deprecated
    public void set52LowPrice(RecordCursor cursor, double _52LowPrice) {
        if (iLowPrice52 < 0)
            return;
        setAsDouble(cursor, iLowPrice52, _52LowPrice);
    }

    @Deprecated
    public int get52LowPriceDecimal(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return 0;
        return getAsTinyDecimal(cursor, iLowPrice52);
    }

    @Deprecated
    public void set52LowPriceDecimal(RecordCursor cursor, int _52LowPrice) {
        if (iLowPrice52 < 0)
            return;
        setAsTinyDecimal(cursor, iLowPrice52, _52LowPrice);
    }

    @Deprecated
    public long get52LowPriceWideDecimal(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return 0;
        return getAsWideDecimal(cursor, iLowPrice52);
    }

    @Deprecated
    public void set52LowPriceWideDecimal(RecordCursor cursor, long _52LowPrice) {
        if (iLowPrice52 < 0)
            return;
        setAsWideDecimal(cursor, iLowPrice52, _52LowPrice);
    }

    public double getLowPrice52(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return Double.NaN;
        return getAsDouble(cursor, iLowPrice52);
    }

    public void setLowPrice52(RecordCursor cursor, double lowPrice52) {
        if (iLowPrice52 < 0)
            return;
        setAsDouble(cursor, iLowPrice52, lowPrice52);
    }

    public int getLowPrice52Decimal(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return 0;
        return getAsTinyDecimal(cursor, iLowPrice52);
    }

    public void setLowPrice52Decimal(RecordCursor cursor, int lowPrice52) {
        if (iLowPrice52 < 0)
            return;
        setAsTinyDecimal(cursor, iLowPrice52, lowPrice52);
    }

    public long getLowPrice52WideDecimal(RecordCursor cursor) {
        if (iLowPrice52 < 0)
            return 0;
        return getAsWideDecimal(cursor, iLowPrice52);
    }

    public void setLowPrice52WideDecimal(RecordCursor cursor, long lowPrice52) {
        if (iLowPrice52 < 0)
            return;
        setAsWideDecimal(cursor, iLowPrice52, lowPrice52);
    }

    public long getShares(RecordCursor cursor) {
        if (iShares < 0)
            return 0;
        return getAsLong(cursor, iShares);
    }

    public void setShares(RecordCursor cursor, long shares) {
        if (iShares < 0)
            return;
        setAsLong(cursor, iShares, shares);
    }

    public double getSharesDouble(RecordCursor cursor) {
        if (iShares < 0)
            return Double.NaN;
        return getAsDouble(cursor, iShares);
    }

    public void setSharesDouble(RecordCursor cursor, double shares) {
        if (iShares < 0)
            return;
        setAsDouble(cursor, iShares, shares);
    }

    public int getSharesDecimal(RecordCursor cursor) {
        if (iShares < 0)
            return 0;
        return getAsTinyDecimal(cursor, iShares);
    }

    public void setSharesDecimal(RecordCursor cursor, int shares) {
        if (iShares < 0)
            return;
        setAsTinyDecimal(cursor, iShares, shares);
    }

    public long getSharesWideDecimal(RecordCursor cursor) {
        if (iShares < 0)
            return 0;
        return getAsWideDecimal(cursor, iShares);
    }

    public void setSharesWideDecimal(RecordCursor cursor, long shares) {
        if (iShares < 0)
            return;
        setAsWideDecimal(cursor, iShares, shares);
    }

    public long getFreeFloat(RecordCursor cursor) {
        if (iFreeFloat < 0)
            return 0;
        return getAsLong(cursor, iFreeFloat);
    }

    public void setFreeFloat(RecordCursor cursor, long freeFloat) {
        if (iFreeFloat < 0)
            return;
        setAsLong(cursor, iFreeFloat, freeFloat);
    }

    public double getFreeFloatDouble(RecordCursor cursor) {
        if (iFreeFloat < 0)
            return Double.NaN;
        return getAsDouble(cursor, iFreeFloat);
    }

    public void setFreeFloatDouble(RecordCursor cursor, double freeFloat) {
        if (iFreeFloat < 0)
            return;
        setAsDouble(cursor, iFreeFloat, freeFloat);
    }

    public int getFreeFloatDecimal(RecordCursor cursor) {
        if (iFreeFloat < 0)
            return 0;
        return getAsTinyDecimal(cursor, iFreeFloat);
    }

    public void setFreeFloatDecimal(RecordCursor cursor, int freeFloat) {
        if (iFreeFloat < 0)
            return;
        setAsTinyDecimal(cursor, iFreeFloat, freeFloat);
    }

    public long getFreeFloatWideDecimal(RecordCursor cursor) {
        if (iFreeFloat < 0)
            return 0;
        return getAsWideDecimal(cursor, iFreeFloat);
    }

    public void setFreeFloatWideDecimal(RecordCursor cursor, long freeFloat) {
        if (iFreeFloat < 0)
            return;
        setAsWideDecimal(cursor, iFreeFloat, freeFloat);
    }

    public double getHighLimitPrice(RecordCursor cursor) {
        if (iHighLimitPrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iHighLimitPrice);
    }

    public void setHighLimitPrice(RecordCursor cursor, double highLimitPrice) {
        if (iHighLimitPrice < 0)
            return;
        setAsDouble(cursor, iHighLimitPrice, highLimitPrice);
    }

    public int getHighLimitPriceDecimal(RecordCursor cursor) {
        if (iHighLimitPrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iHighLimitPrice);
    }

    public void setHighLimitPriceDecimal(RecordCursor cursor, int highLimitPrice) {
        if (iHighLimitPrice < 0)
            return;
        setAsTinyDecimal(cursor, iHighLimitPrice, highLimitPrice);
    }

    public long getHighLimitPriceWideDecimal(RecordCursor cursor) {
        if (iHighLimitPrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iHighLimitPrice);
    }

    public void setHighLimitPriceWideDecimal(RecordCursor cursor, long highLimitPrice) {
        if (iHighLimitPrice < 0)
            return;
        setAsWideDecimal(cursor, iHighLimitPrice, highLimitPrice);
    }

    public double getLowLimitPrice(RecordCursor cursor) {
        if (iLowLimitPrice < 0)
            return Double.NaN;
        return getAsDouble(cursor, iLowLimitPrice);
    }

    public void setLowLimitPrice(RecordCursor cursor, double lowLimitPrice) {
        if (iLowLimitPrice < 0)
            return;
        setAsDouble(cursor, iLowLimitPrice, lowLimitPrice);
    }

    public int getLowLimitPriceDecimal(RecordCursor cursor) {
        if (iLowLimitPrice < 0)
            return 0;
        return getAsTinyDecimal(cursor, iLowLimitPrice);
    }

    public void setLowLimitPriceDecimal(RecordCursor cursor, int lowLimitPrice) {
        if (iLowLimitPrice < 0)
            return;
        setAsTinyDecimal(cursor, iLowLimitPrice, lowLimitPrice);
    }

    public long getLowLimitPriceWideDecimal(RecordCursor cursor) {
        if (iLowLimitPrice < 0)
            return 0;
        return getAsWideDecimal(cursor, iLowLimitPrice);
    }

    public void setLowLimitPriceWideDecimal(RecordCursor cursor, long lowLimitPrice) {
        if (iLowLimitPrice < 0)
            return;
        setAsWideDecimal(cursor, iLowLimitPrice, lowLimitPrice);
    }

    public long getHaltStartTimeMillis(RecordCursor cursor) {
        if (iHaltStartTime < 0)
            return 0;
        return getInt(cursor, iHaltStartTime) * 1000L;
    }

    public void setHaltStartTimeMillis(RecordCursor cursor, long haltStartTime) {
        if (iHaltStartTime < 0)
            return;
        setInt(cursor, iHaltStartTime, TimeUtil.getSecondsFromTime(haltStartTime));
    }

    public int getHaltStartTimeSeconds(RecordCursor cursor) {
        if (iHaltStartTime < 0)
            return 0;
        return getInt(cursor, iHaltStartTime);
    }

    public void setHaltStartTimeSeconds(RecordCursor cursor, int haltStartTime) {
        if (iHaltStartTime < 0)
            return;
        setInt(cursor, iHaltStartTime, haltStartTime);
    }

    public long getHaltEndTimeMillis(RecordCursor cursor) {
        if (iHaltEndTime < 0)
            return 0;
        return getInt(cursor, iHaltEndTime) * 1000L;
    }

    public void setHaltEndTimeMillis(RecordCursor cursor, long haltEndTime) {
        if (iHaltEndTime < 0)
            return;
        setInt(cursor, iHaltEndTime, TimeUtil.getSecondsFromTime(haltEndTime));
    }

    public int getHaltEndTimeSeconds(RecordCursor cursor) {
        if (iHaltEndTime < 0)
            return 0;
        return getInt(cursor, iHaltEndTime);
    }

    public void setHaltEndTimeSeconds(RecordCursor cursor, int haltEndTime) {
        if (iHaltEndTime < 0)
            return;
        setInt(cursor, iHaltEndTime, haltEndTime);
    }

    public int getFlags(RecordCursor cursor) {
        if (iFlags < 0)
            return 0;
        return getInt(cursor, iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        if (iFlags < 0)
            return;
        setInt(cursor, iFlags, flags);
    }

    public String getDescription(RecordCursor cursor) {
        return (String) getObj(cursor, oDescription);
    }

    public void setDescription(RecordCursor cursor, String description) {
        setObj(cursor, oDescription, description);
    }

    public String getStatusReason(RecordCursor cursor) {
        if (oStatusReason < 0)
            return null;
        return (String) getObj(cursor, oStatusReason);
    }

    public void setStatusReason(RecordCursor cursor, String statusReason) {
        if (oStatusReason < 0)
            return;
        setObj(cursor, oStatusReason, statusReason);
    }
// END: CODE AUTOMATICALLY GENERATED
}
