/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.misc.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class TextConfigurationMapping extends RecordMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iTime;
    private final int iSequence;
    private final int iVersion;
    private final int oText;

    public TextConfigurationMapping(DataRecord record) {
        super(record);
        iTime = MappingUtil.findIntField(record, "Time", false);
        iSequence = MappingUtil.findIntField(record, "Sequence", false);
        iVersion = MappingUtil.findIntField(record, "Version", false);
        oText = MappingUtil.findObjField(record, "Text", true);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (iTime < 0)
            return 0;
        return getInt(cursor, iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (iTime < 0)
            return;
        setInt(cursor, iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (iSequence < 0)
            return 0;
        return getInt(cursor, iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (iSequence < 0)
            return;
        setInt(cursor, iSequence, sequence);
    }

    public int getVersion(RecordCursor cursor) {
        if (iVersion < 0)
            return 0;
        return getInt(cursor, iVersion);
    }

    public void setVersion(RecordCursor cursor, int version) {
        if (iVersion < 0)
            return;
        setInt(cursor, iVersion, version);
    }

    public String getText(RecordCursor cursor) {
        return (String) getObj(cursor, oText);
    }

    public void setText(RecordCursor cursor, String text) {
        setObj(cursor, oText, text);
    }
// END: CODE AUTOMATICALLY GENERATED
}
