/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.AnalyticOrder;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnalyticOrderTest {
    private static final String SYMBOL = "TEST";
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private DXFeedSubscription<AnalyticOrder> sub;
    private final BlockingQueue<AnalyticOrder> queue = new ArrayBlockingQueue<AnalyticOrder>(10);
    private final long t0 = System.currentTimeMillis() / 1000L * 1000L;
    private final long t1 = this.t0 - 1000L;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        this.sub = feed.createSubscription(AnalyticOrder.class);
        this.sub.addEventListener(this.queue::addAll);
        this.sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testAnalyticOrder() throws InterruptedException {
        AnalyticOrder order = new AnalyticOrder(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setMarketMaker("NSDQ");
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        order.setIcebergHiddenSize(2.0);
        order.setIcebergPeakSize(3.0);
        order.setIcebergExecutedSize(4.0);
        this.publisher.publishEvents(Collections.singleton(order));
        AnalyticOrder received = this.queue.take();
        Assert.assertEquals((Object)SYMBOL, (Object)received.getEventSymbol());
        Assert.assertEquals((Object)Side.BUY, (Object)received.getOrderSide());
        Assert.assertEquals((Object)Scope.ORDER, (Object)received.getScope());
        Assert.assertEquals((double)10.0, (double)received.getPrice(), (double)0.0);
        Assert.assertEquals((long)1L, (long)received.getSize());
        Assert.assertTrue((boolean)Double.isNaN(received.getIcebergHiddenSize()));
        Assert.assertTrue((boolean)Double.isNaN(received.getIcebergPeakSize()));
        Assert.assertTrue((boolean)Double.isNaN(received.getIcebergExecutedSize()));
    }

    @Test
    public void testOrderNotReceived() throws InterruptedException {
        Order order = new Order(SYMBOL);
        order.setOrderSide(Side.BUY);
        order.setMarketMaker("NSDQ");
        order.setScope(Scope.ORDER);
        order.setPrice(10.0);
        order.setSize(1L);
        order.setIndex(1L);
        this.publisher.publishEvents(Collections.singleton(order));
        Order received = (Order)this.queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNull((Object)received);
    }
}

