/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.devexperts.util.TimeFormat;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.candle.CandleType;
import com.dxfeed.event.market.Trade;
import com.dxfeed.event.option.Series;
import com.dxfeed.promise.Promise;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DXFeedPromiseTest {
    private DXEndpoint endpoint;
    private DXFeed feed;
    private DXPublisher publisher;
    private final BlockingQueue<Object> added = new LinkedBlockingQueue<Object>();
    private final BlockingQueue<Object> removed = new LinkedBlockingQueue<Object>();
    private static final String SERIES_SYMBOL = "TEST";
    private static final CandleSymbol CANDLE_SYMBOL = CandleSymbol.valueOf((String)"TEST", (CandleSymbolAttribute)CandlePeriod.valueOf((double)1.0, (CandleType)CandleType.MINUTE));

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.endpoint.executor(Runnable::run);
        this.feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testLastEventPromise() {
        this.trackSubscription(Trade.class);
        Promise aPromise = this.feed.getLastEventPromise(Trade.class, (Object)"A");
        this.assertAdded("A");
        Promise bPromise = this.feed.getLastEventPromise(Trade.class, (Object)"B");
        this.assertAdded("B");
        Promise cPromise = this.feed.getLastEventPromise(Trade.class, (Object)"C");
        this.assertAdded("C");
        Promise bPromise2 = this.feed.getLastEventPromise(Trade.class, (Object)"B");
        this.assertEmptyAddedAndRemoved();
        Assert.assertFalse((boolean)aPromise.isDone());
        Assert.assertFalse((boolean)bPromise.isDone());
        Assert.assertFalse((boolean)cPromise.isDone());
        Assert.assertFalse((boolean)bPromise2.isDone());
        this.publisher.publishEvents(Collections.singletonList(new Trade("A")));
        this.assertRemoved("A");
        Assert.assertTrue((boolean)aPromise.isDone());
        Assert.assertEquals((Object)"A", (Object)((Trade)aPromise.getResult()).getEventSymbol());
        Assert.assertFalse((boolean)bPromise.isDone());
        Assert.assertFalse((boolean)cPromise.isDone());
        Assert.assertFalse((boolean)bPromise2.isDone());
        this.publisher.publishEvents(Collections.singletonList(new Trade("B")));
        this.assertRemoved("B");
        Assert.assertTrue((boolean)bPromise.isDone());
        Assert.assertEquals((Object)"B", (Object)((Trade)bPromise.getResult()).getEventSymbol());
        Assert.assertTrue((boolean)bPromise2.isDone());
        Assert.assertEquals((Object)"B", (Object)((Trade)bPromise2.getResult()).getEventSymbol());
        Assert.assertFalse((boolean)cPromise.isDone());
        this.publisher.publishEvents(Collections.singletonList(new Trade("C")));
        this.assertRemoved("C");
        Assert.assertTrue((boolean)cPromise.isDone());
        Assert.assertEquals((Object)"C", (Object)((Trade)cPromise.getResult()).getEventSymbol());
    }

    @Test
    public void testLastEventPromiseCancel() {
        this.trackSubscription(Trade.class);
        Promise promise = this.feed.getLastEventPromise(Trade.class, (Object)"T");
        this.assertAdded("T");
        Assert.assertFalse((boolean)promise.isDone());
        promise.cancel();
        this.assertRemoved("T");
        Assert.assertTrue((boolean)promise.isDone());
    }

    @Test
    public void testIndexedEventsPromise() {
        this.trackSubscription(Series.class);
        Promise promise = this.feed.getIndexedEventsPromise(Series.class, (Object)SERIES_SYMBOL, IndexedEventSource.DEFAULT);
        this.assertAdded(SERIES_SYMBOL);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishSeries(3L, 300, 10.01, 4);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishSeries(2L, 200, 10.02, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishSeries(1L, 100, 10.03, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishSeries(0L, 0, Double.NaN, 10);
        this.assertRemoved(SERIES_SYMBOL);
        Assert.assertTrue((boolean)promise.isDone());
        List list = (List)promise.getResult();
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertSeries((Series)list.get(0), 1L, 100, 10.03);
        this.assertSeries((Series)list.get(1), 2L, 200, 10.02);
        this.assertSeries((Series)list.get(2), 3L, 300, 10.01);
    }

    private void publishSeries(long index, int expiration, double volatility, int eventFlags) {
        Series series = new Series(SERIES_SYMBOL);
        series.setIndex(index);
        series.setExpiration(expiration);
        series.setVolatility(volatility);
        series.setEventFlags(eventFlags);
        this.publisher.publishEvents(Collections.singletonList(series));
    }

    private void assertSeries(Series series, long index, int expiration, double volatility) {
        Assert.assertEquals((Object)SERIES_SYMBOL, (Object)series.getEventSymbol());
        Assert.assertEquals((long)index, (long)series.getIndex());
        Assert.assertEquals((long)expiration, (long)series.getExpiration());
        Assert.assertEquals((double)volatility, (double)series.getVolatility(), (double)0.0);
        Assert.assertEquals((long)0L, (long)series.getEventFlags());
    }

    @Test
    public void testTimeSeriesPromise() {
        this.trackSubscription(Candle.class);
        long time = TimeFormat.DEFAULT.parse("20200116-120000-0500").getTime();
        long period = 60000L;
        long subTime = time - 2L * period;
        Promise promise = this.feed.getTimeSeriesPromise(Candle.class, (Object)CANDLE_SYMBOL, subTime, time);
        TimeSeriesSubscriptionSymbol addedSymbol = (TimeSeriesSubscriptionSymbol)this.added.poll();
        Assert.assertNotNull((Object)addedSymbol);
        Assert.assertEquals((Object)CANDLE_SYMBOL, (Object)addedSymbol.getEventSymbol());
        Assert.assertTrue((addedSymbol.getFromTime() <= subTime ? 1 : 0) != 0);
        this.assertEmptyAddedAndRemoved();
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(time, 0L, 4);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(time - period, 1L, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(subTime, 2L, 0);
        this.assertRemoved(addedSymbol);
        Assert.assertTrue((boolean)promise.isDone());
        List list = (List)promise.getResult();
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertCandle((Candle)list.get(0), subTime, 2L);
        this.assertCandle((Candle)list.get(1), time - period, 1L);
        this.assertCandle((Candle)list.get(2), time, 0L);
    }

    @Test
    public void testEmptyTimeSeriesPromise() {
        this.trackSubscription(Candle.class);
        long time = TimeFormat.DEFAULT.parse("20200116-120000-0500").getTime();
        long period = 60000L;
        long subTime = time - 2L * period;
        Promise promise = this.feed.getTimeSeriesPromise(Candle.class, (Object)CANDLE_SYMBOL, subTime, time);
        TimeSeriesSubscriptionSymbol addedSymbol = (TimeSeriesSubscriptionSymbol)this.added.poll();
        Assert.assertNotNull((Object)addedSymbol);
        Assert.assertEquals((Object)CANDLE_SYMBOL, (Object)addedSymbol.getEventSymbol());
        Assert.assertTrue((addedSymbol.getFromTime() <= subTime ? 1 : 0) != 0);
        this.assertEmptyAddedAndRemoved();
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(time, 0L, 4);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(time - period, 1L, 0);
        Assert.assertFalse((boolean)promise.isDone());
        this.publishCandle(subTime, 2L, 0);
        this.assertRemoved(addedSymbol);
        Assert.assertTrue((boolean)promise.isDone());
        List list = (List)promise.getResult();
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertCandle((Candle)list.get(0), subTime, 2L);
        this.assertCandle((Candle)list.get(1), time - period, 1L);
        this.assertCandle((Candle)list.get(2), time, 0L);
        Promise promise2 = this.feed.getTimeSeriesPromise(Candle.class, (Object)CANDLE_SYMBOL, subTime, time);
        TimeSeriesSubscriptionSymbol addedSymbol2 = (TimeSeriesSubscriptionSymbol)this.added.poll();
        Assert.assertNotNull((Object)addedSymbol2);
        Assert.assertEquals((Object)CANDLE_SYMBOL, (Object)addedSymbol2.getEventSymbol());
        Assert.assertEquals((long)addedSymbol.getFromTime(), (long)addedSymbol2.getFromTime());
        this.assertEmptyAddedAndRemoved();
        Assert.assertFalse((boolean)promise2.isDone());
        this.publishCandle(time - 3L * period, 3L, 0);
        Assert.assertFalse((boolean)promise2.isDone());
        this.publishCandle(time - period, 1L, 0);
        this.publishCandle(subTime, 2L, 0);
        this.publishCandle(time - 3L * period, 3L, 0);
        Assert.assertFalse((boolean)promise2.isDone());
        this.publishCandle(time, 0L, 4);
        Assert.assertFalse((boolean)promise2.isDone());
        this.publishCandle(time - period, 1L, 0);
        Assert.assertFalse((boolean)promise2.isDone());
        this.publishCandle(subTime, 2L, 0);
        this.assertRemoved(addedSymbol);
        Assert.assertTrue((boolean)promise2.isDone());
        list = (List)promise2.getResult();
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertCandle((Candle)list.get(0), subTime, 2L);
        this.assertCandle((Candle)list.get(1), time - period, 1L);
        this.assertCandle((Candle)list.get(2), time, 0L);
    }

    private void publishCandle(long time, long count, int eventFlags) {
        Candle candle = new Candle(CANDLE_SYMBOL);
        candle.setTime(time);
        candle.setCount(count);
        candle.setEventFlags(eventFlags);
        this.publisher.publishEvents(Collections.singletonList(candle));
    }

    private void assertCandle(Candle candle, long time, long count) {
        Assert.assertEquals((Object)CANDLE_SYMBOL, (Object)candle.getEventSymbol());
        Assert.assertEquals((long)time, (long)candle.getTime());
        Assert.assertEquals((long)count, (long)candle.getCount());
        Assert.assertEquals((long)0L, (long)candle.getEventFlags());
    }

    private void trackSubscription(Class<?> eventType) {
        this.assertEmptyAddedAndRemoved();
        this.publisher.getSubscription(eventType).addChangeListener(new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                DXFeedPromiseTest.this.added.addAll(symbols);
            }

            public void symbolsRemoved(Set<?> symbols) {
                DXFeedPromiseTest.this.removed.addAll(symbols);
            }
        });
    }

    private void assertAdded(Object symbol) {
        Assert.assertEquals((Object)symbol, this.added.poll());
        this.assertEmptyAddedAndRemoved();
    }

    private void assertRemoved(Object symbol) {
        Assert.assertEquals((Object)symbol, this.removed.poll());
        this.assertEmptyAddedAndRemoved();
    }

    private void assertEmptyAddedAndRemoved() {
        Assert.assertEquals((long)0L, (long)this.added.size());
        Assert.assertEquals((long)0L, (long)this.removed.size());
    }
}

