/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.io.IOUtil;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.TimeAndSale;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DXFeedSubscriptionTest {
    private static int serialRecv;
    private static int nonSerialRecv;

    @Test
    public void testSerialization() throws Exception {
        serialRecv = 0;
        nonSerialRecv = 0;
        DXFeedSubscription sub = new DXFeedSubscription(Quote.class);
        sub.addEventListener((DXFeedEventListener)new SerializableEventListener());
        sub.addEventListener((DXFeedEventListener)new NonSerializableEventListener());
        List<String> symbols = Arrays.asList("IBM", "MSFT");
        sub.setSymbols(symbols);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)1L, (long)serialRecv);
        Assert.assertEquals((long)1L, (long)nonSerialRecv);
        sub = (DXFeedSubscription)IOUtil.bytesToObject((byte[])IOUtil.objectToBytes((Object)sub));
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals(new HashSet<String>(symbols), (Object)sub.getSymbols());
        Assert.assertEquals((long)2L, (long)serialRecv);
        Assert.assertEquals((long)1L, (long)nonSerialRecv);
    }

    @Test
    public void testRemoveListeners() throws Exception {
        serialRecv = 0;
        nonSerialRecv = 0;
        DXFeedSubscription sub = new DXFeedSubscription(Quote.class);
        SerializableEventListener serialListener = new SerializableEventListener();
        NonSerializableEventListener nonSerialListener = new NonSerializableEventListener();
        List<String> symbols = Arrays.asList("IBM", "MSFT");
        sub.setSymbols(symbols);
        sub.addEventListener((DXFeedEventListener)serialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)1L, (long)serialRecv);
        Assert.assertEquals((long)0L, (long)nonSerialRecv);
        sub.addEventListener((DXFeedEventListener)serialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)3L, (long)serialRecv);
        Assert.assertEquals((long)0L, (long)nonSerialRecv);
        sub.removeEventListener((DXFeedEventListener)serialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)4L, (long)serialRecv);
        Assert.assertEquals((long)0L, (long)nonSerialRecv);
        sub.addEventListener((DXFeedEventListener)nonSerialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)5L, (long)serialRecv);
        Assert.assertEquals((long)1L, (long)nonSerialRecv);
        sub.removeEventListener((DXFeedEventListener)serialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)5L, (long)serialRecv);
        Assert.assertEquals((long)2L, (long)nonSerialRecv);
        sub.removeEventListener((DXFeedEventListener)nonSerialListener);
        ProcessEventsAccess.processEvents(sub, Arrays.asList(new Quote()));
        Assert.assertEquals((long)5L, (long)serialRecv);
        Assert.assertEquals((long)2L, (long)nonSerialRecv);
    }

    @Test
    public void testSymbolSet() {
        DXFeedSubscription sub = new DXFeedSubscription(TimeAndSale.class);
        MySubscriptionChangeListener cl = new MySubscriptionChangeListener(sub);
        sub.addChangeListener((ObservableSubscriptionChangeListener)cl);
        String s1 = "IBM";
        sub.addSymbols((Object)s1);
        cl.assertAdded(s1);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1);
        String s2 = "MSFT";
        sub.addSymbols((Object)s2);
        cl.assertAdded(s2);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2);
        sub.setSymbols(new Object[]{s1, s2});
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2);
        String s1New = new String(s1);
        sub.addSymbols((Object)s1New);
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1New, s2);
        s1 = s1New;
        s1New = new String(s1);
        sub.setSymbols(new Object[]{s1New, s2});
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1New, s2);
        s1 = s1New;
        sub.addSymbols(new Object[]{s1, s2});
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2);
        TimeSeriesSubscriptionSymbol s3 = new TimeSeriesSubscriptionSymbol((Object)"IBM", 1234L);
        sub.removeSymbols(new Object[]{s3});
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2);
        sub.addSymbols((Object)s3);
        cl.assertAdded(s3);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2, s3);
        TimeSeriesSubscriptionSymbol s4 = new TimeSeriesSubscriptionSymbol((Object)"IBM", 8888L);
        sub.addSymbols((Object)s4);
        cl.assertAdded(s4);
        cl.assertRemoved(new Object[0]);
        cl.assertSub(s1, s2, s4);
        TimeSeriesSubscriptionSymbol s5 = new TimeSeriesSubscriptionSymbol((Object)"IBM", 0L);
        sub.removeSymbols(new Object[]{s5});
        cl.assertAdded(new Object[0]);
        cl.assertRemoved(s4);
        cl.assertSub(s1, s2);
        sub.close();
        cl.assertClosed();
    }

    private static class MySubscriptionChangeListener
    implements ObservableSubscriptionChangeListener {
        Set<Object> added;
        Set<Object> removed = new HashSet<Object>();
        boolean closed;
        final DXFeedSubscription<?> sub;

        MySubscriptionChangeListener(DXFeedSubscription<?> sub) {
            this.sub = sub;
            this.added = new HashSet<Object>();
        }

        public void symbolsAdded(Set<?> symbols) {
            this.added.addAll(symbols);
        }

        public void symbolsRemoved(Set<?> symbols) {
            Assert.assertTrue((String)"Remove should be first", (boolean)this.added.isEmpty());
            this.removed.addAll(symbols);
        }

        public void subscriptionClosed() {
            this.closed = true;
        }

        private void assertSame(Object[] symbols, Set<?> set) {
            HashSet<Object> expectedSet = new HashSet<Object>(Arrays.asList(symbols));
            Assert.assertEquals(expectedSet, set);
            IdentityHashMap<Object, Object> expectedIdentifies = new IdentityHashMap<Object, Object>();
            for (Object symbol : symbols) {
                expectedIdentifies.put(symbol, symbol);
            }
            for (Object o : set) {
                Assert.assertTrue((boolean)expectedIdentifies.containsKey(o));
            }
        }

        public void assertAdded(Object ... symbols) {
            Assert.assertFalse((boolean)this.closed);
            this.assertSame(symbols, this.added);
            this.added.clear();
        }

        public void assertRemoved(Object ... symbols) {
            Assert.assertFalse((boolean)this.closed);
            this.assertSame(symbols, this.removed);
            this.removed.clear();
        }

        public void assertSub(Object ... symbols) {
            Assert.assertFalse((boolean)this.closed);
            this.assertSame(symbols, this.sub.getSymbols());
            this.removed.clear();
        }

        public void assertClosed() {
            Assert.assertTrue((boolean)this.closed);
            Assert.assertEquals((long)0L, (long)this.added.size());
            Assert.assertEquals((long)0L, (long)this.removed.size());
        }
    }

    private static class NonSerializableEventListener
    implements DXFeedEventListener<Quote> {
        NonSerializableEventListener() {
        }

        public void eventsReceived(List<Quote> events) {
            nonSerialRecv++;
        }
    }

    private static class SerializableEventListener
    implements DXFeedEventListener<Quote>,
    Serializable {
        private static final long serialVersionUID = 0L;

        SerializableEventListener() {
        }

        public void eventsReceived(List<Quote> events) {
            serialRecv++;
        }
    }

    static abstract class ProcessEventsAccess
    extends DXFeed {
        ProcessEventsAccess() {
        }

        public static <T> void processEvents(DXFeedSubscription<T> subscription, List<T> events) {
            DXFeed.processEvents(subscription, events, (long)0L);
        }
    }
}

