/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.custom.NuamTrade;
import com.dxfeed.event.market.Direction;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NuamTradeTest {
    private static final String SYMBOL = "TEST";
    private static final long TIME = 1753453151300L;
    private static final int DAYS_SINCE_EPOCH = 20294;
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private final BlockingQueue<NuamTrade> receivedEvents = new ArrayBlockingQueue<NuamTrade>(10);

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        DXFeed feed = this.endpoint.getFeed();
        this.publisher = this.endpoint.getPublisher();
        DXFeedSubscription sub = feed.createSubscription(NuamTrade.class);
        sub.addEventListener(this.receivedEvents::addAll);
        sub.addSymbols((Object)SYMBOL);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testNuamTrade() throws InterruptedException {
        NuamTrade trade = NuamTradeTest.createNuamTrade();
        this.publisher.publishEvents(Collections.singleton(trade));
        this.assertEvent(trade, this.receivedEvents.take());
    }

    private static NuamTrade createNuamTrade() {
        NuamTrade trade = new NuamTrade(SYMBOL);
        trade.setTime(1753453151300L);
        trade.setSequence(2);
        trade.setExchangeCode('A');
        trade.setTradeId(2L);
        trade.setPrice(3.0);
        trade.setSizeAsDouble(4.0);
        trade.setDayId(20294);
        trade.setDayVolumeAsDouble(5.0);
        trade.setDayTurnover(6.0);
        trade.setTickDirection(Direction.UP);
        trade.setChange(7.0);
        trade.setTradeStatTime(1753453151300L);
        trade.setLastSignificantPrice(101.0);
        trade.setLastPriceForAll(102.0);
        trade.setNumberOfTrades(103);
        trade.setVWAP(104.0);
        return trade;
    }

    private void assertEvent(NuamTrade expected, NuamTrade actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)expected.getEventSymbol(), (Object)actual.getEventSymbol());
        Assert.assertEquals((long)1753453151300L, (long)actual.getTime());
        Assert.assertEquals((long)expected.getSequence(), (long)actual.getSequence());
        Assert.assertEquals((long)expected.getExchangeCode(), (long)actual.getExchangeCode());
        Assert.assertEquals((long)expected.getTradeId(), (long)actual.getTradeId());
        Assert.assertEquals((double)expected.getPrice(), (double)actual.getPrice(), (double)0.0);
        Assert.assertEquals((double)expected.getSizeAsDouble(), (double)actual.getSizeAsDouble(), (double)0.0);
        Assert.assertEquals((long)expected.getDayId(), (long)actual.getDayId());
        Assert.assertEquals((double)expected.getDayVolumeAsDouble(), (double)actual.getDayVolumeAsDouble(), (double)0.0);
        Assert.assertEquals((double)expected.getDayTurnover(), (double)actual.getDayTurnover(), (double)0.0);
        Assert.assertEquals((Object)expected.getTickDirection(), (Object)actual.getTickDirection());
        Assert.assertEquals((double)expected.getChange(), (double)actual.getChange(), (double)0.0);
        Assert.assertEquals((long)expected.getTradeStatTime(), (long)actual.getTradeStatTime());
        Assert.assertEquals((double)expected.getLastSignificantPrice(), (double)actual.getLastSignificantPrice(), (double)0.0);
        Assert.assertEquals((double)expected.getLastPriceForAll(), (double)actual.getLastPriceForAll(), (double)0.0);
        Assert.assertEquals((long)expected.getNumberOfTrades(), (long)actual.getNumberOfTrades());
        Assert.assertEquals((double)expected.getVWAP(), (double)actual.getVWAP(), (double)0.0);
    }

    @Test
    public void testEmptyNuamTrade() {
        NuamTrade trade = new NuamTrade();
        Assert.assertNull((Object)trade.getEventSymbol());
        Assert.assertEquals((long)0L, (long)trade.getTime());
        Assert.assertEquals((long)0L, (long)trade.getSequence());
        Assert.assertEquals((long)0L, (long)trade.getExchangeCode());
        Assert.assertEquals((long)0L, (long)trade.getTradeId());
        Assert.assertEquals((double)Double.NaN, (double)trade.getPrice(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)trade.getSizeAsDouble(), (double)0.0);
        Assert.assertEquals((long)0L, (long)trade.getDayId());
        Assert.assertEquals((double)Double.NaN, (double)trade.getDayVolumeAsDouble(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)trade.getDayTurnover(), (double)0.0);
        Assert.assertEquals((Object)Direction.UNDEFINED, (Object)trade.getTickDirection());
        Assert.assertEquals((double)Double.NaN, (double)trade.getChange(), (double)0.0);
        Assert.assertEquals((long)0L, (long)trade.getTradeStatTime());
        Assert.assertEquals((double)Double.NaN, (double)trade.getLastSignificantPrice(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)trade.getLastPriceForAll(), (double)0.0);
        Assert.assertEquals((long)0L, (long)trade.getNumberOfTrades());
        Assert.assertEquals((double)Double.NaN, (double)trade.getVWAP(), (double)0.0);
    }
}

