/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.test;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.AnalyticOrder;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.OtcMarketsOrder;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.market.OrderBookModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderBookModelTest {
    public static final char Q = 'Q';
    public static final char Z = 'Z';
    public static final String MMID = "NYSE";
    public static final String MMID2 = "NSDQ";
    private DXPublisher publisher;
    private OrderBookModel model;
    private List<Order> buys;
    private List<Order> sells;
    private int buyQueued;
    private int sellQueued;
    private String symbol = "IBM";

    @Before
    public void setUp() {
        DXEndpoint endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB).executor(Runnable::run);
        this.publisher = endpoint.getPublisher();
        this.model = new OrderBookModel();
        this.model.setSymbol(this.symbol);
        this.model.attach(endpoint.getFeed());
        this.buys = this.model.getBuyOrders();
        this.model.getBuyOrders().addListener(change -> ++this.buyQueued);
        this.sells = this.model.getSellOrders();
        this.model.getSellOrders().addListener(change -> ++this.sellQueued);
    }

    @After
    public void tearDown() throws Exception {
        this.model.close();
    }

    @Test
    public void testLotSize() throws Exception {
        this.model.setLotSize(100);
        this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(1)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)100L, (long)this.buys.get(0).getSize());
        this.publisher.publishEvents(Collections.singletonList(this.regionalBuy('Q', 2)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)200L, (long)this.buys.get(0).getSize());
        this.publisher.publishEvents(Collections.singletonList(this.aggregateBuy(2, 3, 'Q', MMID)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)300L, (long)this.buys.get(0).getSize());
        this.publisher.publishEvents(Collections.singletonList(this.orderBuy(3, 400, 'Q', MMID)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)400L, (long)this.buys.get(0).getSize());
    }

    @Test
    public void testChangeLotSize() throws Exception {
        this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(1)));
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)this.model.getLotSize(), (long)this.buys.get(0).getSize());
        this.model.setLotSize(100);
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)100L, (long)this.buys.get(0).getSize());
        this.model.setLotSize(1);
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)1L, (long)this.buys.get(0).getSize());
    }

    @Test
    public void testChangeLotSize2() throws Exception {
        this.publisher.publishEvents(Arrays.asList(this.aggregateBuy(1, 1, 'Q', MMID), this.aggregateBuy(2, 0, 'Q', MMID)));
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)this.model.getLotSize(), (long)this.buys.get(0).getSize());
        this.model.setLotSize(100);
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)100L, (long)this.buys.get(0).getSize());
        this.model.setLotSize(1);
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)1L, (long)this.buys.get(0).getSize());
    }

    @Test
    public void testSoleZeroSizeCompositeQuote() throws Exception {
        this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(1)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(1);
        this.publisher.publishEvents(Collections.singletonList(this.regionalBuy('Q', 1)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        this.publisher.publishEvents(Collections.singletonList(this.regionalBuy('Q', 0)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(0)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)0L, (long)this.buys.get(0).getSize());
        Assert.assertEquals((double)0.0, (double)this.buys.get(0).getPrice(), (double)0.0);
    }

    @Test
    public void testChangeSymbol() {
        int i;
        int n = 100;
        for (i = 1; i <= n; ++i) {
            this.publisher.publishEvents(Collections.singletonList(this.orderBuy(i, i, 'Q', MMID)));
        }
        this.assertNBuyChangesQueued(n);
        this.symbol = "OTHER";
        this.model.setSymbol(this.symbol);
        this.assertNBuyChangesQueued(1);
        Assert.assertEquals((long)0L, (long)this.buys.size());
        for (i = 1; i <= n; ++i) {
            this.publisher.publishEvents(Collections.singletonList(this.orderBuy(i, i, 'Q', MMID)));
            this.assertNBuyChangesQueued(1);
        }
        this.assertNSellChangesQueued(0);
    }

    @Test
    public void testOrderBookModelIgnoresAnalyticOrder() {
        this.publisher.publishEvents(Collections.singletonList(this.analyticOrderBuy(4, 500, 'Q', MMID)));
        this.assertNBuyChangesQueued(0);
        this.assertNSellChangesQueued(0);
    }

    @Test
    public void testOrderBookModelIgnoresOtcMarketsOrder() {
        this.publisher.publishEvents(Collections.singletonList(this.otcMarketOrderBuy(4, 500, 'Q', MMID)));
        this.assertNBuyChangesQueued(0);
        this.assertNSellChangesQueued(0);
    }

    private void assertNBuyChangesQueued(int n) {
        Assert.assertEquals((long)n, (long)this.buyQueued);
        this.buyQueued = 0;
    }

    private void assertNSellChangesQueued(int n) {
        Assert.assertEquals((long)n, (long)this.sellQueued);
        this.sellQueued = 0;
    }

    @Test
    public void testMix() {
        this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(1)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(1);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        Assert.assertEquals((long)1L, (long)this.sells.size());
        this.assertOrder(this.buys, 0, Scope.COMPOSITE, 1);
        this.assertOrder(this.sells, 0, Scope.COMPOSITE, 0);
        this.publisher.publishEvents(Collections.singletonList(this.regionalBuy('Q', 2)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)1L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.REGIONAL, 2);
        this.publisher.publishEvents(Collections.singletonList(this.regionalBuy('Z', 3)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)2L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.REGIONAL, 3);
        this.assertOrder(this.buys, 1, Scope.REGIONAL, 2);
        this.publisher.publishEvents(Collections.singletonList(this.aggregateBuy(4, 4, 'Q', MMID)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)2L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.AGGREGATE, 4);
        this.assertOrder(this.buys, 1, Scope.REGIONAL, 3);
        this.publisher.publishEvents(Collections.singletonList(this.aggregateBuy(5, 5, 'Q', MMID2)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)3L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.AGGREGATE, 5);
        this.assertOrder(this.buys, 1, Scope.AGGREGATE, 4);
        this.assertOrder(this.buys, 2, Scope.REGIONAL, 3);
        this.publisher.publishEvents(Collections.singletonList(this.orderBuy(6, 6, 'Q', MMID)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)3L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.ORDER, 6);
        this.assertOrder(this.buys, 1, Scope.AGGREGATE, 5);
        this.assertOrder(this.buys, 2, Scope.REGIONAL, 3);
        this.publisher.publishEvents(Collections.singletonList(this.orderBuy(7, 7, 'Q', MMID2)));
        this.assertNBuyChangesQueued(1);
        this.assertNSellChangesQueued(0);
        Assert.assertEquals((long)3L, (long)this.buys.size());
        this.assertOrder(this.buys, 0, Scope.ORDER, 7);
        this.assertOrder(this.buys, 1, Scope.ORDER, 6);
        this.assertOrder(this.buys, 2, Scope.REGIONAL, 3);
    }

    private void assertOrder(List<Order> orders, int index, Scope scope, int value) {
        Assert.assertEquals((Object)scope, (Object)orders.get(index).getScope());
        Assert.assertEquals((long)value, (long)orders.get(index).getSize());
    }

    @Test
    public void testStressBuySellOrders() {
        Random rnd = new Random(1L);
        int bookSize = 100;
        Order[] book = new Order[bookSize];
        int expectedBuy = 0;
        int expectedSell = 0;
        for (int i = 0; i < 10000; ++i) {
            int index = rnd.nextInt(bookSize);
            Order order = this.createOrder(Scope.ORDER, rnd.nextBoolean() ? Side.BUY : Side.SELL, index, rnd.nextInt(10), '\u0000', null);
            Order old = book[index];
            book[index] = order;
            int deltaBuy = this.oneIfBuy(order) - this.oneIfBuy(old);
            int deltaSell = this.oneIfSell(order) - this.oneIfSell(old);
            expectedBuy += deltaBuy;
            expectedSell += deltaSell;
            this.publisher.publishEvents(Collections.singletonList(order));
            switch (order.getOrderSide()) {
                case BUY: {
                    this.assertNBuyChangesQueued(deltaBuy != 0 || !this.same(order, old) && old.getOrderSide() == Side.BUY ? 1 : 0);
                    this.assertNSellChangesQueued(this.oneIfSell(old));
                    break;
                }
                case SELL: {
                    this.assertNSellChangesQueued(deltaSell != 0 || !this.same(order, old) && old.getOrderSide() == Side.SELL ? 1 : 0);
                    this.assertNBuyChangesQueued(this.oneIfBuy(old));
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
            Assert.assertEquals((long)expectedBuy, (long)this.buys.size());
            Assert.assertEquals((long)expectedSell, (long)this.sells.size());
        }
        Order order = this.createOrder(Scope.ORDER, Side.UNDEFINED, 0L, 0, '\u0000', null);
        order.setEventFlags(14);
        this.publisher.publishEvents(Collections.singletonList(order));
        this.assertNBuyChangesQueued(expectedBuy > 0 ? 1 : 0);
        this.assertNSellChangesQueued(expectedSell > 0 ? 1 : 0);
        Assert.assertEquals((long)0L, (long)this.buys.size());
        Assert.assertEquals((long)0L, (long)this.sells.size());
    }

    @Test
    public void testStressSources() {
        Random rnd = new Random(1L);
        int bookSize = 100;
        HashMap<OrderSource, Order[]> books = new HashMap<OrderSource, Order[]>();
        int expectedBuy = 0;
        int expectedSell = 0;
        List sources = OrderSource.publishable(Order.class);
        for (int i = 0; i < 10000; ++i) {
            int index = rnd.nextInt(bookSize);
            Order order = this.createOrder(Scope.ORDER, rnd.nextBoolean() ? Side.BUY : Side.SELL, index, rnd.nextInt(10), '\u0000', null);
            OrderSource source = (OrderSource)sources.get(rnd.nextInt(sources.size()));
            order.setSource(source);
            Order[] book = books.computeIfAbsent(source, k -> new Order[bookSize]);
            Order old = book[index];
            book[index] = order;
            int deltaBuy = this.oneIfBuy(order) - this.oneIfBuy(old);
            int deltaSell = this.oneIfSell(order) - this.oneIfSell(old);
            expectedBuy += deltaBuy;
            expectedSell += deltaSell;
            this.publisher.publishEvents(Collections.singletonList(order));
            switch (order.getOrderSide()) {
                case BUY: {
                    this.assertNBuyChangesQueued(deltaBuy != 0 || !this.same(order, old) && old.getOrderSide() == Side.BUY ? 1 : 0);
                    this.assertNSellChangesQueued(this.oneIfSell(old));
                    break;
                }
                case SELL: {
                    this.assertNSellChangesQueued(deltaSell != 0 || !this.same(order, old) && old.getOrderSide() == Side.SELL ? 1 : 0);
                    this.assertNBuyChangesQueued(this.oneIfBuy(old));
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
            Assert.assertEquals((long)expectedBuy, (long)this.buys.size());
            Assert.assertEquals((long)expectedSell, (long)this.sells.size());
        }
        ArrayList<OrderSource> orders = new ArrayList<OrderSource>();
        Iterator<Object> iterator = books.values().iterator();
        while (iterator.hasNext()) {
            OrderSource orderSource;
            for (OrderSource bookOrder : orderSource = (OrderSource)iterator.next()) {
                if (bookOrder == null) continue;
                orders.add(bookOrder);
            }
        }
        Collections.shuffle(orders, rnd);
        for (Order order : orders) {
            Order remove = this.createOrder(Scope.ORDER, Side.UNDEFINED, order.getIndex(), 0, '\u0000', null);
            remove.setEventFlags(2);
            this.publisher.publishEvents(Collections.singletonList(remove));
            this.assertNBuyChangesQueued(this.oneIfBuy(order));
            this.assertNSellChangesQueued(this.oneIfSell(order));
        }
        Assert.assertEquals((long)0L, (long)this.buys.size());
        Assert.assertEquals((long)0L, (long)this.sells.size());
    }

    @Test
    public void testStressMix() {
        Random rnd = new Random(1L);
        int bookSize = 100;
        block6: for (int i = 0; i < 10000; ++i) {
            int value = rnd.nextInt(10);
            char exchange = MarketEventSymbols.SUPPORTED_EXCHANGES.charAt(rnd.nextInt(MarketEventSymbols.SUPPORTED_EXCHANGES.length()));
            int index = rnd.nextInt(bookSize);
            String mmid = rnd.nextBoolean() ? MMID : MMID2;
            switch (rnd.nextInt(4)) {
                case 0: {
                    this.publisher.publishEvents(Collections.singletonList(this.compositeBuy(value)));
                    continue block6;
                }
                case 1: {
                    this.publisher.publishEvents(Collections.singletonList(this.regionalBuy(exchange, value)));
                    continue block6;
                }
                case 2: {
                    this.publisher.publishEvents(Collections.singletonList(this.aggregateBuy(index, value, exchange, mmid)));
                    continue block6;
                }
                case 3: {
                    this.publisher.publishEvents(Collections.singletonList(this.orderBuy(index, value, exchange, mmid)));
                }
            }
        }
    }

    protected Quote compositeBuy(int value) {
        Quote quote = new Quote();
        quote.setBidPrice((double)value * 10.0);
        quote.setBidSize((long)value);
        quote.setEventSymbol(this.symbol);
        return quote;
    }

    protected Quote regionalBuy(char exchange, int value) {
        Quote quote = new Quote();
        quote.setBidPrice((double)value * 10.0);
        quote.setBidSize((long)value);
        quote.setEventSymbol(MarketEventSymbols.changeExchangeCode((String)this.symbol, (char)exchange));
        return quote;
    }

    protected Order aggregateBuy(int index, int value, char exchange, String mmid) {
        return this.createOrder(Scope.AGGREGATE, Side.BUY, index, value, exchange, mmid);
    }

    protected Order orderBuy(int index, int value, char exchange, String mmid) {
        return this.createOrder(Scope.ORDER, Side.BUY, index, value, exchange, mmid);
    }

    protected Order createOrder(Scope scope, Side side, long index, int value, char exchange, String mmid) {
        Order order = new Order();
        order.setScope(scope);
        order.setIndex(index);
        order.setOrderSide(side);
        order.setPrice((double)value * 10.0);
        order.setSize((long)value);
        order.setExchangeCode(exchange);
        order.setMarketMaker(mmid);
        order.setEventSymbol(this.symbol);
        return order;
    }

    private AnalyticOrder analyticOrderBuy(int index, int value, char exchange, String mmid) {
        return this.createAnalyticOrder(Scope.ORDER, Side.BUY, index, value, exchange, mmid);
    }

    private AnalyticOrder createAnalyticOrder(Scope scope, Side side, long index, int value, char exchange, String mmid) {
        AnalyticOrder analyticOrder = new AnalyticOrder();
        analyticOrder.setScope(scope);
        analyticOrder.setIndex(index);
        analyticOrder.setOrderSide(side);
        analyticOrder.setPrice((double)value * 10.0);
        analyticOrder.setSize((long)value);
        analyticOrder.setExchangeCode(exchange);
        analyticOrder.setMarketMaker(mmid);
        analyticOrder.setEventSymbol(this.symbol);
        analyticOrder.setIcebergHiddenSize((double)value * 1.0);
        analyticOrder.setIcebergPeakSize((double)value * 1.0);
        return analyticOrder;
    }

    private OtcMarketsOrder otcMarketOrderBuy(int index, int value, char exchange, String mmid) {
        return this.createOtcMarketsOrder(Scope.ORDER, Side.BUY, index, value, exchange, mmid);
    }

    private OtcMarketsOrder createOtcMarketsOrder(Scope scope, Side side, long index, int value, char exchange, String mmid) {
        OtcMarketsOrder otcMarketsOrder = new OtcMarketsOrder();
        otcMarketsOrder.setScope(scope);
        otcMarketsOrder.setIndex(index);
        otcMarketsOrder.setOrderSide(side);
        otcMarketsOrder.setPrice((double)value * 10.0);
        otcMarketsOrder.setSize((long)value);
        otcMarketsOrder.setExchangeCode(exchange);
        otcMarketsOrder.setMarketMaker(mmid);
        otcMarketsOrder.setEventSymbol(this.symbol);
        otcMarketsOrder.setQuoteAccessPayment(value);
        return otcMarketsOrder;
    }

    private boolean same(Order order, Order old) {
        return old == null || order.getSize() == 0L ? order.getSize() == 0L : order.getScope() == old.getScope() && order.getOrderSide() == old.getOrderSide() && order.getIndex() == old.getIndex() && order.getSize() == old.getSize() && order.getSource() == old.getSource();
    }

    private int oneIfBuy(Order order) {
        return order != null && order.getOrderSide() == Side.BUY && order.getSize() != 0L ? 1 : 0;
    }

    private int oneIfSell(Order order) {
        return order != null && order.getOrderSide() == Side.SELL && order.getSize() != 0L ? 1 : 0;
    }
}

