/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.custom;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.custom.impl.NuamOrderMapping;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import com.dxfeed.event.market.Side;

import java.util.EnumSet;

public final class NuamOrderDelegate extends OrderBaseDelegateImpl<NuamOrder> {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final NuamOrderMapping m;

    public NuamOrderDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        m = record.getMapping(NuamOrderMapping.class);
    }

    @Override
    public NuamOrderMapping getMapping() {
        return m;
    }

    @Override
    public NuamOrder createEvent() {
        return new NuamOrder();
    }

    @Override
    public NuamOrder getEvent(NuamOrder event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex(((long) getSource().id() << 32) | (m.getIndex(cursor) & 0xFFFFFFFFL));
        event.setTimeSequence((((long) m.getTimeSeconds(cursor)) << 32) | (m.getSequence(cursor) & 0xFFFFFFFFL));
        event.setTimeNanoPart(m.getTimeNanoPart(cursor));
        event.setActionTime(m.getActionTimeMillis(cursor));
        event.setOrderId(m.getOrderId(cursor));
        event.setAuxOrderId(m.getAuxOrderId(cursor));
        event.setPrice(m.getPrice(cursor));
        event.setSizeAsDouble(m.getSizeDouble(cursor));
        event.setExecutedSize(m.getExecutedSize(cursor));
        event.setCount(m.getCount(cursor));
        event.setFlags(m.getFlags(cursor));
        event.setTradeId(m.getTradeId(cursor));
        event.setTradePrice(m.getTradePrice(cursor));
        event.setTradeSize(m.getTradeSize(cursor));
        event.setActorId(m.getActorId(cursor));
        event.setParticipantId(m.getParticipantId(cursor));
        event.setSubmitterId(m.getSubmitterId(cursor));
        event.setOnBehalfOfSubmitterId(m.getOnBehalfOfSubmitterId(cursor));
        event.setClientOrderId(m.getClientOrderId(cursor));
        event.setCustomerAccount(m.getCustomerAccount(cursor));
        event.setCustomerInfo(m.getCustomerInfo(cursor));
        event.setExchangeInfo(m.getExchangeInfo(cursor));
        event.setTimeInForceData(m.getTimeInForceData(cursor));
        event.setTriggerOrderBookId(m.getTriggerOrderBookId(cursor));
        event.setTriggerPrice(m.getTriggerPrice(cursor));
        event.setTriggerSessionType(m.getTriggerSessionType(cursor));
        event.setOrderQuantity(m.getOrderQuantityDouble(cursor));
        event.setDisplayQuantity(m.getDisplayQuantityDouble(cursor));
        event.setRefreshQuantity(m.getRefreshQuantityDouble(cursor));
        event.setLeavesQuantity(m.getLeavesQuantityDouble(cursor));
        event.setMatchedQuantity(m.getMatchedQuantityDouble(cursor));
        event.setNuamFlags(m.getNuamFlags(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(NuamOrder event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        int index = (int) event.getIndex();
        m.setIndex(cursor, index);
        m.setTimeSeconds(cursor, (int) (event.getTimeSequence() >>> 32));
        m.setSequence(cursor, (int) event.getTimeSequence());
        m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        m.setActionTimeMillis(cursor, event.getActionTime());
        m.setOrderId(cursor, event.getOrderId());
        m.setAuxOrderId(cursor, event.getAuxOrderId());
        m.setPrice(cursor, event.getPrice());
        m.setSizeDouble(cursor, event.getSizeAsDouble());
        m.setExecutedSize(cursor, event.getExecutedSize());
        m.setCount(cursor, (int) event.getCount());
        m.setFlags(cursor, event.getFlags());
        m.setTradeId(cursor, event.getTradeId());
        m.setTradePrice(cursor, event.getTradePrice());
        m.setTradeSize(cursor, event.getTradeSize());
        m.setActorId(cursor, event.getActorId());
        m.setParticipantId(cursor, event.getParticipantId());
        m.setSubmitterId(cursor, event.getSubmitterId());
        m.setOnBehalfOfSubmitterId(cursor, event.getOnBehalfOfSubmitterId());
        m.setClientOrderId(cursor, event.getClientOrderId());
        m.setCustomerAccount(cursor, event.getCustomerAccount());
        m.setCustomerInfo(cursor, event.getCustomerInfo());
        m.setExchangeInfo(cursor, event.getExchangeInfo());
        m.setTimeInForceData(cursor, event.getTimeInForceData());
        m.setTriggerOrderBookId(cursor, event.getTriggerOrderBookId());
        m.setTriggerPrice(cursor, event.getTriggerPrice());
        m.setTriggerSessionType(cursor, event.getTriggerSessionType());
        m.setOrderQuantityDouble(cursor, event.getOrderQuantity());
        m.setDisplayQuantityDouble(cursor, event.getDisplayQuantity());
        m.setRefreshQuantityDouble(cursor, event.getRefreshQuantity());
        m.setLeavesQuantityDouble(cursor, event.getLeavesQuantity());
        m.setMatchedQuantityDouble(cursor, event.getMatchedQuantity());
        m.setNuamFlags(cursor, event.getNuamFlags());
        if (index < 0)
            throw new IllegalArgumentException("Invalid index to publish");
        if ((event.getEventFlags() & (OrderBase.SNAPSHOT_END | OrderBase.SNAPSHOT_SNIP)) != 0 && index != 0)
            throw new IllegalArgumentException("SNAPSHOT_END and SNAPSHOT_SNIP orders must have index == 0");
        if (event.getOrderSide() == Side.UNDEFINED && event.hasSize())
            throw new IllegalArgumentException("only empty orders can have side == UNDEFINED");
        return cursor;
    }

    @Override
    public IndexedEventSource getSource() {
        return m.getRecordSource();
    }
// END: CODE AUTOMATICALLY GENERATED
}
