/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2025 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.event.market.impl.AnalyticOrderMapping;
import com.dxfeed.event.market.impl.BookMapping;
import com.dxfeed.event.market.impl.FundamentalMapping;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import com.dxfeed.event.market.impl.OptionSaleMapping;
import com.dxfeed.event.market.impl.OrderBaseMapping;
import com.dxfeed.event.market.impl.OrderImbalanceMapping;
import com.dxfeed.event.market.impl.OrderMapping;
import com.dxfeed.event.market.impl.OtcMarketsOrderMapping;
import com.dxfeed.event.market.impl.ProfileMapping;
import com.dxfeed.event.market.impl.QuoteMapping;
import com.dxfeed.event.market.impl.SpreadOrderMapping;
import com.dxfeed.event.market.impl.SummaryMapping;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import com.dxfeed.event.market.impl.TradeETHMapping;
import com.dxfeed.event.market.impl.TradeMapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

@ServiceProvider(order = -50)
public final class MarketFactoryImpl extends EventDelegateFactory implements RecordMappingFactory {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    @Override
    public void buildScheme(SchemeBuilder builder) {
        builder.addOptionalField("Quote", "Sequence", SerialFieldType.SEQUENCE, "Quote", "Sequence", false);
        builder.addOptionalField("Quote", "TimeNanoPart", SerialFieldType.COMPACT_INT, "Quote", "TimeNanoPart", false);
        builder.addOptionalField("Quote", "Bid.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Quote", "BidTime", true);
        builder.addOptionalField("Quote", "Bid.Exchange", SerialFieldType.UTF_CHAR, "Quote", "BidExchangeCode", true);
        builder.addRequiredField("Quote", "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Quote", "Bid.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("Quote", "Ask.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Quote", "AskTime", true);
        builder.addOptionalField("Quote", "Ask.Exchange", SerialFieldType.UTF_CHAR, "Quote", "AskExchangeCode", true);
        builder.addRequiredField("Quote", "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Quote", "Ask.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.Quote.exchanges")) {
            String recordName = "Quote&" + exchange;
            builder.addOptionalField(recordName, "Sequence", SerialFieldType.SEQUENCE, "Quote", "Sequence", false);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "Quote", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "Bid.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Quote", "BidTime", true);
            builder.addRequiredField(recordName, "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Bid.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "Ask.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Quote", "AskTime", true);
            builder.addRequiredField(recordName, "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Ask.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        }

        if (SystemProperties.getBooleanProperty("reuters.phantom", false)) {
            builder.addRequiredField("Quote2", "Bid.Price", selectDecimal(SerialFieldType.DECIMAL));
            builder.addRequiredField("Quote2", "Bid.Size", selectDecimal(SerialFieldType.DECIMAL));
            builder.addRequiredField("Quote2", "Ask.Price", selectDecimal(SerialFieldType.DECIMAL));
            builder.addRequiredField("Quote2", "Ask.Size", selectDecimal(SerialFieldType.DECIMAL));
            builder.addRequiredField("Quote2", "Bid.Price.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Bid.Size.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Ask.Price.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Ask.Size.Timestamp", SerialFieldType.TIME_SECONDS);
        }

        builder.addOptionalField("Trade", "Last.Time", SerialFieldType.TIME_SECONDS, "Trade", "Time", true);
        builder.addOptionalField("Trade", "Last.Sequence", SerialFieldType.SEQUENCE, "Trade", "Sequence", true);
        builder.addOptionalField("Trade", "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "Trade", "TimeNanoPart", false);
        builder.addOptionalField("Trade", "Last.Exchange", SerialFieldType.UTF_CHAR, "Trade", "ExchangeCode", true);
        builder.addOptionalField("Trade", "TradeId", SerialFieldType.LONG, "Trade", "TradeId", true);
        builder.addRequiredField("Trade", "Last.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Trade", "Last.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("Trade", "Last.Tick", SerialFieldType.COMPACT_INT, "Trade", "Tick", true);
        builder.addOptionalField("Trade", "Last.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Trade", "Change", true);
        builder.addOptionalField("Trade", "DayId", SerialFieldType.DATE, "Trade", "DayId", true);
        builder.addOptionalField("Trade", "Volume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Trade", "DayVolume", true);
        builder.addOptionalField("Trade", "DayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "Trade", "DayTurnover", true);
        builder.addOptionalField("Trade", "Last.Flags", SerialFieldType.COMPACT_INT, "Trade", "Flags", true);
        builder.addOptionalField("Trade", "Date", SerialFieldType.COMPACT_INT, "Trade", "Date", SystemProperties.getBooleanProperty("reuters.phantom", false));
        builder.addOptionalField("Trade", "Operation", SerialFieldType.COMPACT_INT, "Trade", "Operation", SystemProperties.getBooleanProperty("reuters.phantom", false));
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.Trade.exchanges")) {
            String recordName = "Trade&" + exchange;
            builder.addOptionalField(recordName, "Last.Time", SerialFieldType.TIME_SECONDS, "Trade", "Time", true);
            builder.addOptionalField(recordName, "Last.Sequence", SerialFieldType.SEQUENCE, "Trade", "Sequence", true);
            builder.addOptionalField(recordName, "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "Trade", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "Trade", "TradeId", true);
            builder.addRequiredField(recordName, "Last.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Last.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "Last.Tick", SerialFieldType.COMPACT_INT, "Trade", "Tick", true);
            builder.addOptionalField(recordName, "Last.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Trade", "Change", true);
            builder.addOptionalField(recordName, "DayId", SerialFieldType.DATE, "Trade", "DayId", true);
            builder.addOptionalField(recordName, "Volume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Trade", "DayVolume", true);
            builder.addOptionalField(recordName, "DayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "Trade", "DayTurnover", true);
            builder.addOptionalField(recordName, "Last.Flags", SerialFieldType.COMPACT_INT, "Trade", "Flags", true);
        }

        builder.addOptionalField("TradeETH", "ETHLast.Time", SerialFieldType.TIME_SECONDS, "TradeETH", "Time", true);
        builder.addOptionalField("TradeETH", "ETHLast.Sequence", SerialFieldType.SEQUENCE, "TradeETH", "Sequence", true);
        builder.addOptionalField("TradeETH", "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "TradeETH", "TimeNanoPart", false);
        builder.addOptionalField("TradeETH", "ETHLast.Exchange", SerialFieldType.UTF_CHAR, "TradeETH", "ExchangeCode", true);
        builder.addOptionalField("TradeETH", "TradeId", SerialFieldType.LONG, "TradeETH", "TradeId", true);
        builder.addRequiredField("TradeETH", "ETHLast.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TradeETH", "ETHLast.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("TradeETH", "ETHLast.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "TradeETH", "Change", true);
        builder.addOptionalField("TradeETH", "DayId", SerialFieldType.DATE, "TradeETH", "DayId", true);
        builder.addOptionalField("TradeETH", "ETHVolume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "TradeETH", "DayVolume", true);
        builder.addOptionalField("TradeETH", "ETHDayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "TradeETH", "DayTurnover", true);
        builder.addRequiredField("TradeETH", "ETHLast.Flags", SerialFieldType.COMPACT_INT);
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.TradeETH.exchanges")) {
            String recordName = "TradeETH&" + exchange;
            builder.addOptionalField(recordName, "ETHLast.Time", SerialFieldType.TIME_SECONDS, "TradeETH", "Time", true);
            builder.addOptionalField(recordName, "ETHLast.Sequence", SerialFieldType.SEQUENCE, "TradeETH", "Sequence", true);
            builder.addOptionalField(recordName, "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "TradeETH", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "TradeETH", "TradeId", true);
            builder.addRequiredField(recordName, "ETHLast.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "ETHLast.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ETHLast.Change", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "TradeETH", "Change", true);
            builder.addOptionalField(recordName, "DayId", SerialFieldType.DATE, "TradeETH", "DayId", true);
            builder.addOptionalField(recordName, "ETHVolume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "TradeETH", "DayVolume", true);
            builder.addOptionalField(recordName, "ETHDayTurnover", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "TradeETH", "DayTurnover", true);
            builder.addRequiredField(recordName, "ETHLast.Flags", SerialFieldType.COMPACT_INT);
        }

        builder.addRequiredField("Summary", "DayId", SerialFieldType.DATE);
        builder.addRequiredField("Summary", "DayOpen.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Summary", "DayHigh.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Summary", "DayLow.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Summary", "DayClose.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Summary", "DayClosePrice", true);
        builder.addRequiredField("Summary", "PrevDayId", SerialFieldType.DATE);
        builder.addRequiredField("Summary", "PrevDayClose.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Summary", "PrevDayVolume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Summary", "PrevDayVolume", true);
        builder.addOptionalField("Summary", "OpenInterest", selectDecimal(SerialFieldType.COMPACT_INT), "Summary", "OpenInterest", true);
        builder.addOptionalField("Summary", "Flags", SerialFieldType.COMPACT_INT, "Summary", "Flags", true);
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.Summary.exchanges")) {
            String recordName = "Summary&" + exchange;
            builder.addRequiredField(recordName, "DayId", SerialFieldType.DATE);
            builder.addRequiredField(recordName, "DayOpen.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "DayHigh.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "DayLow.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "DayClose.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Summary", "DayClosePrice", true);
            builder.addRequiredField(recordName, "PrevDayId", SerialFieldType.DATE);
            builder.addRequiredField(recordName, "PrevDayClose.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "PrevDayVolume", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Summary", "PrevDayVolume", true);
            builder.addOptionalField(recordName, "Flags", SerialFieldType.COMPACT_INT, "Summary", "Flags", true);
        }

        builder.addRequiredField("Fundamental", "Open.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "High.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "Low.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "Close.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Fundamental", "OpenInterest", selectDecimal(SerialFieldType.COMPACT_INT), "Summary", "OpenInterest", true);
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.Fundamental.exchanges")) {
            String recordName = "Fundamental&" + exchange;
            builder.addRequiredField(recordName, "Open.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "High.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Low.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Close.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        }

        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Book.exchanges", "I").toCharArray()) {
            String recordName = "Book&" + exchange;
            builder.addRequiredField(recordName, "ID", SerialFieldType.COMPACT_INT, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.VOID, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Type", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "TimeInForce", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Symbol", SerialFieldType.UTF_CHAR_ARRAY);
        }

        builder.addOptionalField("Profile", "Beta", selectDecimal(SerialFieldType.DECIMAL), "Profile", "Beta", true);
        builder.addOptionalField("Profile", "Eps", selectDecimal(SerialFieldType.DECIMAL), "Profile", "Eps", true);
        builder.addOptionalField("Profile", "DivFreq", selectDecimal(SerialFieldType.COMPACT_INT), "Profile", "DivFreq", true);
        builder.addOptionalField("Profile", "ExdDiv.Amount", selectDecimal(SerialFieldType.DECIMAL), "Profile", "ExdDivAmount", true);
        builder.addOptionalField("Profile", "ExdDiv.Date", SerialFieldType.DATE, "Profile", "ExdDivDate", true);
        builder.addOptionalField("Profile", "52High.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "HighPrice52", true);
        builder.addOptionalField("Profile", "52Low.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "LowPrice52", true);
        builder.addOptionalField("Profile", "Shares", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.shares"), "Profile", "Shares", true);
        builder.addOptionalField("Profile", "FreeFloat", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.shares"), "Profile", "FreeFloat", true);
        builder.addOptionalField("Profile", "HighLimitPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "HighLimitPrice", true);
        builder.addOptionalField("Profile", "LowLimitPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "LowLimitPrice", true);
        builder.addOptionalField("Profile", "Halt.StartTime", SerialFieldType.TIME_SECONDS, "Profile", "HaltStartTime", true);
        builder.addOptionalField("Profile", "Halt.EndTime", SerialFieldType.TIME_SECONDS, "Profile", "HaltEndTime", true);
        builder.addOptionalField("Profile", "Flags", SerialFieldType.COMPACT_INT, "Profile", "Flags", true);
        builder.addRequiredField("Profile", "Description", SerialFieldType.UTF_CHAR_ARRAY);
        builder.addOptionalField("Profile", "StatusReason", SerialFieldType.UTF_CHAR_ARRAY, "Profile", "StatusReason", true);

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.suffixes", "|#NTV|#ntv|#NFX|#ESPD|#XNFI|#ICE|#ISE|#DEA|#DEX|#dex|#BYX|#BZX|#bzx|#BATE|#CHIX|#CEUX|#BXTR|#IST|#BI20|#ABE|#FAIR|#GLBX|#glbx|#ERIS|#XEUR|#xeur|#CFE|#C2OX|#SMFE|#smfe|#iex|#MEMX|#memx|#OCEA|#ocea|#pink|#ARCA|#arca|#CEDX|#cedx|#IGC|#igc|#EDX|#edx|#NUAM|#nuam|#MOON|#moon|#OTCM|#otcm").split("\\|")) {
            String recordName = "Order" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "Order", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "Order", "ActionTime", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "Order", "OrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "Order", "AuxOrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "Order", "ExecutedSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "Count", selectDecimal(SerialFieldType.COMPACT_INT), "Order", "Count", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.Order.suffixes.count", "")));
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "Order", "TradeId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradePrice", selectDecimal(SerialFieldType.DECIMAL), "Order", "TradePrice", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradeSize", selectDecimal(SerialFieldType.DECIMAL), "Order", "TradeSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "MMID", SerialFieldType.SHORT_STRING, "Order", "MarketMaker", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.Order.suffixes.mmid", "|#NTV|#BATE|#CHIX|#CEUX|#BXTR|#pink")));
            builder.addOptionalField(recordName, "IcebergPeakSize", selectDecimal(SerialFieldType.DECIMAL), "Order", "IcebergPeakSize", false);
            builder.addOptionalField(recordName, "IcebergHiddenSize", selectDecimal(SerialFieldType.DECIMAL), "Order", "IcebergHiddenSize", false);
            builder.addOptionalField(recordName, "IcebergExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "Order", "IcebergExecutedSize", false);
            builder.addOptionalField(recordName, "IcebergFlags", SerialFieldType.COMPACT_INT, "Order", "IcebergFlags", false);
        }

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.AnalyticOrder.suffixes", "|#GLBX").split("\\|")) {
            String recordName = "AnalyticOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "AnalyticOrder", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "AnalyticOrder", "ActionTime", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "AnalyticOrder", "OrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "AnalyticOrder", "AuxOrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "ExecutedSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "Count", selectDecimal(SerialFieldType.COMPACT_INT), "AnalyticOrder", "Count", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.AnalyticOrder.suffixes.count", "")));
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "AnalyticOrder", "TradeId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradePrice", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "TradePrice", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradeSize", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "TradeSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "MMID", SerialFieldType.SHORT_STRING, "AnalyticOrder", "MarketMaker", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.AnalyticOrder.suffixes.mmid", "|#NTV|#BATE|#CHIX|#CEUX|#BXTR")));
            builder.addOptionalField(recordName, "IcebergPeakSize", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "IcebergPeakSize", false);
            builder.addOptionalField(recordName, "IcebergHiddenSize", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "IcebergHiddenSize", false);
            builder.addOptionalField(recordName, "IcebergExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "AnalyticOrder", "IcebergExecutedSize", false);
            builder.addOptionalField(recordName, "IcebergFlags", SerialFieldType.COMPACT_INT, "AnalyticOrder", "IcebergFlags", false);
        }

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.OtcMarketsOrder.suffixes", "|#pink").split("\\|")) {
            String recordName = "OtcMarketsOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "OtcMarketsOrder", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "OtcMarketsOrder", "ActionTime", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "OtcMarketsOrder", "OrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "OtcMarketsOrder", "AuxOrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "OtcMarketsOrder", "ExecutedSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "Count", selectDecimal(SerialFieldType.COMPACT_INT), "OtcMarketsOrder", "Count", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.OtcMarketsOrder.suffixes.count", "")));
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "OtcMarketsOrder", "TradeId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradePrice", selectDecimal(SerialFieldType.DECIMAL), "OtcMarketsOrder", "TradePrice", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradeSize", selectDecimal(SerialFieldType.DECIMAL), "OtcMarketsOrder", "TradeSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "MMID", SerialFieldType.SHORT_STRING, "OtcMarketsOrder", "MarketMaker", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.OtcMarketsOrder.suffixes.mmid", "|#pink")));
            builder.addRequiredField(recordName, "QuoteAccessPayment", SerialFieldType.COMPACT_INT);
            builder.addRequiredField(recordName, "OtcMarketsFlags", SerialFieldType.COMPACT_INT);
        }

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.SpreadOrder.suffixes", "|#ISE").split("\\|")) {
            String recordName = "SpreadOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "SpreadOrder", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "SpreadOrder", "ActionTime", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "SpreadOrder", "OrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "SpreadOrder", "AuxOrderId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", selectDecimal(SerialFieldType.DECIMAL), "SpreadOrder", "ExecutedSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "Count", selectDecimal(SerialFieldType.COMPACT_INT), "SpreadOrder", "Count", suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.SpreadOrder.suffixes.count", "")));
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "SpreadOrder", "TradeId", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradePrice", selectDecimal(SerialFieldType.DECIMAL), "SpreadOrder", "TradePrice", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addOptionalField(recordName, "TradeSize", selectDecimal(SerialFieldType.DECIMAL), "SpreadOrder", "TradeSize", SystemProperties.getBooleanProperty("dxscheme.fob", false) && suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV|#NUAM")));
            builder.addRequiredField(recordName, "SpreadSymbol", SerialFieldType.UTF_CHAR_ARRAY);
        }

        builder.addRequiredField("MarketMaker", "MMExchange", SerialFieldType.UTF_CHAR, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("MarketMaker", "MMID", SerialFieldType.SHORT_STRING, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("MarketMaker", "MMBid.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Order", "BidTime", true);
        builder.addRequiredField("MarketMaker", "MMBid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("MarketMaker", "MMBid.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("MarketMaker", "MMBid.Count", selectDecimal(SerialFieldType.COMPACT_INT), "Order", "BidCount", true);
        builder.addOptionalField("MarketMaker", "MMAsk.Time", selectTime(SerialFieldType.TIME_SECONDS, "dxscheme.bat"), "Order", "AskTime", true);
        builder.addRequiredField("MarketMaker", "MMAsk.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("MarketMaker", "MMAsk.Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("MarketMaker", "MMAsk.Count", selectDecimal(SerialFieldType.COMPACT_INT), "Order", "AskCount", true);

        builder.addRequiredField("TimeAndSale", "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("TimeAndSale", "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("TimeAndSale", "TimeNanoPart", SerialFieldType.COMPACT_INT, "TimeAndSale", "TimeNanoPart", false);
        builder.addRequiredField("TimeAndSale", "Exchange", SerialFieldType.UTF_CHAR);
        builder.addOptionalField("TimeAndSale", "TradeId", SerialFieldType.LONG, "TimeAndSale", "TradeId", true);
        builder.addRequiredField("TimeAndSale", "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addRequiredField("TimeAndSale", "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
        builder.addRequiredField("TimeAndSale", "Flags", SerialFieldType.COMPACT_INT);
        builder.addOptionalField("TimeAndSale", "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Buyer", false);
        builder.addOptionalField("TimeAndSale", "Seller", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Seller", false);
        for (char exchange : getExchanges("com.dxfeed.event.market.impl.TimeAndSale.exchanges")) {
            String recordName = "TimeAndSale&" + exchange;
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "TimeAndSale", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "Exchange", SerialFieldType.UTF_CHAR);
            builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "TimeAndSale", "TradeId", true);
            builder.addRequiredField(recordName, "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "Bid.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Ask.Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Buyer", false);
            builder.addOptionalField(recordName, "Seller", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Seller", false);
        }

        builder.addRequiredField("OptionSale", "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("OptionSale", "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addRequiredField("OptionSale", "Time", SerialFieldType.TIME_SECONDS);
        builder.addRequiredField("OptionSale", "Sequence", SerialFieldType.SEQUENCE);
        builder.addOptionalField("OptionSale", "TimeNanoPart", SerialFieldType.COMPACT_INT, "OptionSale", "TimeNanoPart", false);
        builder.addRequiredField("OptionSale", "ExchangeCode", SerialFieldType.UTF_CHAR);
        builder.addRequiredField("OptionSale", "Price", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("OptionSale", "Size", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"));
        builder.addRequiredField("OptionSale", "BidPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("OptionSale", "AskPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("OptionSale", "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
        builder.addRequiredField("OptionSale", "Flags", SerialFieldType.COMPACT_INT);
        builder.addRequiredField("OptionSale", "UnderlyingPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("OptionSale", "Volatility", selectDecimal(SerialFieldType.DECIMAL));
        builder.addRequiredField("OptionSale", "Delta", selectDecimal(SerialFieldType.DECIMAL));
        builder.addRequiredField("OptionSale", "OptionSymbol", SerialFieldType.UTF_CHAR_ARRAY);

        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.OrderImbalance.suffixes", "|#NUAM").split("\\|")) {
            String recordName = "OrderImbalance" + suffix;
            builder.addOptionalField(recordName, "Time", SerialFieldType.TIME_SECONDS, "OrderImbalance", "Time", true);
            builder.addOptionalField(recordName, "Sequence", SerialFieldType.SEQUENCE, "OrderImbalance", "Sequence", true);
            builder.addRequiredField(recordName, "RefPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "PairedSize", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "ImbalanceSize", selectDecimal(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "NearPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "OrderImbalance", "NearPrice", true);
            builder.addOptionalField(recordName, "FarPrice", selectDecimal(SerialFieldType.DECIMAL, "dxscheme.price"), "OrderImbalance", "FarPrice", true);
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
        }
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(QuoteMapping.class) != null) {
            result.add(new QuoteDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new QuoteDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidUnitaryDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteBidUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskUnitaryDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteAskUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeMapping.class) != null) {
            result.add(new TradeDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeETHMapping.class) != null) {
            result.add(new TradeETHDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TradeETHDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SummaryMapping.class) != null) {
            result.add(new SummaryDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new SummaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ProfileMapping.class) != null) {
            result.add(new ProfileDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new ProfileDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OrderMapping.class) != null) {
            result.add(new OrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(AnalyticOrderMapping.class) != null) {
            result.add(new AnalyticOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new AnalyticOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(OtcMarketsOrderMapping.class) != null) {
            result.add(new OtcMarketsOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OtcMarketsOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(SpreadOrderMapping.class) != null) {
            result.add(new SpreadOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new SpreadOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(MarketMakerMapping.class) != null) {
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByMarketMakerBidUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerBidUnitaryDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByMarketMakerAskUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskUnitaryDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new MarketMakerDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new MarketMakerDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(TimeAndSaleMapping.class) != null) {
            result.add(new TimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new TimeAndSaleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        } else if (record.getMapping(OptionSaleMapping.class) != null) {
            result.add(new OptionSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OptionSaleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(OrderImbalanceMapping.class) != null) {
            result.add(new OrderImbalanceDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new OrderImbalanceDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        Collection<EventDelegate<?>> result = new ArrayList<>();
        if (record.getMapping(QuoteMapping.class) != null) {
            result.add(new QuoteDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeMapping.class) != null) {
            result.add(new TradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeETHMapping.class) != null) {
            result.add(new TradeETHDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SummaryMapping.class) != null) {
            result.add(new SummaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ProfileMapping.class) != null) {
            result.add(new ProfileDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OrderMapping.class) != null) {
            result.add(new OrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(AnalyticOrderMapping.class) != null) {
            result.add(new AnalyticOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OtcMarketsOrderMapping.class) != null) {
            result.add(new OtcMarketsOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SpreadOrderMapping.class) != null) {
            result.add(new SpreadOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(MarketMakerMapping.class) != null) {
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerBidUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskUnitaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new MarketMakerDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TimeAndSaleMapping.class) != null) {
            result.add(new TimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OptionSaleMapping.class) != null) {
            result.add(new OptionSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OrderImbalanceMapping.class) != null) {
            result.add(new OrderImbalanceDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = getBaseRecordName(record.getName());
        if (baseRecordName.equals("Quote"))
            return new QuoteMapping(record);
        if (baseRecordName.equals("Trade"))
            return new TradeMapping(record);
        if (baseRecordName.equals("TradeETH"))
            return new TradeETHMapping(record);
        if (baseRecordName.equals("Summary"))
            return new SummaryMapping(record);
        if (baseRecordName.equals("Fundamental"))
            return new FundamentalMapping(record);
        if (baseRecordName.equals("Book"))
            return new BookMapping(record);
        if (baseRecordName.equals("Profile"))
            return new ProfileMapping(record);
        if (baseRecordName.equals("Order"))
            return new OrderMapping(record);
        if (baseRecordName.equals("AnalyticOrder"))
            return new AnalyticOrderMapping(record);
        if (baseRecordName.equals("OtcMarketsOrder"))
            return new OtcMarketsOrderMapping(record);
        if (baseRecordName.equals("SpreadOrder"))
            return new SpreadOrderMapping(record);
        if (baseRecordName.equals("MarketMaker"))
            return new MarketMakerMapping(record);
        if (baseRecordName.equals("TimeAndSale"))
            return new TimeAndSaleMapping(record);
        if (baseRecordName.equals("OptionSale"))
            return new OptionSaleMapping(record);
        if (baseRecordName.equals("OrderImbalance"))
            return new OrderImbalanceMapping(record);
        return null;
    }
// END: CODE AUTOMATICALLY GENERATED

    @Override
    protected String getBaseRecordName(String recordName) {
        String s = MarketEventSymbols.getBaseSymbol(recordName);
        int i = s.lastIndexOf(OrderBaseMapping.SOURCE_ID_SEPARATOR);
        return i < 0 ? s : s.substring(0, i);
    }
}
