/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2021 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;

public final class FundamentalMapping extends MarketEventMapping {
// BEGIN: CODE AUTOMATICALLY GENERATED: DO NOT MODIFY. IT IS REGENERATED BY com.dxfeed.api.codegen.ImplCodeGen
    private final int iOpen;
    private final int iHigh;
    private final int iLow;
    private final int iClose;
    private final int iOpenInterest;

    public FundamentalMapping(DataRecord record) {
        super(record);
        iOpen = findIntField("Open.Price", true);
        iHigh = findIntField("High.Price", true);
        iLow = findIntField("Low.Price", true);
        iClose = findIntField("Close.Price", true);
        iOpenInterest = findIntField("OpenInterest", false);
        putNonDefaultPropertyName("Open.Price", "Open");
        putNonDefaultPropertyName("High.Price", "High");
        putNonDefaultPropertyName("Low.Price", "Low");
        putNonDefaultPropertyName("Close.Price", "Close");
    }

    @Deprecated
    public double getOpenPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iOpen);
    }

    @Deprecated
    public void setOpenPrice(RecordCursor cursor, double openPrice) {
        setAsDouble(cursor, iOpen, openPrice);
    }

    @Deprecated
    public int getOpenPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iOpen);
    }

    @Deprecated
    public void setOpenPriceDecimal(RecordCursor cursor, int openPrice) {
        setAsTinyDecimal(cursor, iOpen, openPrice);
    }

    @Deprecated
    public long getOpenPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iOpen);
    }

    @Deprecated
    public void setOpenPriceWideDecimal(RecordCursor cursor, long openPrice) {
        setAsWideDecimal(cursor, iOpen, openPrice);
    }

    public double getOpen(RecordCursor cursor) {
        return getAsDouble(cursor, iOpen);
    }

    public void setOpen(RecordCursor cursor, double open) {
        setAsDouble(cursor, iOpen, open);
    }

    public int getOpenDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iOpen);
    }

    public void setOpenDecimal(RecordCursor cursor, int open) {
        setAsTinyDecimal(cursor, iOpen, open);
    }

    public long getOpenWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iOpen);
    }

    public void setOpenWideDecimal(RecordCursor cursor, long open) {
        setAsWideDecimal(cursor, iOpen, open);
    }

    @Deprecated
    public double getHighPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iHigh);
    }

    @Deprecated
    public void setHighPrice(RecordCursor cursor, double highPrice) {
        setAsDouble(cursor, iHigh, highPrice);
    }

    @Deprecated
    public int getHighPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iHigh);
    }

    @Deprecated
    public void setHighPriceDecimal(RecordCursor cursor, int highPrice) {
        setAsTinyDecimal(cursor, iHigh, highPrice);
    }

    @Deprecated
    public long getHighPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iHigh);
    }

    @Deprecated
    public void setHighPriceWideDecimal(RecordCursor cursor, long highPrice) {
        setAsWideDecimal(cursor, iHigh, highPrice);
    }

    public double getHigh(RecordCursor cursor) {
        return getAsDouble(cursor, iHigh);
    }

    public void setHigh(RecordCursor cursor, double high) {
        setAsDouble(cursor, iHigh, high);
    }

    public int getHighDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iHigh);
    }

    public void setHighDecimal(RecordCursor cursor, int high) {
        setAsTinyDecimal(cursor, iHigh, high);
    }

    public long getHighWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iHigh);
    }

    public void setHighWideDecimal(RecordCursor cursor, long high) {
        setAsWideDecimal(cursor, iHigh, high);
    }

    @Deprecated
    public double getLowPrice(RecordCursor cursor) {
        return getAsDouble(cursor, iLow);
    }

    @Deprecated
    public void setLowPrice(RecordCursor cursor, double lowPrice) {
        setAsDouble(cursor, iLow, lowPrice);
    }

    @Deprecated
    public int getLowPriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iLow);
    }

    @Deprecated
    public void setLowPriceDecimal(RecordCursor cursor, int lowPrice) {
        setAsTinyDecimal(cursor, iLow, lowPrice);
    }

    @Deprecated
    public long getLowPriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iLow);
    }

    @Deprecated
    public void setLowPriceWideDecimal(RecordCursor cursor, long lowPrice) {
        setAsWideDecimal(cursor, iLow, lowPrice);
    }

    public double getLow(RecordCursor cursor) {
        return getAsDouble(cursor, iLow);
    }

    public void setLow(RecordCursor cursor, double low) {
        setAsDouble(cursor, iLow, low);
    }

    public int getLowDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iLow);
    }

    public void setLowDecimal(RecordCursor cursor, int low) {
        setAsTinyDecimal(cursor, iLow, low);
    }

    public long getLowWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iLow);
    }

    public void setLowWideDecimal(RecordCursor cursor, long low) {
        setAsWideDecimal(cursor, iLow, low);
    }

    @Deprecated
    public double getClosePrice(RecordCursor cursor) {
        return getAsDouble(cursor, iClose);
    }

    @Deprecated
    public void setClosePrice(RecordCursor cursor, double closePrice) {
        setAsDouble(cursor, iClose, closePrice);
    }

    @Deprecated
    public int getClosePriceDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iClose);
    }

    @Deprecated
    public void setClosePriceDecimal(RecordCursor cursor, int closePrice) {
        setAsTinyDecimal(cursor, iClose, closePrice);
    }

    @Deprecated
    public long getClosePriceWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iClose);
    }

    @Deprecated
    public void setClosePriceWideDecimal(RecordCursor cursor, long closePrice) {
        setAsWideDecimal(cursor, iClose, closePrice);
    }

    public double getClose(RecordCursor cursor) {
        return getAsDouble(cursor, iClose);
    }

    public void setClose(RecordCursor cursor, double close) {
        setAsDouble(cursor, iClose, close);
    }

    public int getCloseDecimal(RecordCursor cursor) {
        return getAsTinyDecimal(cursor, iClose);
    }

    public void setCloseDecimal(RecordCursor cursor, int close) {
        setAsTinyDecimal(cursor, iClose, close);
    }

    public long getCloseWideDecimal(RecordCursor cursor) {
        return getAsWideDecimal(cursor, iClose);
    }

    public void setCloseWideDecimal(RecordCursor cursor, long close) {
        setAsWideDecimal(cursor, iClose, close);
    }

    public int getOpenInterest(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsInt(cursor, iOpenInterest);
    }

    public void setOpenInterest(RecordCursor cursor, int openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsInt(cursor, iOpenInterest, openInterest);
    }

    public long getOpenInterestLong(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsLong(cursor, iOpenInterest);
    }

    public void setOpenInterestLong(RecordCursor cursor, long openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsLong(cursor, iOpenInterest, openInterest);
    }

    public double getOpenInterestDouble(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return Double.NaN;
        return getAsDouble(cursor, iOpenInterest);
    }

    public void setOpenInterestDouble(RecordCursor cursor, double openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsDouble(cursor, iOpenInterest, openInterest);
    }

    public int getOpenInterestDecimal(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsTinyDecimal(cursor, iOpenInterest);
    }

    public void setOpenInterestDecimal(RecordCursor cursor, int openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsTinyDecimal(cursor, iOpenInterest, openInterest);
    }

    public long getOpenInterestWideDecimal(RecordCursor cursor) {
        if (iOpenInterest < 0)
            return 0;
        return getAsWideDecimal(cursor, iOpenInterest);
    }

    public void setOpenInterestWideDecimal(RecordCursor cursor, long openInterest) {
        if (iOpenInterest < 0)
            return;
        setAsWideDecimal(cursor, iOpenInterest, openInterest);
    }
// END: CODE AUTOMATICALLY GENERATED
}
