/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.logging.Logging;
import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DXEndpointListenerTest {
    private static final Logging log = Logging.getLogging(DXEndpointListenerTest.class);
    private static final int AWAIT_TIMEOUT = 10000;
    private volatile CountDownLatch pass;
    private volatile DXEndpoint.State expectedState;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
    }

    @After
    public void tearDown() throws Exception {
        ThreadCleanCheck.after();
    }

    @Test
    public void testSimpleListener() throws InterruptedException {
        DXEndpoint endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.PUBLISHER);
        this.pass = new CountDownLatch(1);
        this.expectedState = DXEndpoint.State.CONNECTED;
        endpoint.addStateChangeListener(evt -> {
            this.logChangeEvent(evt);
            if (evt.getNewValue() == this.expectedState) {
                this.pass.countDown();
            }
        });
        endpoint.connect(":0");
        this.await("CONNECTED state reached", this.pass);
        this.pass = new CountDownLatch(1);
        this.expectedState = DXEndpoint.State.NOT_CONNECTED;
        endpoint.disconnect();
        this.await("NOT_CONNECTED state reached", this.pass);
        this.pass = new CountDownLatch(1);
        this.expectedState = DXEndpoint.State.CLOSED;
        endpoint.close();
        this.await("CLOSED state reached", this.pass);
    }

    @Test
    public void testDisconnectFromListener() throws InterruptedException {
        DXEndpoint endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.PUBLISHER);
        endpoint.addStateChangeListener(evt -> {
            this.logChangeEvent(evt);
            if (evt.getNewValue() == DXEndpoint.State.CONNECTED) {
                endpoint.disconnect();
            }
        });
        endpoint.connect(":0");
        endpoint.awaitNotConnected();
        endpoint.close();
    }

    @Test
    public void testInnerAwaitNotConnected() throws InterruptedException {
        DXEndpoint endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.PUBLISHER).withProperty("dxfeed.threadPoolSize", "4").build();
        this.pass = new CountDownLatch(1);
        CountDownLatch innerWaitSucceded = new CountDownLatch(1);
        endpoint.addStateChangeListener(evt -> {
            this.logChangeEvent(evt);
            if (evt.getNewValue() == DXEndpoint.State.CONNECTED) {
                this.pass.countDown();
                log.info("Inner wait for disconnect...");
                try {
                    endpoint.awaitNotConnected();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                innerWaitSucceded.countDown();
            }
        });
        endpoint.connect(":0");
        this.await("CONNECTED state reached", this.pass);
        log.info("Disconnecting...");
        endpoint.disconnect();
        this.await("NOT_CONNECTED witnessed by inner wait", innerWaitSucceded);
        log.info("Closing...");
        endpoint.close();
    }

    @Test
    public void testInnerAwaitClosed() throws InterruptedException {
        DXEndpoint endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.PUBLISHER).withProperty("dxfeed.threadPoolSize", "4").build();
        this.pass = new CountDownLatch(1);
        CountDownLatch innerWaitSucceded = new CountDownLatch(1);
        endpoint.addStateChangeListener(evt -> {
            this.logChangeEvent(evt);
            if (evt.getNewValue() == DXEndpoint.State.CONNECTED) {
                this.pass.countDown();
            }
            if (evt.getNewValue() == DXEndpoint.State.NOT_CONNECTED) {
                this.pass.countDown();
                log.info("Inner wait for disconnect...");
                try {
                    endpoint.closeAndAwaitTermination();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                innerWaitSucceded.countDown();
            }
        });
        endpoint.connect(":0");
        this.await("CONNECTED state reached", this.pass);
        this.pass = new CountDownLatch(1);
        log.info("Disconnecting...");
        endpoint.disconnect();
        this.await("NOT_CONNECTED state reached", this.pass);
        log.info("Waiting inner close...");
        this.await("Closed by inner wait", innerWaitSucceded);
        Assert.assertEquals((Object)DXEndpoint.State.CLOSED, (Object)endpoint.getState());
    }

    private void await(String message, CountDownLatch pass) throws InterruptedException {
        Assert.assertTrue((String)message, (boolean)pass.await(10000L, TimeUnit.MILLISECONDS));
    }

    private void logChangeEvent(PropertyChangeEvent evt) {
        log.info("****** " + evt.getPropertyName() + ": " + evt.getOldValue() + " -> " + evt.getNewValue());
    }
}

