/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.logging.Logging;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import com.dxfeed.api.osub.WildcardSymbol;
import com.dxfeed.api.test.AbstractDXPublisherTest;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandlePrice;
import com.dxfeed.event.candle.CandleSession;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.candle.CandleType;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.PriceType;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.event.market.TimeAndSaleType;
import com.dxfeed.event.market.Trade;
import com.dxfeed.event.option.Series;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DXPublisherTest
extends AbstractDXPublisherTest {
    private static final Logging log = Logging.getLogging(DXPublisherTest.class);
    private static final char[] EXCHANGE_CODES = "A~Z\u0000X9B".toCharArray();

    public DXPublisherTest(DXEndpoint.Role role) {
        super(role);
    }

    @Override
    protected DXEndpoint.Builder endpointBuilder() {
        return super.endpointBuilder().withProperty("dxscheme.nanoTime", "true");
    }

    @Test
    public void testSubscriptionNotificationLoss() throws InterruptedException {
        this.setUp("testSubscriptionNotificationLoss");
        HashSet<String> symbols = new HashSet<String>(Arrays.asList("AAPL,GOOG,IBM,GE".split(",")));
        Object firstSymbol = symbols.iterator().next();
        final HashSet added = new HashSet();
        final HashSet removed = new HashSet();
        ObservableSubscriptionChangeListener observableSubChangeListener = new ObservableSubscriptionChangeListener(){

            public void symbolsAdded(Set<?> symbols) {
                log.info("symbolsAdded " + symbols);
                added.addAll(symbols);
                Assert.assertFalse((boolean)symbols.isEmpty());
                throw new RuntimeException();
            }

            public void symbolsRemoved(Set<?> symbols) {
                log.info("symbolsRemoved " + symbols);
                removed.addAll(symbols);
                Assert.assertFalse((boolean)symbols.isEmpty());
                throw new RuntimeException();
            }
        };
        Class<Quote> eventType = Quote.class;
        this.publisher.getSubscription(eventType).addChangeListener(observableSubChangeListener);
        DXFeedSubscription sub = this.feed.createSubscription(eventType);
        log.info("Adding symbol " + firstSymbol);
        sub.addSymbols(firstSymbol);
        this.checkpoint();
        log.info("Adding rest of symbols " + symbols);
        sub.addSymbols(symbols.toArray());
        this.checkpoint();
        Assert.assertEquals(symbols, added);
        log.info("Removing symbol " + firstSymbol);
        sub.removeSymbols(new Object[]{firstSymbol});
        this.checkpoint();
        log.info("Closing subscription with rest of symbols " + symbols);
        sub.close();
        this.checkpoint();
        Assert.assertEquals(symbols, added);
        Assert.assertEquals(symbols, removed);
        this.publisher.getSubscription(eventType).removeChangeListener(observableSubChangeListener);
        this.tearDown();
    }

    @Test
    public void testQuote() throws InterruptedException {
        for (char exchangeCode : EXCHANGE_CODES) {
            String symbol = MarketEventSymbols.changeExchangeCode((String)"Quote", (char)exchangeCode);
            AbstractDXPublisherTest.EventCreator<Quote> eventCreator = i -> {
                Quote q = new Quote(symbol);
                if (i < 0) {
                    return q;
                }
                q.setEventTime((long)i++);
                q.setBidPrice((double)i++);
                q.setBidSize((long)i++);
                q.setBidExchangeCode(exchangeCode == '\u0000' ? (char)'X' : (char)exchangeCode);
                q.setBidTime((long)i++ * 1000L);
                q.setAskPrice((double)i++);
                q.setAskSize((long)i++);
                q.setAskTime((long)i++ * 1000L);
                q.setTimeNanoPart(i++);
                q.setAskExchangeCode(exchangeCode == '\u0000' ? (char)'Y' : (char)exchangeCode);
                return q;
            };
            this.testEventPublishing(Quote.class, symbol, eventCreator);
            this.testEventPublishing(Quote.class, WildcardSymbol.ALL, eventCreator);
        }
        Quote quote = new Quote("Quote");
        quote.setAskSize(1000L);
        quote.setEventTime(100L);
        this.testGetLastEvent(Quote.class, quote, new Quote(), (publishedEvent, receivedEvent) -> {
            Assert.assertEquals((long)publishedEvent.getAskSize(), (long)receivedEvent.getAskSize());
            Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
        });
    }

    @Test
    public void testTrade() throws InterruptedException {
        String symbol = "Trade";
        this.testEventPublishing(Trade.class, "Trade", i -> {
            Trade t = new Trade("Trade");
            if (i < 0) {
                return t;
            }
            t.setEventTime((long)i++);
            t.setTime((long)i++);
            t.setSequence(i++);
            t.setTradeId((long)i++);
            t.setPrice((double)i++);
            t.setSize((long)i++);
            char exchangeCode = EXCHANGE_CODES[i % EXCHANGE_CODES.length];
            t.setExchangeCode(exchangeCode == '\u0000' ? (char)'C' : exchangeCode);
            t.setTimeNanos((long)i++ * 1000000L + (long)i++);
            t.setDayVolume((long)i++);
            return t;
        });
        Trade trade = new Trade("Trade");
        trade.setSize(1000L);
        trade.setEventTime(100L);
        this.testGetLastEvent(Trade.class, trade, new Trade(), (publishedEvent, receivedEvent) -> {
            Assert.assertEquals((long)publishedEvent.getSize(), (long)receivedEvent.getSize());
            Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
            Assert.assertEquals((long)publishedEvent.getTradeId(), (long)receivedEvent.getTradeId());
        });
    }

    @Test
    public void testSummary() throws InterruptedException {
        String symbol = "Summary";
        this.testEventPublishing(Summary.class, "Summary", i -> {
            Summary s = new Summary("Summary");
            if (i < 0) {
                return s;
            }
            s.setEventTime((long)i++);
            s.setDayId(i++);
            s.setDayOpenPrice((double)i++);
            s.setDayClosePrice((double)i++);
            s.setDayHighPrice((double)i++);
            s.setDayLowPrice((double)i++);
            s.setPrevDayId(i++);
            s.setPrevDayClosePrice((double)i++);
            s.setOpenInterest((long)i++);
            s.setDayClosePriceType(PriceType.values()[i++ % PriceType.values().length]);
            s.setPrevDayClosePriceType(PriceType.values()[i++ % PriceType.values().length]);
            return s;
        });
        Summary summary = new Summary("Summary");
        summary.setDayId(100);
        summary.setEventTime(100L);
        this.testGetLastEvent(Summary.class, summary, new Summary(), (publishedEvent, receivedEvent) -> {
            Assert.assertEquals((long)publishedEvent.getDayId(), (long)receivedEvent.getDayId());
            Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
        });
    }

    @Test
    public void testProfile() throws InterruptedException {
        String symbol = "Profile";
        this.testEventPublishing(Profile.class, "Profile", i -> {
            Profile p = new Profile("Profile");
            if (i < 0) {
                return p;
            }
            p.setEventTime((long)i++);
            p.setHaltStartTime((long)i++ * 1000L);
            p.setHaltEndTime((long)i++ * 1000L);
            p.setDescription("" + i++);
            p.setStatusReason("" + i++);
            return p;
        });
        Profile profile = new Profile("Profile");
        profile.setHighLimitPrice(100.0);
        profile.setEventTime(100L);
        this.testGetLastEvent(Profile.class, profile, new Profile(), (publishedEvent, receivedEvent) -> {
            Assert.assertEquals((double)publishedEvent.getHighLimitPrice(), (double)receivedEvent.getHighLimitPrice(), (double)0.0);
            Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
        });
    }

    @Test
    public void testSeries() throws InterruptedException {
        String symbol = "Series";
        this.testEventPublishing(Series.class, "Series", i -> {
            Series s = new Series("Series");
            if (i < 0) {
                return s;
            }
            s.setEventTime((long)i++);
            s.setIndex((long)i++);
            s.setExpiration(i++);
            s.setVolatility((double)i++);
            s.setPutCallRatio((double)i++);
            s.setForwardPrice((double)i++);
            s.setInterest((double)i++);
            s.setDividend((double)i++);
            return s;
        });
    }

    @Test
    public void testTimeAndSale() throws InterruptedException {
        String symbol = "TimeAndSale";
        AbstractDXPublisherTest.EventCreator<TimeAndSale> eventCreator = i -> {
            TimeAndSale ts = new TimeAndSale("TimeAndSale");
            if (i < 0) {
                return ts;
            }
            ts.setEventTime((long)i++);
            ts.setTimeNanos((long)i++ * 1000000L + (long)i++);
            ts.setSequence(i++);
            ts.setPrice((double)i++);
            ts.setSize((long)i++);
            ts.setTradeId((long)i++);
            ts.setExchangeCode((char)i++);
            ts.setBidPrice((double)i++);
            ts.setAskPrice((double)i++);
            ts.setExchangeSaleConditions(i++ == 0 ? null : Integer.toBinaryString(i++ % 16));
            ts.setValidTick(i++ % 2 == 0);
            ts.setType(TimeAndSaleType.values()[i++ % TimeAndSaleType.values().length]);
            return ts;
        };
        this.testEventPublishing(TimeAndSale.class, "TimeAndSale", eventCreator);
        this.testEventPublishing(TimeAndSale.class, WildcardSymbol.ALL, eventCreator);
        if (this.role == DXEndpoint.Role.LOCAL_HUB) {
            this.testTimeSeriesEventPublishing(TimeAndSale.class, "TimeAndSale", eventCreator);
        }
    }

    @Test
    public void testOrder() throws InterruptedException {
        String symbol = "Order";
        AbstractDXPublisherTest.EventCreator<Order> eventCreator = i -> {
            Order o = new Order("Order");
            if (i < 0) {
                return o;
            }
            o.setEventTime((long)i++);
            o.setIndex((long)i++);
            o.setScope(Scope.values()[i++ % Scope.values().length]);
            o.setOrderSide(i++ % 2 == 0 ? Side.BUY : Side.SELL);
            o.setPrice((double)i++);
            o.setSize((long)i++);
            o.setExchangeCode((char)i);
            o.setTimeNanos((long)i++ * 1000000L + (long)i++);
            o.setSequence(i++);
            o.setMarketMaker(Integer.toHexString(i++));
            return o;
        };
        IndexedEventSubscriptionSymbol subSymbol = new IndexedEventSubscriptionSymbol((Object)"Order", (IndexedEventSource)OrderSource.DEFAULT);
        this.testEventPublishing(Order.class, subSymbol, eventCreator);
        this.testEventPublishing(Order.class, WildcardSymbol.ALL, eventCreator);
    }

    @Test
    public void testCandle() throws InterruptedException {
        LinkedHashSet<CandleSymbol> symbols = new LinkedHashSet<CandleSymbol>();
        Random r = new Random(0L);
        for (int i2 = 0; i2 < 100; ++i2) {
            CandleSymbol symbol = CandleSymbol.valueOf((String)"Candle", (CandleSymbolAttribute)CandlePeriod.valueOf((double)(r.nextInt(3) + 1), (CandleType)CandleType.values()[r.nextInt(CandleType.values().length)]));
            if (r.nextBoolean()) {
                CandlePrice priceAttr = CandlePrice.values()[r.nextInt(CandlePrice.values().length)];
                symbol = CandleSymbol.valueOf((String)symbol.toString(), (CandleSymbolAttribute)priceAttr);
            }
            if (r.nextBoolean()) {
                CandleSession sessionAttr = CandleSession.values()[r.nextInt(CandleSession.values().length)];
                symbol = CandleSymbol.valueOf((String)symbol.toString(), (CandleSymbolAttribute)sessionAttr);
            }
            symbols.add(symbol);
        }
        for (CandlePrice price : CandlePrice.values()) {
            CandleSymbol symbol = CandleSymbol.valueOf((String)"Candle", (CandleSymbolAttribute)price, (CandleSymbolAttribute[])new CandleSymbolAttribute[]{CandlePeriod.valueOf((double)1.0, (CandleType)CandleType.MINUTE)});
            symbols.add(symbol);
        }
        for (CandleSymbol symbol : symbols) {
            AbstractDXPublisherTest.EventCreator<Candle> eventCreator = i -> {
                Candle c = new Candle(symbol);
                if (i < 0) {
                    return c;
                }
                c.setEventTime((long)i++);
                c.setTime((long)i++);
                c.setSequence(i++);
                c.setClose((double)i++);
                c.setVolume((long)i++);
                if (symbol.getPeriod() != CandlePeriod.TICK) {
                    c.setCount((long)i++);
                    c.setOpen((double)i++);
                    c.setHigh((double)i++);
                    c.setLow((double)i++);
                    c.setVWAP((double)i++);
                }
                return c;
            };
            AbstractDXPublisherTest.EventChecker<Candle> eventChecker = (publishedEvent, receivedEvent) -> {
                Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
                Assert.assertEquals((long)publishedEvent.getIndex(), (long)receivedEvent.getIndex());
                Assert.assertEquals((long)publishedEvent.getTime(), (long)receivedEvent.getTime());
                Assert.assertEquals((double)publishedEvent.getClose(), (double)receivedEvent.getClose(), (double)0.0);
                Assert.assertEquals((long)publishedEvent.getVolume(), (long)receivedEvent.getVolume());
                if (symbol.getPeriod() != CandlePeriod.TICK) {
                    Assert.assertEquals((long)publishedEvent.getCount(), (long)receivedEvent.getCount());
                    Assert.assertEquals((double)publishedEvent.getOpen(), (double)receivedEvent.getOpen(), (double)0.0);
                    Assert.assertEquals((double)publishedEvent.getHigh(), (double)receivedEvent.getHigh(), (double)0.0);
                    Assert.assertEquals((double)publishedEvent.getLow(), (double)receivedEvent.getLow(), (double)0.0);
                    Assert.assertEquals((double)publishedEvent.getVWAP(), (double)receivedEvent.getVWAP(), (double)0.0);
                } else {
                    Assert.assertEquals((long)1L, (long)receivedEvent.getCount());
                    Assert.assertEquals((double)publishedEvent.getClose(), (double)receivedEvent.getOpen(), (double)0.0);
                    Assert.assertEquals((double)publishedEvent.getClose(), (double)receivedEvent.getHigh(), (double)0.0);
                    Assert.assertEquals((double)publishedEvent.getClose(), (double)receivedEvent.getLow(), (double)0.0);
                }
            };
            this.testEventPublishing(Candle.class, symbol, eventCreator, eventChecker);
            this.testEventPublishing(Candle.class, WildcardSymbol.ALL, eventCreator, eventChecker);
            if (this.role == DXEndpoint.Role.LOCAL_HUB) {
                this.testTimeSeriesEventPublishing(Candle.class, symbol, eventCreator, eventChecker);
            }
            Candle candle = new Candle(symbol);
            candle.setTime(100L);
            candle.setEventTime(100L);
            this.testGetLastEvent(Candle.class, candle, new Candle(), (publishedEvent, receivedEvent) -> {
                Assert.assertEquals((long)publishedEvent.getTime(), (long)receivedEvent.getTime());
                Assert.assertEquals((long)publishedEvent.getEventTime(), (long)receivedEvent.getEventTime());
            });
        }
    }
}

