/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.test;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorFactory;
import com.devexperts.qd.qtp.socket.ClientSocketConnector;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TestConnectorFactory
implements MessageConnectorFactory {
    private static final ConcurrentHashMap<String, TestFactory> factories = new ConcurrentHashMap();

    public static void add(String prefix, TestFactory testFactory) {
        factories.put(prefix, testFactory);
    }

    public static void addClientSocketConnectorForBlockedPorts(String prefix, final Set<Integer> blockedPorts) {
        TestConnectorFactory.add(prefix, (acf, address) -> {
            int portIndex = address.lastIndexOf(58);
            String host = address.substring(0, portIndex);
            int port = Integer.parseInt(address.substring(portIndex + 1));
            return new ClientSocketConnector(acf, host, port){

                protected Socket createSocket(String host, int port) throws IOException {
                    if (blockedPorts.contains(port)) {
                        throw new ConnectException("Port is blocked " + port);
                    }
                    return super.createSocket(host, port);
                }
            };
        });
    }

    public static void remove(String prefix) {
        factories.remove(prefix);
    }

    public MessageConnector createMessageConnector(ApplicationConnectionFactory acf, String address) {
        for (String prefix : factories.keySet()) {
            if (!address.startsWith(prefix)) continue;
            return factories.remove(prefix).create(acf, address.substring(prefix.length()));
        }
        return null;
    }

    public Class<? extends MessageConnector> getResultingClass() {
        return MessageConnector.class;
    }

    public static interface TestFactory {
        public MessageConnector create(ApplicationConnectionFactory var1, String var2);
    }
}

