/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.test;

import com.devexperts.test.ThreadCleanCheck;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.IndexedEventModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedEventModelTest {
    private static final String SYMBOL = "INDEX-TEST";
    private DXEndpoint endpoint;
    private DXPublisher publisher;
    private final List<Runnable> executionQueue = new ArrayList<Runnable>();
    private final IndexedEventModel<Order> indexedOrders = new IndexedEventModel(Order.class);
    private boolean changed;

    @Before
    public void setUp() throws Exception {
        ThreadCleanCheck.before();
        this.endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.LOCAL_HUB);
        this.publisher = this.endpoint.getPublisher();
        DXFeed feed = this.endpoint.getFeed();
        this.endpoint.executor(this.executionQueue::add);
        this.indexedOrders.setSymbol((Object)SYMBOL);
        this.indexedOrders.getEventsList().addListener(change -> {
            this.changed = true;
        });
        this.indexedOrders.attach(feed);
    }

    @After
    public void tearDown() throws Exception {
        this.endpoint.close();
        ThreadCleanCheck.after();
    }

    @Test
    public void testSimple() {
        this.checkSize(0);
        this.publish(1, 12.34, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(1);
        this.check(0, 1, 12.34);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 1, 12.34);
        this.check(1, 2, 56.78);
        this.publish(1, 12.34, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(1);
        this.check(0, 2, 56.78);
        this.publish(2, 56.78, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
    }

    @Test
    public void testEventListIterator() {
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().iterator().hasNext());
        this.publish(1, 12.34, 0);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 1, 12.34);
        this.check(1, 2, 56.78);
        Iterator it = this.indexedOrders.getEventsList().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        this.checkOrder((Order)it.next(), 1, 12.34);
        Assert.assertTrue((boolean)it.hasNext());
        this.checkOrder((Order)it.next(), 2, 56.78);
        Assert.assertFalse((boolean)it.hasNext());
        this.publish(1, 12.34, 2);
        this.publish(2, 56.78, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().iterator().hasNext());
    }

    @Test
    public void testListIterator() {
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator().hasNext());
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator().hasPrevious());
        this.publish(1, 12.34, 0);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 1, 12.34);
        this.check(1, 2, 56.78);
        ListIterator it = this.indexedOrders.getEventsList().listIterator();
        Assert.assertTrue((boolean)it.hasNext());
        this.checkOrder((Order)it.next(), 1, 12.34);
        Assert.assertTrue((boolean)it.hasNext());
        this.checkOrder((Order)it.next(), 2, 56.78);
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasPrevious());
        this.checkOrder((Order)it.previous(), 2, 56.78);
        Assert.assertTrue((boolean)it.hasPrevious());
        this.checkOrder((Order)it.previous(), 1, 12.34);
        Assert.assertFalse((boolean)it.hasPrevious());
        this.publish(1, 12.34, 2);
        this.publish(2, 56.78, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator().hasNext());
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator().hasPrevious());
    }

    @Test
    public void testListIteratorWithIndex() {
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator(0).hasNext());
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator(0).hasPrevious());
        this.publish(1, 12.34, 0);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 1, 12.34);
        this.check(1, 2, 56.78);
        ListIterator it = this.indexedOrders.getEventsList().listIterator(0);
        Assert.assertTrue((boolean)it.hasNext());
        this.checkOrder((Order)it.next(), 1, 12.34);
        it = this.indexedOrders.getEventsList().listIterator(1);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasPrevious());
        this.checkOrder((Order)it.next(), 2, 56.78);
        Assert.assertFalse((boolean)it.hasNext());
        it = this.indexedOrders.getEventsList().listIterator(2);
        Assert.assertTrue((boolean)it.hasPrevious());
        this.checkOrder((Order)it.previous(), 2, 56.78);
        it = this.indexedOrders.getEventsList().listIterator(1);
        Assert.assertTrue((boolean)it.hasPrevious());
        this.checkOrder((Order)it.previous(), 1, 12.34);
        Assert.assertFalse((boolean)it.hasPrevious());
        this.publish(1, 12.34, 2);
        this.publish(2, 56.78, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator(0).hasNext());
        Assert.assertFalse((boolean)this.indexedOrders.getEventsList().listIterator(0).hasPrevious());
    }

    @Test
    public void testCloseEmpty() {
        this.checkSize(0);
        this.indexedOrders.close();
    }

    @Test
    public void testCloseEmptyAfterWork() {
        this.checkSize(0);
        this.publish(1, 12.34, 0);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.publish(1, 12.34, 2);
        this.publish(2, 56.78, 2);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
        this.indexedOrders.close();
    }

    @Test
    public void testCloseNonEmpty() {
        this.checkSize(0);
        this.publish(1, 12.34, 0);
        this.publish(2, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.indexedOrders.close();
    }

    @Test
    public void testCloseAbruptly() {
        this.checkSize(0);
        this.publish(1, 12.34, 0);
        this.process();
        Iterator it = this.indexedOrders.getEventsList().iterator();
        this.indexedOrders.close();
        this.publish(2, 56.78, 0);
        this.process();
        this.checkOrder((Order)it.next(), 1, 12.34);
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSnapshot() {
        this.checkSize(0);
        this.publish(1, 12.34, 4);
        this.process();
        this.checkChanged(false);
        this.checkSize(0);
        this.publish(0, 34.12, 8);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 0, 34.12);
        this.check(1, 1, 12.34);
    }

    @Test
    public void testTx() {
        this.checkSize(0);
        this.publish(0, 12.34, 12);
        this.process();
        this.checkChanged(true);
        this.checkSize(1);
        this.check(0, 0, 12.34);
        this.publish(0, 34.12, 1);
        this.process();
        this.checkChanged(false);
        this.checkSize(1);
        this.check(0, 0, 12.34);
        this.publish(1, 56.78, 0);
        this.process();
        this.checkChanged(true);
        this.checkSize(2);
        this.check(0, 0, 34.12);
        this.check(1, 1, 56.78);
    }

    @Test
    public void testSnapshotClean() {
        this.checkSize(0);
        this.publish(2, 12.34, 4);
        this.publish(1, 23.45, 0);
        this.publish(0, 34.56, 8);
        this.process();
        this.checkChanged(true);
        this.checkSize(3);
        this.check(0, 0, 34.56);
        this.check(1, 1, 23.45);
        this.check(2, 2, 12.34);
        this.publish(0, 0.0, 14);
        this.process();
        this.checkChanged(true);
        this.checkSize(0);
    }

    @Test
    public void testGrow() {
        int i;
        int n = 100;
        for (i = 0; i < n; ++i) {
            int index = n - i - 1;
            this.publish(index, (double)index * 100.0, i == 0 ? 4 : (i == n - 1 ? 8 : 0));
        }
        this.process();
        this.checkChanged(true);
        this.checkSize(n);
        for (i = 0; i < n; ++i) {
            this.check(i, i, (double)i * 100.0);
        }
    }

    private void publish(int index, double price, int eventFlags) {
        Order order = new Order(SYMBOL);
        order.setIndex((long)index);
        order.setPrice(price);
        order.setEventFlags(eventFlags);
        order.setOrderSide(Side.BUY);
        this.publisher.publishEvents(Arrays.asList(order));
    }

    private void checkChanged(boolean expected) {
        Assert.assertEquals((Object)expected, (Object)this.changed);
        this.changed = false;
    }

    private void checkSize(int size) {
        Assert.assertEquals((String)"size", (long)size, (long)this.indexedOrders.getEventsList().size());
        Assert.assertEquals((String)"isEmpty", (Object)(size == 0 ? 1 : 0), (Object)this.indexedOrders.getEventsList().isEmpty());
    }

    private void check(int i, int index, double price) {
        Order order = (Order)this.indexedOrders.getEventsList().get(i);
        this.checkOrder(order, index, price);
    }

    private void checkOrder(Order order, int index, double price) {
        Assert.assertEquals((String)"symbol", (Object)SYMBOL, (Object)order.getEventSymbol());
        Assert.assertEquals((String)"index", (long)index, (long)order.getIndex());
        Assert.assertEquals((String)"price", (double)price, (double)order.getPrice(), (double)0.0);
    }

    private void process() {
        for (Runnable runnable : this.executionQueue) {
            runnable.run();
        }
        this.executionQueue.clear();
    }
}

