/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRMarketMaker
extends MDREvent {
    private int exchange;
    private int id;
    private int bidPrice;
    private int bidSize;
    private int askPrice;
    private int askSize;
    public boolean pendingWrite;

    public long getKey() {
        return (long)this.exchange << 32 | (long)this.id & 0xFFFFFFFFL;
    }

    public void setKey(long key) {
        this.exchange = (int)(key >>> 32);
        this.id = (int)key;
    }

    @Override
    public void init(long startTime) {
        this.eventTime = startTime / 1000L * 1000L;
        this.exchange = 0;
        this.id = 0;
        this.bidPrice = 0;
        this.bidSize = 0;
        this.askPrice = 0;
        this.askSize = 0;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRMarketMaker event = (MDRMarketMaker)newEvent;
        return 0 == (this.exchange - event.exchange | this.id - event.id | this.bidPrice - event.bidPrice | this.bidSize - event.bidSize | this.askPrice - event.askPrice | this.askSize - event.askSize);
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        MDRMarketMaker event = (MDRMarketMaker)newEvent;
        return this.exchange == event.exchange && this.id == event.id;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        MarketMakerMapping mapping = (MarketMakerMapping)cursor.getRecord().getMapping(MarketMakerMapping.class);
        mapping.setMMExchange(cursor, (char)this.exchange);
        mapping.setMMID(cursor, this.id);
        mapping.setMMBidPriceDecimal(cursor, this.bidPrice);
        mapping.setMMBidSize(cursor, this.bidSize);
        mapping.setMMAskPriceDecimal(cursor, this.askPrice);
        mapping.setMMAskSize(cursor, this.askSize);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        MarketMakerMapping mapping = (MarketMakerMapping)cursor.getRecord().getMapping(MarketMakerMapping.class);
        this.exchange = mapping.getMMExchange(cursor);
        this.id = mapping.getMMID(cursor);
        this.bidPrice = mapping.getMMBidPriceDecimal(cursor);
        this.bidSize = mapping.getMMBidSize(cursor);
        this.askPrice = mapping.getMMAskPriceDecimal(cursor);
        this.askSize = mapping.getMMAskSize(cursor);
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRMarketMaker event = (MDRMarketMaker)source;
        this.eventTime = event.eventTime;
        this.exchange = event.exchange;
        this.id = event.id;
        this.bidPrice = event.bidPrice;
        this.bidSize = event.bidSize;
        this.askPrice = event.askPrice;
        this.askSize = event.askSize;
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        int flag = in.readUnsignedByte();
        this.exchange += MDRMarketMaker.readDeltaFlagged(in, flag, 128);
        this.id += MDRMarketMaker.readDeltaFlagged(in, flag, 64);
        this.bidPrice += MDRMarketMaker.readDeltaFlagged(in, flag, 32);
        this.bidSize += MDRMarketMaker.readDeltaFlagged(in, flag, 16);
        this.askPrice += MDRMarketMaker.readDeltaFlagged(in, flag, 8);
        this.askSize += MDRMarketMaker.readDeltaFlagged(in, flag, 4);
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRMarketMaker event = (MDRMarketMaker)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        int flagPosition = out.getPosition();
        out.writeByte(0);
        int flag = MDRMarketMaker.writeDeltaFlagged(out, this.exchange, event.exchange, 128) | MDRMarketMaker.writeDeltaFlagged(out, this.id, event.id, 64) | MDRMarketMaker.writeDeltaFlagged(out, this.bidPrice, event.bidPrice, 32) | MDRMarketMaker.writeDeltaFlagged(out, this.bidSize, event.bidSize, 16) | MDRMarketMaker.writeDeltaFlagged(out, this.askPrice, event.askPrice, 8) | MDRMarketMaker.writeDeltaFlagged(out, this.askSize, event.askSize, 4);
        out.getBuffer()[flagPosition] = (byte)flag;
        this.setFrom(event);
    }

    @Override
    public Object getExtractorConflationKey(String symbol) {
        return new ConflationKey(symbol, this.getKey());
    }

    private static class ConflationKey {
        private final String symbol;
        private final long key;

        private ConflationKey(String symbol, long key) {
            this.symbol = symbol;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConflationKey)) {
                return false;
            }
            ConflationKey that = (ConflationKey)o;
            return this.key == that.key && this.symbol.equals(that.symbol);
        }

        public int hashCode() {
            return 31 * this.symbol.hashCode() + (int)(this.key ^ this.key >>> 32);
        }
    }
}

