/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.impl.ProfileMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRProfile
extends MDREvent {
    private int beta;
    private int eps;
    private int divFreq;
    private int exDivAmount;
    private int exDivDate;
    private int _52HighPrice;
    private int _52LowPrice;
    private long shares;
    private int isIndex;
    private String description;

    private void setDescription(String s) {
        if (!(s != null ? s.equals(this.description) : this.description == null)) {
            this.description = s;
        }
    }

    @Override
    public void init(long startTime) {
        this.eventTime = startTime / 1000L * 1000L;
        this.beta = 0;
        this.eps = 0;
        this.divFreq = 0;
        this.exDivAmount = 0;
        this.exDivDate = 0;
        this._52HighPrice = 0;
        this._52LowPrice = 0;
        this.shares = 0L;
        this.isIndex = 0;
        this.description = null;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRProfile event = (MDRProfile)newEvent;
        return 0L == ((long)(this.beta - event.beta | this.eps - event.eps | this.divFreq - event.divFreq | this.exDivAmount - event.exDivAmount | this.exDivDate - event.exDivDate | this._52HighPrice - event._52HighPrice | this._52LowPrice - event._52LowPrice) | this.shares - event.shares | (long)(this.isIndex - event.isIndex)) && (this.description == null ? event.description == null : this.description.equals(event.description));
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        return true;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        ProfileMapping mapping = (ProfileMapping)cursor.getRecord().getMapping(ProfileMapping.class);
        mapping.setBetaDecimal(cursor, this.beta);
        mapping.setEpsDecimal(cursor, this.eps);
        mapping.setDivFreq(cursor, this.divFreq);
        mapping.setExdDivAmountDecimal(cursor, this.exDivAmount);
        mapping.setExdDivDate(cursor, this.exDivDate);
        mapping.set52HighPriceDecimal(cursor, this._52HighPrice);
        mapping.set52LowPriceDecimal(cursor, this._52LowPrice);
        mapping.setShares(cursor, this.shares);
        mapping.setDescription(cursor, this.description);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        ProfileMapping mapping = (ProfileMapping)cursor.getRecord().getMapping(ProfileMapping.class);
        this.beta = mapping.getBetaDecimal(cursor);
        this.eps = mapping.getEpsDecimal(cursor);
        this.divFreq = mapping.getDivFreq(cursor);
        this.exDivAmount = mapping.getExdDivAmountDecimal(cursor);
        this.exDivDate = mapping.getExdDivDate(cursor);
        this._52HighPrice = mapping.get52HighPriceDecimal(cursor);
        this._52LowPrice = mapping.get52LowPriceDecimal(cursor);
        this.shares = mapping.getShares(cursor);
        if (this.shares < 0L) {
            this.shares += 4294967296000L;
        }
        this.shares = this.shares / 1000L * 1000L;
        this.setDescription(mapping.getDescription(cursor));
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRProfile event = (MDRProfile)source;
        this.eventTime = event.eventTime;
        this.beta = event.beta;
        this.eps = event.eps;
        this.divFreq = event.divFreq;
        this.exDivAmount = event.exDivAmount;
        this.exDivDate = event.exDivDate;
        this._52HighPrice = event._52HighPrice;
        this._52LowPrice = event._52LowPrice;
        this.shares = event.shares;
        this.isIndex = event.isIndex;
        this.setDescription(event.description);
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        this.beta += in.readCompactInt();
        this.eps += in.readCompactInt();
        this.divFreq += in.readCompactInt();
        this.exDivAmount += in.readCompactInt();
        this.exDivDate += in.readCompactInt();
        this._52HighPrice += in.readCompactInt();
        this._52LowPrice += in.readCompactInt();
        this.shares += in.readCompactLong() * 1000L;
        this.isIndex += in.readCompactInt();
        this.setDescription(in.readUTFString());
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRProfile event = (MDRProfile)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        out.writeCompactInt(event.beta - this.beta);
        out.writeCompactInt(event.eps - this.eps);
        out.writeCompactInt(event.divFreq - this.divFreq);
        out.writeCompactInt(event.exDivAmount - this.exDivAmount);
        out.writeCompactInt(event.exDivDate - this.exDivDate);
        out.writeCompactInt(event._52HighPrice - this._52HighPrice);
        out.writeCompactInt(event._52LowPrice - this._52LowPrice);
        out.writeCompactLong(event.shares / 1000L - this.shares / 1000L);
        out.writeCompactInt(event.isIndex - this.isIndex);
        out.writeUTFString(event.description);
        this.setFrom(event);
    }
}

