/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRTradeHistory
extends MDREvent {
    private int time;
    private int sequence;
    private int exchange;
    private int price;
    private int size;
    private int bid;
    private int ask;

    @Override
    public void init(long startTime) {
        long seconds = startTime / 1000L;
        this.eventTime = seconds * 1000L;
        this.time = (int)seconds;
        this.sequence = 0;
        this.exchange = 0;
        this.price = 0;
        this.size = 0;
        this.bid = 0;
        this.ask = 0;
    }

    public char getExchange() {
        return (char)this.exchange;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRTradeHistory event = (MDRTradeHistory)newEvent;
        return 0 == (this.time - event.time | this.sequence - event.sequence | this.exchange - event.exchange | this.price - event.price | this.size - event.size | this.bid - event.bid | this.ask - event.ask);
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        MDRTradeHistory event = (MDRTradeHistory)newEvent;
        return this.time == event.time && this.sequence == event.sequence;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        if (cursor.getRecord().getMapping(TradeHistoryMapping.class) != null) {
            this.getIntoTradeHistory(cursor, (TradeHistoryMapping)cursor.getRecord().getMapping(TradeHistoryMapping.class));
        } else {
            this.getIntoTimeAndSale(cursor, (TimeAndSaleMapping)cursor.getRecord().getMapping(TimeAndSaleMapping.class));
        }
    }

    private void getIntoTradeHistory(RecordCursor cursor, TradeHistoryMapping mapping) {
        mapping.setTimeSeconds(cursor, this.time);
        mapping.setSequence(cursor, this.sequence);
        mapping.setExchange(cursor, (char)this.exchange);
        mapping.setPriceDecimal(cursor, this.price);
        mapping.setSize(cursor, this.size);
        mapping.setBidDecimal(cursor, this.bid);
        mapping.setAskDecimal(cursor, this.ask);
    }

    private void getIntoTimeAndSale(RecordCursor cursor, TimeAndSaleMapping mapping) {
        mapping.setTimeSeconds(cursor, this.time);
        mapping.setSequence(cursor, this.sequence);
        mapping.setExchange(cursor, (char)this.exchange);
        mapping.setPriceDecimal(cursor, this.price);
        mapping.setSize(cursor, this.size);
        mapping.setBidPriceDecimal(cursor, this.bid);
        mapping.setAskPriceDecimal(cursor, this.ask);
        mapping.setFlags(cursor, 4);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        DataRecord record = cursor.getRecord();
        if (record.getMapping(TradeHistoryMapping.class) != null) {
            this.setFromTradeHistory(cursor, (TradeHistoryMapping)cursor.getRecord().getMapping(TradeHistoryMapping.class));
        } else {
            this.setFromTimeAndSale(cursor, (TimeAndSaleMapping)cursor.getRecord().getMapping(TimeAndSaleMapping.class));
        }
    }

    private void setFromTradeHistory(RecordCursor cursor, TradeHistoryMapping mapping) {
        this.time = mapping.getTimeSeconds(cursor);
        this.sequence = mapping.getSequence(cursor);
        this.exchange = mapping.getExchange(cursor);
        this.price = mapping.getPriceDecimal(cursor);
        this.size = mapping.getSize(cursor);
        this.bid = mapping.getBidDecimal(cursor);
        this.ask = mapping.getAskDecimal(cursor);
    }

    private void setFromTimeAndSale(RecordCursor cursor, TimeAndSaleMapping mapping) {
        this.time = mapping.getTimeSeconds(cursor);
        this.sequence = mapping.getSequence(cursor);
        this.exchange = mapping.getExchange(cursor);
        this.price = mapping.getPriceDecimal(cursor);
        this.size = mapping.getSize(cursor);
        this.bid = mapping.getBidPriceDecimal(cursor);
        this.ask = mapping.getAskPriceDecimal(cursor);
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRTradeHistory event = (MDRTradeHistory)source;
        this.eventTime = event.eventTime;
        this.time = event.time;
        this.sequence = event.sequence;
        this.exchange = event.exchange;
        this.price = event.price;
        this.size = event.size;
        this.bid = event.bid;
        this.ask = event.ask;
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        int flag = in.readUnsignedByte();
        this.time += MDRTradeHistory.readDeltaFlagged(in, flag, 128);
        this.sequence += MDRTradeHistory.readDeltaFlagged(in, flag, 64);
        this.exchange += MDRTradeHistory.readDeltaFlagged(in, flag, 32);
        this.price += MDRTradeHistory.readDeltaFlagged(in, flag, 16);
        this.size += MDRTradeHistory.readDeltaFlagged(in, flag, 8);
        this.bid += MDRTradeHistory.readDeltaFlagged(in, flag, 4);
        this.ask += MDRTradeHistory.readDeltaFlagged(in, flag, 2);
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRTradeHistory event = (MDRTradeHistory)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        int flagPosition = out.getPosition();
        out.writeByte(0);
        int flag = MDRTradeHistory.writeDeltaFlagged(out, this.time, event.time, 128) | MDRTradeHistory.writeDeltaFlagged(out, this.sequence, event.sequence, 64) | MDRTradeHistory.writeDeltaFlagged(out, this.exchange, event.exchange, 32) | MDRTradeHistory.writeDeltaFlagged(out, this.price, event.price, 16) | MDRTradeHistory.writeDeltaFlagged(out, this.size, event.size, 8) | MDRTradeHistory.writeDeltaFlagged(out, this.bid, event.bid, 4) | MDRTradeHistory.writeDeltaFlagged(out, this.ask, event.ask, 2);
        out.getBuffer()[flagPosition] = (byte)flag;
        this.setFrom(event);
    }
}

