/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import java.io.IOException;
import java.util.Comparator;

public class Key {
    public static final Comparator<Key> COMPARATOR = new Comparator<Key>(){

        @Override
        public int compare(Key key1, Key key2) {
            int i = key1.getSymbol().compareTo(key2.getSymbol());
            if (i == 0) {
                i = key1.getExchange() - key2.getExchange();
            }
            if (i == 0) {
                i = key1.getType() - key2.getType();
            }
            return i;
        }
    };
    protected String symbol;
    protected char exchange;
    protected char type;
    public transient int subscriptionCount;

    public Key() {
    }

    public Key(String symbol, char exchange, char type) {
        this.symbol = symbol;
        this.exchange = exchange;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public char getExchange() {
        return this.exchange;
    }

    public void setExchange(char exchange) {
        this.exchange = exchange;
    }

    public char getType() {
        return this.type;
    }

    public void setType(char type) {
        this.type = type;
    }

    public void readKey(ByteArrayInput in) throws IOException {
        this.symbol = in.readUTFString();
        this.exchange = (char)in.readUTFChar();
        this.type = (char)in.readUTFChar();
    }

    public void writeKey(ByteArrayOutput out) throws IOException {
        out.writeUTFString(this.symbol);
        out.writeUTFChar((int)this.exchange);
        out.writeUTFChar((int)this.type);
    }

    public int hashCode() {
        return (this.symbol.hashCode() * 31 + this.exchange) * 31 + this.type;
    }

    public boolean equals(Object obj) {
        Key key = (Key)obj;
        return this.symbol.equals(key.symbol) && this.exchange == key.exchange && this.type == key.type;
    }

    public String toString() {
        return this.symbol + ':' + (this.exchange == '\u0000' ? (char)'-' : (char)this.exchange) + (this.type == '\u0000' ? (char)'-' : (char)this.type);
    }
}

