/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.dxfeed.ondemand.impl.Key;
import com.dxfeed.ondemand.impl.MarketDataToken;
import com.dxfeed.ondemand.impl.ReplayUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReplayRequest {
    private MarketDataToken token;
    private long allowedDelay;
    private long requestTime;
    private final ByteArrayOutput requestKeysOutput = new ByteArrayOutput();
    private ByteArrayInput requestKeysInput;

    public MarketDataToken getToken() {
        return this.token;
    }

    public void setToken(MarketDataToken token) {
        this.token = token;
    }

    public long getAllowedDelay() {
        return this.allowedDelay;
    }

    public void setAllowedDelay(long allowedDelay) {
        this.allowedDelay = allowedDelay;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void addRequestKeys(Collection<Key> keys) throws IOException {
        for (Key key : keys) {
            key.writeKey(this.requestKeysOutput);
        }
    }

    public ByteArrayInput getRequestKeysInput() {
        return this.requestKeysInput;
    }

    public ByteArrayOutput write() throws IOException {
        LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
        elements.put("contract", this.token.getTokenContract());
        elements.put("user", this.token.getTokenUser());
        elements.put("expiration", Long.toString(this.token.getTokenExpiration()));
        elements.put("digest", this.token.getTokenDigest());
        elements.put("delay", Long.toString(this.allowedDelay));
        elements.put("time", Long.toString(this.requestTime));
        ReplayUtil.addGZippedElement(elements, "keys", this.requestKeysOutput);
        return ReplayUtil.writeElements(elements);
    }

    public void read(ByteArrayInput in) throws IOException {
        Map<String, byte[]> elements = ReplayUtil.readElements(in);
        this.token = new MarketDataToken(new String(elements.get("contract"), StandardCharsets.UTF_8), new String(elements.get("user"), StandardCharsets.UTF_8), Long.parseLong(new String(elements.get("expiration"), StandardCharsets.UTF_8)), elements.get("digest"));
        this.allowedDelay = elements.containsKey("delay") ? Long.parseLong(new String(elements.get("delay"), StandardCharsets.UTF_8)) : 0L;
        this.requestTime = Long.parseLong(new String(elements.get("time"), StandardCharsets.UTF_8));
        this.requestKeysInput = ReplayUtil.getGZippedElement(elements, "keys");
    }
}

