/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.StreamInput;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.SynchronizedIndexedSet;
import com.devexperts.util.TimeFormat;
import com.dxfeed.ondemand.impl.Block;
import com.dxfeed.ondemand.impl.CacheConfig;
import com.dxfeed.ondemand.impl.Current;
import com.dxfeed.ondemand.impl.CurrentSegment;
import com.dxfeed.ondemand.impl.Key;
import com.dxfeed.ondemand.impl.Log;
import com.dxfeed.ondemand.impl.Segment;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;

class Cache
implements Runnable {
    private static final String FILE_CACHE_NAME = "mdrcache";
    private static final String FILE_CACHE_NAME_SUFFIX = ".tmp";
    private static final long FILE_HEADER = 5567665488686966885L;
    private static final long MIN_CACHE_INTERVAL = 60000L;
    private static final double CACHE_LIMIT_FACTOR = 0.8;
    private static final AtomicLongFieldUpdater<Cache> USAGE_UPDATER = AtomicLongFieldUpdater.newUpdater(Cache.class, "usage");
    private static final IndexedSet<CacheConfig, Cache> INSTANCES = SynchronizedIndexedSet.create(Cache::getConfig);
    private final CacheConfig config;
    private int acquireCounter;
    private Thread cacheWriter;
    private volatile long version;
    private volatile long usage;
    private long writtenUsage;
    private long cacheSize;
    private final IndexedSet<Segment, Segment> segments = new IndexedSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache acquireInstance(CacheConfig config) {
        Cache cache;
        config = config.clone();
        IndexedSet<CacheConfig, Cache> indexedSet = INSTANCES;
        synchronized (indexedSet) {
            cache = (Cache)INSTANCES.getByKey((Object)config);
            if (cache == null) {
                cache = new Cache(config);
                INSTANCES.add((Object)cache);
            }
        }
        if (cache.acquire()) {
            cache.startFileCacheWriter();
        }
        return cache;
    }

    Cache(CacheConfig config) {
        this.config = config;
    }

    public CacheConfig getConfig() {
        return this.config;
    }

    private synchronized boolean acquire() {
        return this.acquireCounter++ == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread release() {
        Thread cacheWriter;
        Cache cache = this;
        synchronized (cache) {
            if (--this.acquireCounter > 0) {
                return null;
            }
            cacheWriter = this.cacheWriter;
            this.triggerFileCacheWriting();
            this.cacheWriter = null;
        }
        INSTANCES.remove((Object)this);
        return cacheWriter;
    }

    private void startFileCacheWriter() {
        try {
            this.readCache();
        }
        catch (Throwable t) {
            Log.log.error("Unexpected error", t);
        }
        try {
            this.cacheWriter = new Thread((Runnable)this, "MarketDataReplay-CacheWriter");
            this.cacheWriter.setDaemon(true);
            this.cacheWriter.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized void triggerFileCacheWriting() {
        if (this.cacheWriter != null) {
            LockSupport.unpark(this.cacheWriter);
        }
    }

    public long nextUsage() {
        long upd;
        long cur;
        while (!USAGE_UPDATER.compareAndSet(this, cur = this.usage, upd = cur + 1L)) {
        }
        return upd;
    }

    public synchronized void checkRequestKeys(Current current, long requestTime, IndexedSet<Key, Key> presentKeys, IndexedSet<Key, Key> expiredKeys) {
        long millis = System.currentTimeMillis();
        for (Segment segment : this.segments) {
            if (!current.subscription.containsKey((Object)segment.block) || !segment.block.containsTime(requestTime)) continue;
            if (Math.abs(segment.downloadTime - millis) < this.config.timeToLive) {
                presentKeys.put((Object)segment.block);
                continue;
            }
            expiredKeys.put((Object)segment.block);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public synchronized void addData(Collection<Segment> newSegments) {
        if (newSegments.isEmpty()) {
            return;
        }
        long newSize = 0L;
        HashMap<Key, ArrayList<Segment>> map = new HashMap<Key, ArrayList<Segment>>();
        long usage = this.nextUsage();
        for (Segment segment : newSegments) {
            newSize += (long)segment.size();
            segment.usage = usage;
            ArrayList<Segment> segs = map.get(segment.block);
            if (segs == null) {
                segs = new ArrayList();
                map.put(segment.block, segs);
            }
            segs.add(segment);
        }
        int multiples = this.filterReceivedIntersections(map);
        long replacedSize = 0L;
        int replacedSegments = 0;
        long identicalSize = 0L;
        int identicalSegments = 0;
        RecordBuffer buffer = new RecordBuffer();
        Iterator it = this.segments.iterator();
        while (it.hasNext()) {
            Segment segment = (Segment)it.next();
            ArrayList<Segment> segs = map.get(segment.block);
            if (segs == null) continue;
            boolean replace = false;
            for (Segment seg : segs) {
                if (!segment.intersects(seg)) continue;
                if (segment.block.isIdentical(seg.block)) {
                    identicalSize += (long)segment.size();
                    ++identicalSegments;
                    if (Math.abs(segment.downloadTime - seg.downloadTime) < this.config.timeToLive) {
                        Log.log.warn("Identical segment " + seg + " at " + TimeFormat.DEFAULT.withMillis().format(seg.downloadTime) + " replaces " + segment + " at " + TimeFormat.DEFAULT.withMillis().format(segment.downloadTime));
                    }
                } else {
                    Log.log.warn("Segment intersection: " + seg + " replaces " + segment);
                }
                replace = true;
            }
            if (!replace) continue;
            replacedSize += (long)segment.size();
            ++replacedSegments;
            it.remove();
            this.cacheSize -= (long)segment.size();
        }
        for (ArrayList<Segment> segs : map.values()) {
            for (Segment seg : segs) {
                this.segments.put((Object)seg);
                this.cacheSize += (long)seg.size();
            }
        }
        Log.log.info("addData: " + Log.mb(newSize) + " in " + newSegments.size() + " segments (" + multiples + " multiples), replaced " + Log.mb(replacedSize) + " in " + replacedSegments + " segments, identical " + Log.mb(identicalSize) + " in " + identicalSegments + " segments");
        ++this.version;
        this.triggerFileCacheWriting();
    }

    private int filterReceivedIntersections(HashMap<Key, ArrayList<Segment>> map) {
        int multiples = 0;
        for (ArrayList<Segment> segs : map.values()) {
            if (segs.size() <= 1) continue;
            ++multiples;
            Collections.sort(segs, new Comparator<Segment>(){

                @Override
                public int compare(Segment segment1, Segment segment2) {
                    long d2;
                    Block b1 = segment1.block;
                    Block b2 = segment2.block;
                    if (b1.getEndTime() != b2.getEndTime()) {
                        return b1.getEndTime() > b2.getEndTime() ? -1 : 1;
                    }
                    long d1 = b1.getEndTime() - b1.getStartTime();
                    return d1 > (d2 = b2.getEndTime() - b2.getStartTime()) ? -1 : (d1 < d2 ? 1 : Block.COMPARATOR.compare(b1, b2));
                }
            });
            for (int i = 0; i < segs.size(); ++i) {
                int j = segs.size();
                while (--j > i) {
                    if (!segs.get(i).intersects(segs.get(j))) continue;
                    Log.log.warn("Received intersection: " + segs.get(i) + " replaces " + segs.get(j));
                    segs.remove(j);
                }
            }
        }
        return multiples;
    }

    public void rebuildCurrentSegmentsIfNeeded(Current current) {
        if (this.version > current.version) {
            this.rebuildCurrentSegments(current);
        }
    }

    public synchronized void rebuildCurrentSegments(Current current) {
        long usage = this.nextUsage();
        current.resetInterval();
        for (Segment segment : this.segments) {
            if (!this.isCurrentSegment(segment, current, current.time)) continue;
            segment.usage = usage;
            current.size += (long)segment.size();
            current.startTime = Math.max(current.startTime, segment.block.getStartTime());
            current.endTime = Math.min(current.endTime, segment.block.getEndTime());
            CurrentSegment old = (CurrentSegment)current.segments.getByKey((Object)segment.block);
            if (old != null) {
                current.size -= (long)old.segment.size();
                old.replaceSegment(segment, current.time, usage);
                continue;
            }
            current.segments.add((Object)new CurrentSegment(segment));
        }
        Iterator it = current.segments.iterator();
        while (it.hasNext()) {
            CurrentSegment cur = (CurrentSegment)it.next();
            if (this.isCurrentSegment(cur.segment, current, current.time)) continue;
            current.size -= (long)cur.segment.size();
            cur.release();
            it.remove();
        }
        if (current.segments.isEmpty()) {
            current.startTime = current.time / 60000L * 60000L;
            current.endTime = current.startTime + 60000L;
        }
        if (current.size > 0L || !current.segments.isEmpty()) {
            Log.log.info("rebuildCurrent at " + TimeFormat.DEFAULT.withMillis().format(current.time) + ": " + Log.mb(current.size) + " in " + current.segments.size() + " segments from " + TimeFormat.DEFAULT.withMillis().format(current.startTime) + " to " + TimeFormat.DEFAULT.withMillis().format(current.endTime) + ", replay speed " + current.replaySpeed);
        }
        current.version = this.version;
        this.checkCacheLimit(current);
    }

    public synchronized void releaseSegments(Current current) {
        for (CurrentSegment currentSegment : current.segments) {
            currentSegment.release();
        }
        current.segments.clear();
        current.size = 0L;
        current.resetInterval();
    }

    public synchronized double getAvailableData(Current current, long time) {
        int available;
        if (current.subscription.isEmpty()) {
            return 1.0;
        }
        this.rebuildCurrentSegmentsIfNeeded(current);
        if (current.isCurrentInterval(time)) {
            available = current.segments.size();
        } else {
            available = 0;
            for (Segment segment : this.segments) {
                if (!this.isCurrentSegment(segment, current, time)) continue;
                ++available;
            }
        }
        return (double)available / (double)current.subscription.size();
    }

    private boolean isCurrentSegment(Segment segment, Current current, long time) {
        return segment.block.containsTime(time) && current.subscription.containsKey((Object)segment.block);
    }

    private void checkCacheLimit(Current current) {
        long oldCacheSize = this.cacheSize;
        int oldSegments = this.segments.size();
        if (this.cacheSize > this.config.cacheLimit && (double)current.size < (double)this.cacheSize * 0.8) {
            Segment[] sorted = (Segment[])this.segments.toArray((Object[])new Segment[this.segments.size()]);
            Arrays.sort(sorted, Segment.USAGE_COMPARATOR);
            for (Segment segment : sorted) {
                if (segment.currentCounter != 0) continue;
                this.segments.remove((Object)segment);
                this.cacheSize -= (long)segment.size();
                if ((double)this.cacheSize <= (double)this.config.cacheLimit * 0.8) break;
            }
        }
        if (this.cacheSize > 0L || current.size > 0L || oldCacheSize > 0L || !this.segments.isEmpty() || !current.segments.isEmpty() || oldSegments > 0) {
            Log.log.info("Cache: limit " + Log.mb(this.config.cacheLimit) + ", used " + Log.mb(this.cacheSize) + " in " + this.segments.size() + " segments, current " + Log.mb(current.size) + " in " + current.segments.size() + " segments, removed " + Log.mb(oldCacheSize - this.cacheSize) + " in " + (oldSegments - this.segments.size()) + " segments");
        }
    }

    private synchronized boolean needsWriteCache() {
        return this.writtenUsage != this.usage;
    }

    private synchronized void updateWrittenUsage(long writeUsage) {
        this.writtenUsage = writeUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeCache() {
        Segment[] sorted;
        long writeUsage;
        long millis = System.currentTimeMillis();
        Cache cache = this;
        synchronized (cache) {
            writeUsage = this.usage;
            sorted = (Segment[])this.segments.toArray((Object[])new Segment[this.segments.size()]);
        }
        Arrays.sort(sorted, Segment.USAGE_COMPARATOR);
        FileOutputStream fos = null;
        try {
            File tmp = File.createTempFile(FILE_CACHE_NAME, FILE_CACHE_NAME_SUFFIX, this.getCacheFileParent());
            if (tmp.getParentFile() != null) {
                tmp.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(tmp);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1000000);
            ByteArrayOutput bao = new ByteArrayOutput(100000);
            long writeSize = 0L;
            long size = 0L;
            int count = 0;
            bao.writeLong(5567665488686966885L);
            bao.writeCompactLong(writeUsage);
            bao.writeCompactLong(millis);
            int i = sorted.length;
            while (--i >= 0) {
                Segment segment = sorted[i];
                size += (long)segment.size();
                ++count;
                segment.block.writeBlock(bao);
                bao.writeCompactLong(segment.downloadTime);
                bao.writeCompactLong(segment.usage);
                bos.write(bao.getBuffer(), 0, bao.getPosition());
                bao.setPosition(0);
                if ((writeSize += (long)bao.getPosition()) <= this.config.fileCacheLimit) continue;
                break;
            }
            bos.write(bao.getBuffer(), 0, bao.getPosition());
            writeSize += (long)bao.getPosition();
            bos.close();
            File file = new File(this.getCacheFileParent(), FILE_CACHE_NAME);
            file.delete();
            tmp.renameTo(file);
            Log.log.info("writeCache: written " + Log.mb(writeSize) + " as " + Log.mb(size) + " in " + count + " segments out of " + Log.mb(this.cacheSize) + " in " + this.segments.size() + " segments at " + TimeFormat.DEFAULT.withMillis().format(millis) + " in " + (double)(System.currentTimeMillis() - millis) / 1000.0 + " seconds");
        }
        catch (Throwable t) {
            Log.log.error("Unexpected error writing cache", t);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException tmp) {}
            }
        }
        return writeUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCache() {
        if (!this.segments.isEmpty()) {
            return;
        }
        File f = new File(this.getCacheFileParent(), FILE_CACHE_NAME);
        if (!f.isFile() || f.length() < 16L) {
            return;
        }
        long millis = System.currentTimeMillis();
        FileInputStream fis = null;
        try {
            long size;
            FileInputStream fileInput = fis = new FileInputStream(f);
            long[] readSize = new long[1];
            StreamInput in = new StreamInput((InputStream)fis);
            if (in.readLong() != 5567665488686966885L) {
                throw new IOException("Unknown file header");
            }
            long readUsage = in.readCompactLong();
            long readMillis = in.readCompactLong();
            ArrayList<Segment> newSegments = new ArrayList<Segment>();
            try {
                Segment segment;
                for (size = 0L; size < this.config.cacheLimit; size += (long)segment.size()) {
                    Block block = new Block();
                    block.readBlock((DataInput)in);
                    block.decompress();
                    segment = new Segment(block, in.readCompactLong());
                    segment.usage = in.readCompactLong();
                    newSegments.add(segment);
                }
            }
            catch (EOFException block) {
            }
            catch (Throwable t) {
                Log.log.error("Unexpected error reading cache at " + (readSize[0] - (long)in.available()), t);
            }
            Log.log.info("readCache: read " + Log.mb(readSize[0]) + " ouf of " + Log.mb(f.length()) + ", " + Log.mb(size) + " in " + newSegments.size() + " segments at " + TimeFormat.DEFAULT.withMillis().format(readMillis) + " in " + (double)(System.currentTimeMillis() - millis) / 1000.0 + " seconds");
            Cache cache = this;
            synchronized (cache) {
                for (Segment segment : newSegments) {
                    this.segments.put((Object)segment);
                    this.cacheSize += (long)segment.size();
                }
                this.writtenUsage = this.usage = Math.max(this.usage, readUsage);
            }
        }
        catch (Throwable t) {
            Log.log.error("Unexpected error reading cache", t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException fileInput) {}
            }
        }
    }

    private File getCacheFileParent() {
        String fileCachePath = this.config.fileCachePath;
        return fileCachePath.length() == 0 ? null : new File(fileCachePath);
    }

    @Override
    public void run() {
        do {
            try {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(this.config.fileCacheDumpPeriod));
                if (!this.needsWriteCache()) continue;
                this.updateWrittenUsage(this.writeCache());
            }
            catch (Throwable t) {
                Log.log.error("Unexpected error", t);
            }
        } while (Thread.currentThread() == this.cacheWriter);
    }
}

