/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl;

import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.util.TimePeriod;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.impl.DXEndpointImpl;
import com.dxfeed.api.impl.DXFeedImpl;
import com.dxfeed.ondemand.OnDemandService;
import com.dxfeed.ondemand.impl.connector.OnDemandConnector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;

public final class OnDemandServiceImpl
extends OnDemandService
implements NotificationListener {
    private static final Logging log = Logging.getLogging(OnDemandServiceImpl.class);
    private DXEndpointImpl dxEndpoint;
    private DXFeedImpl dxFeed;
    private Object lock;
    private volatile boolean replay;
    private volatile boolean clear;
    private volatile OnDemandConnector onDemandConnector;
    private volatile long time;
    private volatile double speed;
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final PropertyChange change = new PropertyChange();

    protected void initImpl(DXEndpoint endpoint) {
        if (!(endpoint instanceof DXEndpointImpl)) {
            throw new IllegalArgumentException("Unsupported endpoint class: " + endpoint.getClass().getName());
        }
        if (this.dxEndpoint != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.dxEndpoint = (DXEndpointImpl)endpoint;
        this.dxFeed = (DXFeedImpl)this.dxEndpoint.getFeed();
        this.lock = this.dxEndpoint.getLock();
        this.dxEndpoint.getQDEndpoint().addPlugin(new QDEndpoint.Plugin(){

            public boolean skipConnectorOnStart(MessageConnector connector) {
                return OnDemandServiceImpl.this.replay && !(connector instanceof OnDemandConnector);
            }

            public void connectorsChanged(List<MessageConnector> connectors) {
                OnDemandServiceImpl.this.updateConnectors();
            }
        });
        this.updateConnectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConnectors() {
        Object object = this.lock;
        synchronized (object) {
            if (this.replay) {
                this.captureOnDemandConnectorTime();
            }
            OnDemandConnector oldOnDemandConnector = this.onDemandConnector;
            if (this.onDemandConnector != null) {
                try {
                    this.onDemandConnector.removeNotificationListener(this);
                }
                catch (ListenerNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.onDemandConnector = null;
            }
            for (MessageConnector connector : this.dxEndpoint.getQDEndpoint().getConnectors()) {
                if (!(connector instanceof OnDemandConnector)) continue;
                this.onDemandConnector = (OnDemandConnector)connector;
                break;
            }
            if (this.onDemandConnector != null) {
                this.onDemandConnector.addNotificationListener(this, null, null);
                if (this.onDemandConnector != oldOnDemandConnector) {
                    this.onDemandConnector.setTickPeriod(TimePeriod.valueOf((long)Math.max(this.onDemandConnector.getTickPeriod().getTime(), this.dxFeed.getAggregationPeriodMillis())));
                }
            }
            this.configureOnDemandConnectorReplay();
            this.change.schedule();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.captureOnDemandConnectorTime();
        this.change.schedule();
    }

    private void captureOnDemandConnectorTime() {
        Date timeObj;
        OnDemandConnector onDemandConnector = this.onDemandConnector;
        if (onDemandConnector != null && (timeObj = onDemandConnector.getTime()) != null && timeObj.getTime() != 0L) {
            this.time = timeObj.getTime();
        }
    }

    private void configureOnDemandConnectorReplay() {
        if (this.replay) {
            if (this.onDemandConnector == null) {
                this.replay = false;
            } else {
                this.onDemandConnector.setSpeed(this.speed);
                this.onDemandConnector.setTime(new Date(this.time));
            }
        } else if (this.onDemandConnector != null) {
            this.onDemandConnector.setTime(null);
        }
    }

    public DXEndpoint getEndpoint() {
        return this.dxEndpoint;
    }

    public boolean isReplaySupported() {
        return this.onDemandConnector != null;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public boolean isClear() {
        return this.clear;
    }

    public Date getTime() {
        return new Date(this.time);
    }

    public double getSpeed() {
        return this.speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(Date time, double speed) {
        if (time == null) {
            throw new NullPointerException();
        }
        if (speed < 0.0) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.onDemandConnector == null) {
                throw new IllegalStateException("Not connected to (ondemand:<address>)");
            }
            this.dxEndpoint.getQDEndpoint().stopConnectorsAndWaitUninterruptibly();
            this.dxEndpoint.clearImpl();
            this.replay = true;
            this.time = time.getTime();
            this.speed = speed;
            this.configureOnDemandConnectorReplay();
            this.onDemandConnector.startImmediately();
            this.clear = false;
            this.change.schedule();
        }
    }

    public void pause() {
        this.setSpeed(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeed(double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.replay && speed != 0.0) {
                throw new IllegalStateException("Not in replay mode");
            }
            if (speed == this.speed) {
                return;
            }
            this.onDemandConnector.setSpeed(speed);
            this.speed = speed;
            this.change.schedule();
        }
    }

    public void stopAndResume() {
        this.stopImpl(true);
    }

    public void stopAndClear() {
        this.stopImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopImpl(boolean resume) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.replay && resume && !this.clear) {
                return;
            }
            if (this.replay && !resume && this.clear) {
                return;
            }
            this.dxEndpoint.getQDEndpoint().stopConnectorsAndWaitUninterruptibly();
            this.dxEndpoint.clearImpl();
            this.replay = false;
            this.speed = 0.0;
            this.captureOnDemandConnectorTime();
            this.configureOnDemandConnectorReplay();
            if (resume) {
                this.dxEndpoint.getQDEndpoint().startConnectors();
            }
            this.clear = !resume;
            this.change.schedule();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChangeEvent(String name, Object oldVal, Object newVal) {
        if (this.propertyChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldVal, newVal);
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            try {
                listener.propertyChange(event);
            }
            catch (Throwable t) {
                log.error("Exception in OnDemandService property change listener", t);
            }
        }
    }

    private void firePropertyChangeEventIfNeeded(String name, boolean oldVal, boolean newVal) {
        if (oldVal != newVal) {
            this.firePropertyChangeEvent(name, oldVal, newVal);
        }
    }

    private void firePropertyChangeEventIfNeeded(String name, double oldVal, double newVal) {
        if (Double.compare(oldVal, newVal) != 0) {
            this.firePropertyChangeEvent(name, oldVal, newVal);
        }
    }

    private void firePropertyChangeEventIfNeeded(String name, Date oldVal, Date newVal) {
        if (oldVal.getTime() != newVal.getTime()) {
            this.firePropertyChangeEvent(name, oldVal, newVal);
        }
    }

    private class PropertyChange
    implements Runnable {
        boolean scheduled;
        boolean oldReplaySupported;
        boolean oldReplay;
        boolean oldClear;
        double oldSpeed;
        Date oldTime;
        boolean newReplaySupported;
        boolean newReplay;
        boolean newClear;
        double newSpeed;
        Date newTime;

        private PropertyChange() {
            this.newReplaySupported = OnDemandServiceImpl.this.isReplaySupported();
            this.newReplay = OnDemandServiceImpl.this.isReplay();
            this.newClear = OnDemandServiceImpl.this.isClear();
            this.newSpeed = OnDemandServiceImpl.this.getSpeed();
            this.newTime = OnDemandServiceImpl.this.getTime();
        }

        public synchronized void schedule() {
            if (this.scheduled) {
                return;
            }
            this.scheduled = true;
            OnDemandServiceImpl.this.dxEndpoint.getOrCreateExecutor().execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                PropertyChange propertyChange = this;
                synchronized (propertyChange) {
                    this.oldReplaySupported = this.newReplaySupported;
                    this.oldReplay = this.newReplay;
                    this.oldClear = this.newClear;
                    this.oldSpeed = this.newSpeed;
                    this.oldTime = this.newTime;
                    this.newReplaySupported = OnDemandServiceImpl.this.isReplaySupported();
                    this.newReplay = OnDemandServiceImpl.this.isReplay();
                    this.newClear = OnDemandServiceImpl.this.isClear();
                    this.newSpeed = OnDemandServiceImpl.this.getSpeed();
                    this.newTime = OnDemandServiceImpl.this.getTime();
                    if (this.oldReplaySupported == this.newReplaySupported && this.oldReplay == this.newReplay && Double.compare(this.oldSpeed, this.newSpeed) == 0 && this.oldTime.equals(this.newTime)) {
                        this.scheduled = false;
                        return;
                    }
                }
                OnDemandServiceImpl.this.firePropertyChangeEventIfNeeded("replaySupported", this.oldReplaySupported, this.newReplaySupported);
                OnDemandServiceImpl.this.firePropertyChangeEventIfNeeded("replay", this.oldReplay, this.newReplay);
                OnDemandServiceImpl.this.firePropertyChangeEventIfNeeded("clear", this.oldClear, this.newClear);
                OnDemandServiceImpl.this.firePropertyChangeEventIfNeeded("speed", this.oldSpeed, this.newSpeed);
                OnDemandServiceImpl.this.firePropertyChangeEventIfNeeded("time", this.oldTime, this.newTime);
            }
        }
    }
}

