/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ondemand.impl.event;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.impl.QuoteMapping;
import com.dxfeed.ondemand.impl.event.MDREvent;
import java.io.IOException;

public class MDRQuote
extends MDREvent {
    private int bidTime;
    private int bidExchange;
    private int bidPrice;
    private int bidSize;
    private int askTime;
    private int askExchange;
    private int askPrice;
    private int askSize;

    @Override
    public void init(long startTime) {
        long seconds = startTime / 1000L;
        this.eventTime = seconds * 1000L;
        this.bidTime = (int)seconds;
        this.bidExchange = 0;
        this.bidPrice = 0;
        this.bidSize = 0;
        this.askTime = (int)seconds;
        this.askExchange = 0;
        this.askPrice = 0;
        this.askSize = 0;
    }

    @Override
    public boolean canSkip(MDREvent newEvent) {
        MDRQuote event = (MDRQuote)newEvent;
        return 0 == (this.bidExchange - event.bidExchange | this.bidPrice - event.bidPrice | this.bidSize - event.bidSize | this.askExchange - event.askExchange | this.askPrice - event.askPrice | this.askSize - event.askSize);
    }

    @Override
    public boolean canConflate(MDREvent newEvent) {
        return true;
    }

    @Override
    public void getInto(RecordCursor cursor) {
        cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)this.eventTime));
        QuoteMapping mapping = (QuoteMapping)cursor.getRecord().getMapping(QuoteMapping.class);
        mapping.setBidTimeSeconds(cursor, this.bidTime);
        mapping.setBidExchange(cursor, (char)this.bidExchange);
        mapping.setBidPriceDecimal(cursor, this.bidPrice);
        mapping.setBidSize(cursor, this.bidSize);
        mapping.setAskTimeSeconds(cursor, this.askTime);
        mapping.setAskExchange(cursor, (char)this.askExchange);
        mapping.setAskPriceDecimal(cursor, this.askPrice);
        mapping.setAskSize(cursor, this.askSize);
    }

    @Override
    public void setFrom(RecordCursor cursor) {
        this.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence((long)cursor.getEventTimeSequence()));
        QuoteMapping mapping = (QuoteMapping)cursor.getRecord().getMapping(QuoteMapping.class);
        this.bidTime = mapping.getBidTimeSeconds(cursor);
        this.bidExchange = mapping.getBidExchange(cursor);
        this.bidPrice = mapping.getBidPriceDecimal(cursor);
        this.bidSize = mapping.getBidSize(cursor);
        this.askTime = mapping.getAskTimeSeconds(cursor);
        this.askExchange = mapping.getAskExchange(cursor);
        this.askPrice = mapping.getAskPriceDecimal(cursor);
        this.askSize = mapping.getAskSize(cursor);
    }

    @Override
    public void setFrom(MDREvent source) {
        MDRQuote event = (MDRQuote)source;
        this.eventTime = event.eventTime;
        this.bidTime = event.bidTime;
        this.bidExchange = event.bidExchange;
        this.bidPrice = event.bidPrice;
        this.bidSize = event.bidSize;
        this.askTime = event.askTime;
        this.askExchange = event.askExchange;
        this.askPrice = event.askPrice;
        this.askSize = event.askSize;
    }

    @Override
    public void read(ByteArrayInput in) throws IOException {
        this.eventTime += in.readCompactLong();
        int flag = in.readUnsignedByte();
        this.bidTime += MDRQuote.readDeltaFlagged(in, flag, 128);
        this.bidExchange += MDRQuote.readDeltaFlagged(in, flag, 64);
        this.bidPrice += MDRQuote.readDeltaFlagged(in, flag, 32);
        this.bidSize += MDRQuote.readDeltaFlagged(in, flag, 16);
        this.askTime += MDRQuote.readDeltaFlagged(in, flag, 8);
        this.askExchange += MDRQuote.readDeltaFlagged(in, flag, 4);
        this.askPrice += MDRQuote.readDeltaFlagged(in, flag, 2);
        this.askSize += MDRQuote.readDeltaFlagged(in, flag, 1);
    }

    @Override
    public void write(ByteArrayOutput out, MDREvent newEvent) throws IOException {
        MDRQuote event = (MDRQuote)newEvent;
        out.writeCompactLong(event.eventTime - this.eventTime);
        int flagPosition = out.getPosition();
        out.writeByte(0);
        int flag = MDRQuote.writeDeltaFlagged(out, this.bidTime, event.bidTime, 128) | MDRQuote.writeDeltaFlagged(out, this.bidExchange, event.bidExchange, 64) | MDRQuote.writeDeltaFlagged(out, this.bidPrice, event.bidPrice, 32) | MDRQuote.writeDeltaFlagged(out, this.bidSize, event.bidSize, 16) | MDRQuote.writeDeltaFlagged(out, this.askTime, event.askTime, 8) | MDRQuote.writeDeltaFlagged(out, this.askExchange, event.askExchange, 4) | MDRQuote.writeDeltaFlagged(out, this.askPrice, event.askPrice, 2) | MDRQuote.writeDeltaFlagged(out, this.askSize, event.askSize, 1);
        out.getBuffer()[flagPosition] = (byte)flag;
        this.setFrom(event);
    }
}

