/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.plotter;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class SwingExecutor
implements Executor {
    private final ConcurrentLinkedQueue<Runnable> commands = new ConcurrentLinkedQueue();
    private final int delay;

    SwingExecutor(int delay) {
        this.delay = delay;
        SwingUtilities.invokeLater(this::createTimer);
    }

    private void createTimer() {
        Timer timer = new Timer(this.delay, e -> {
            Runnable command;
            while ((command = this.commands.poll()) != null) {
                command.run();
            }
        });
        timer.start();
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.commands.add(command);
    }
}

