/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.promise;

import com.dxfeed.promise.PromiseException;
import com.dxfeed.promise.PromiseHandler;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class Promise<T> {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_RESULT = 1;
    private static final int STATE_EXCEPTION = 2;
    private static final int STATE_CANCELED = 4;
    private volatile int state;
    private volatile T result;
    private volatile Throwable exception;
    private PromiseHandler<? super T> handler;

    public Promise() {
    }

    private Promise(T result) {
        this.state = 1;
        this.result = result;
    }

    private Promise(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException();
        }
        this.state = 2;
        this.exception = exception;
    }

    public final boolean isDone() {
        return this.state != 0;
    }

    public final boolean hasResult() {
        return this.state == 1;
    }

    public final boolean hasException() {
        return (this.state & 6) != 0;
    }

    public final boolean isCancelled() {
        return this.state == 4;
    }

    public final T getResult() {
        return this.result;
    }

    public final Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T await() {
        Promise promise = this;
        synchronized (promise) {
            while (this.state == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return this.joinResult();
    }

    public final T await(long timeout, TimeUnit unit) {
        if (!this.awaitImpl(timeout, unit)) {
            this.cancelImpl("await timed out");
        }
        return this.joinResult();
    }

    public final boolean awaitWithoutException(long timeout, TimeUnit unit) {
        if (!this.awaitImpl(timeout, unit)) {
            this.cancelImpl("awaitWithoutException timed out");
            return false;
        }
        this.joinResult();
        return true;
    }

    public final void cancel() {
        this.cancelImpl("cancel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void complete(T result) {
        PromiseHandler<? super T> handler;
        Promise promise = this;
        synchronized (promise) {
            if (this.state != 0) {
                return;
            }
            handler = this.handler;
            this.handler = null;
            this.result = result;
            this.state = 1;
            this.notifyAll();
        }
        this.handleDone(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void completeExceptionally(Throwable exception) {
        PromiseHandler<? super T> handler;
        if (exception == null) {
            throw new NullPointerException();
        }
        Promise promise = this;
        synchronized (promise) {
            if (this.state != 0) {
                return;
            }
            handler = this.handler;
            this.handler = null;
            this.exception = exception;
            this.state = 2;
            this.notifyAll();
        }
        this.handleDone(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void whenDone(PromiseHandler<? super T> handler) {
        boolean done;
        if (handler == null) {
            throw new NullPointerException();
        }
        Promise promise = this;
        synchronized (promise) {
            boolean bl = done = this.state != 0;
            if (!done) {
                if (this.handler == null) {
                    this.handler = handler;
                } else if (this.handler instanceof Handlers) {
                    ((Handlers)this.handler).add(handler);
                } else {
                    this.handler = new Handlers<T>(this.handler, handler);
                }
            }
        }
        if (done) {
            handler.promiseDone(this);
        }
    }

    public final void whenDoneAsync(PromiseHandler<? super T> handler, Executor executor) {
        if (handler == null || executor == null) {
            throw new NullPointerException();
        }
        this.whenDone(promise -> executor.execute(() -> handler.promiseDone(this)));
    }

    public static <T> Promise<T> completed(T result) {
        return new Promise<T>(result);
    }

    public static <T> Promise<T> failed(Throwable exception) {
        return new Promise<T>(exception);
    }

    protected void handleDone(PromiseHandler<? super T> handler) {
        if (handler != null) {
            handler.promiseDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitImpl(long timeout, TimeUnit unit) {
        long originalWaitMillis;
        long remainingMillis = originalWaitMillis = unit.toMillis(timeout);
        Promise promise = this;
        synchronized (promise) {
            while (remainingMillis > 0L && this.state == 0) {
                long startWaitTime = System.currentTimeMillis();
                try {
                    this.wait(remainingMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                remainingMillis = Math.min(originalWaitMillis, remainingMillis - (System.currentTimeMillis() - startWaitTime));
            }
        }
        return remainingMillis > 0L;
    }

    private T joinResult() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelImpl("interrupted");
        }
        switch (this.state) {
            case 1: {
                return this.result;
            }
            case 4: {
                throw (CancellationException)this.exception;
            }
            case 2: {
                throw new PromiseException(this.exception);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelImpl(String message) {
        PromiseHandler<? super T> handler;
        Promise promise = this;
        synchronized (promise) {
            if (this.state != 0) {
                return;
            }
            handler = this.handler;
            this.handler = null;
            this.exception = new CancellationException(message);
            this.state = 4;
            this.notifyAll();
        }
        this.handleDone(handler);
    }

    private static class Handlers<T>
    implements PromiseHandler<T> {
        PromiseHandler<? super T>[] handlers;

        @SafeVarargs
        Handlers(PromiseHandler<? super T> ... handlers) {
            this.handlers = handlers;
        }

        void add(PromiseHandler<? super T> handler) {
            int n = this.handlers.length;
            this.handlers = Arrays.copyOf(this.handlers, n + 1);
            this.handlers[n] = handler;
        }

        @Override
        public void promiseDone(Promise<? extends T> promise) {
            for (PromiseHandler<? extends T> promiseHandler : this.handlers) {
                promiseHandler.promiseDone(promise);
            }
        }
    }
}

