/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ipf;

import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import com.dxfeed.sample.api.DXFeedConnect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DXFeedIpfConnect {
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length != 2) {
            String eventTypeNames = DXFeedConnect.getEventTypeNames(MarketEvent.class);
            System.err.println("usage: DXFeedIpfConnect <type> <ipf-file>");
            System.err.println("where: <type>     is dxfeed event type (" + eventTypeNames + ")");
            System.err.println("       <ipf-file> is name of instrument profiles file");
            return;
        }
        String argType = args[0];
        String argIpfFile = args[1];
        Class<MarketEvent> eventType = DXFeedConnect.findEventType(argType, MarketEvent.class);
        DXFeedSubscription sub = DXFeed.getInstance().createSubscription(eventType);
        sub.addEventListener(events -> {
            for (MarketEvent event : events) {
                System.out.println(event.getEventSymbol() + ": " + event);
            }
        });
        sub.addSymbols(DXFeedIpfConnect.getSymbols(argIpfFile));
        Thread.sleep(Long.MAX_VALUE);
    }

    private static List<String> getSymbols(String filename) throws IOException {
        System.out.printf("Reading instruments from %s ...%n", filename);
        List profiles = new InstrumentProfileReader().readFromFile(filename);
        ProfileFilter filter = profile -> profile.getType().equals("STOCK") && profile.getSIC() / 10 == 357 && profile.getExchanges().contains("XNYS");
        ArrayList<String> result = new ArrayList<String>();
        System.out.println("Selected symbols are:");
        for (InstrumentProfile profile2 : profiles) {
            if (!filter.accept(profile2)) continue;
            result.add(profile2.getSymbol());
            System.out.println(profile2.getSymbol() + " (" + profile2.getDescription() + ")");
        }
        return result;
    }

    private static interface ProfileFilter {
        public boolean accept(InstrumentProfile var1);
    }
}

