/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ipf;

import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileType;
import com.dxfeed.ipf.live.InstrumentProfileCollector;
import com.dxfeed.ipf.live.InstrumentProfileConnection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DXFeedLiveIpfSample {
    private static final String DXFEED_IPF_URL = "https://demo:demo@tools.dxfeed.com/ipf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        if (args.length > 1) {
            System.err.println("usage: DXFeedLiveIpfSample [<ipf-url>]");
            System.err.println("where: <ipf-url>  is URL for the instruments profiles, default: https://demo:demo@tools.dxfeed.com/ipf");
            return;
        }
        String url = args.length > 0 ? args[0] : DXFEED_IPF_URL;
        InstrumentProfileCollector collector = new InstrumentProfileCollector();
        InstrumentProfileConnection connection = InstrumentProfileConnection.createConnection((String)url, (InstrumentProfileCollector)collector);
        connection.setUpdatePeriod(60000L);
        connection.addStateChangeListener(event -> System.out.println("Connection state: " + event.getNewValue()));
        connection.start();
        connection.waitUntilCompleted(10L, TimeUnit.SECONDS);
        ConcurrentHashMap profiles = new ConcurrentHashMap();
        collector.addUpdateListener(instruments -> {
            System.out.println("\nInstrument Profiles:");
            instruments.forEachRemaining(profile -> {
                if (InstrumentProfileType.REMOVED.name().equals(profile.getType())) {
                    profiles.remove(profile.getSymbol());
                } else {
                    profiles.put(profile.getSymbol(), profile);
                }
            });
            System.out.println("Total number of profiles (1): " + profiles.size());
            Set symbols = StreamSupport.stream(collector.view().spliterator(), false).filter(profile -> !InstrumentProfileType.REMOVED.name().equals(profile.getType())).map(InstrumentProfile::getSymbol).collect(Collectors.toSet());
            System.out.println("Total number of profiles (2): " + symbols.size());
            System.out.println("Last modified: " + new Date(collector.getLastUpdateTime()));
        });
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        finally {
            connection.close();
        }
    }
}

