/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ondemand;

import com.devexperts.util.TimeUtil;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.Quote;
import com.dxfeed.ondemand.OnDemandService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OnDemandSample {
    public static void main(String[] args) throws ParseException, InterruptedException {
        OnDemandService onDemand = OnDemandService.getInstance();
        DXFeed feed = onDemand.getEndpoint().getFeed();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'EST'");
        fmt.setTimeZone(TimeUtil.getTimeZone((String)"America/New_York"));
        DXFeedSubscription sub = feed.createSubscription(Quote.class);
        sub.addEventListener(events -> {
            for (Quote quote : events) {
                System.out.println(fmt.format(new Date(quote.getEventTime())) + " : " + quote.getEventSymbol() + " bid " + quote.getBidPrice() + " / ask " + quote.getAskPrice());
            }
        });
        sub.addSymbols((Object)"ACN");
        Date from = fmt.parse("2010-05-06 14:47:48.000 EST");
        Date to = fmt.parse("2010-05-06 14:48:02.000 EST");
        onDemand.replay(from);
        while (onDemand.getTime().getTime() < to.getTime()) {
            System.out.println("Current state is " + onDemand.getEndpoint().getState() + ", on-demand time is " + fmt.format(onDemand.getTime()));
            Thread.sleep(1000L);
        }
        onDemand.getEndpoint().closeAndAwaitTermination();
    }
}

