/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.api;

import com.devexperts.util.TimeFormat;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.event.EventType;
import com.dxfeed.event.TimeSeriesEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DXFeedConnect {
    public static void main(String[] args) {
        if (args.length < 2) {
            String eventTypeNames = DXFeedConnect.getEventTypeNames(EventType.class);
            System.err.println("usage: DXFeedConnect <types> <symbols> [<time>]");
            System.err.println("where: <types>   is comma-separated list of dxfeed event type (" + eventTypeNames + ")");
            System.err.println("       <symbols> is comma-separated list of security symbols to get events for (e.g. \"IBM,C,SPX\")");
            System.err.println("                 for Candle event specify symbol with aggregation like in \"IBM{=15m}\"");
            System.err.println("       <time>    is a fromTime for time-series subscription");
            return;
        }
        String argTypes = args[0];
        String argSymbols = args[1];
        String argTime = args.length > 2 ? args[2] : null;
        String[] symbols = DXFeedConnect.parseSymbols(argSymbols);
        try {
            for (String type : argTypes.split(",")) {
                if (argTime != null) {
                    DXFeedConnect.connectTimeSeriesEvent(type, argTime, symbols);
                    continue;
                }
                DXFeedConnect.connectEvent(type, symbols);
            }
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] parseSymbols(String symbolList) {
        ArrayList<String> result = new ArrayList<String>();
        int parentheses = 0;
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < symbolList.length(); ++i) {
            char ch = symbolList.charAt(i);
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    ++parentheses;
                    sb.append(ch);
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (parentheses > 0) {
                        --parentheses;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case ',': {
                    if (parentheses == 0) {
                        result.add(sb.toString());
                        sb.setLength(0);
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        result.add(sb.toString());
        return result.toArray(new String[result.size()]);
    }

    private static void connectEvent(String type, String ... symbols) {
        Class<EventType> eventType = DXFeedConnect.findEventType(type, EventType.class);
        DXFeedSubscription sub = DXFeed.getInstance().createSubscription(eventType);
        sub.addEventListener(DXFeedConnect::printEvents);
        sub.addSymbols((Object[])symbols);
    }

    private static void connectTimeSeriesEvent(String type, String fromTime, String ... symbols) {
        Class<TimeSeriesEvent> eventType = DXFeedConnect.findEventType(type, TimeSeriesEvent.class);
        long from = TimeFormat.DEFAULT.parse(fromTime).getTime();
        DXFeedTimeSeriesSubscription sub = DXFeed.getInstance().createTimeSeriesSubscription(eventType);
        sub.addEventListener(DXFeedConnect::printEvents);
        sub.setFromTime(from);
        sub.addSymbols((Object[])symbols);
    }

    private static void printEvents(List<?> events) {
        for (Object event : events) {
            System.out.println(event);
        }
    }

    public static String getEventTypeNames(Class<?> baseClass) {
        StringBuilder sb = new StringBuilder();
        for (String s : DXFeedConnect.getEventTypesMap(baseClass).keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static <T> Class<T> findEventType(String type, Class<? super T> baseClass) {
        Class<?> result = DXFeedConnect.getEventTypesMap(baseClass).get(type);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find " + baseClass.getSimpleName() + " '" + type + "'");
        }
        return result;
    }

    private static Map<String, Class<?>> getEventTypesMap(Class<?> baseClass) {
        TreeMap result = new TreeMap();
        for (Class eventType : DXEndpoint.getInstance().getEventTypes()) {
            if (!baseClass.isAssignableFrom(eventType)) continue;
            result.put(eventType.getSimpleName(), eventType);
        }
        return result;
    }
}

