/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ui.swing;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.Profile;
import com.dxfeed.model.TimeSeriesEventModel;
import com.dxfeed.sample.ui.swing.SwingExecutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DXFeedCandleChart {
    private JPanel form;
    private JTextField symbolText;
    private JLabel description;
    private JComponent chart;
    private JComboBox<String> periodComboBox;
    private final TimeSeriesEventModel<Candle> candles = new TimeSeriesEventModel(Candle.class);
    private final DXFeedSubscription<Profile> profileSub = new DXFeedSubscription(Profile.class);
    double minY;
    double maxY;
    private static final int PAD = 5;

    public static void main(String[] args) {
        DXEndpoint.getInstance((DXEndpoint.Role)DXEndpoint.Role.FEED).executor((Executor)new SwingExecutor(20));
        DXFeedCandleChart instance = new DXFeedCandleChart();
        SwingUtilities.invokeLater(instance::go);
    }

    private DXFeedCandleChart() {
        DXFeed feed = DXFeed.getInstance();
        this.candles.attach(feed);
        this.profileSub.attach(feed);
    }

    private void go() {
        this.setupUI();
        this.initListeners();
        this.createFrame();
    }

    private void initListeners() {
        this.candles.getEventsList().addListener(change -> this.chart.repaint());
        this.profileSub.addEventListener(this::profilesReceived);
        this.symbolText.addActionListener(this::symbolPeriodChanged);
        this.periodComboBox.addActionListener(this::symbolPeriodChanged);
    }

    private void createFrame() {
        JFrame frame = new JFrame("DXFeed Candle Chart");
        frame.add(this.form);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void symbolPeriodChanged(ActionEvent e) {
        this.candles.clear();
        this.profileSub.clear();
        this.description.setText("");
        String symbol = this.symbolText.getText();
        String periodStr = (String)this.periodComboBox.getSelectedItem();
        if (symbol.length() > 0) {
            CandlePeriod candlePeriod = CandlePeriod.parse((String)periodStr);
            this.candles.setSymbol((Object)CandleSymbol.valueOf((String)symbol, (CandleSymbolAttribute)candlePeriod));
            long range = candlePeriod.equals((Object)CandlePeriod.DAY) ? 31536000000L : 432000000L;
            this.candles.setFromTime(System.currentTimeMillis() - range);
            this.profileSub.setSymbols(Collections.singletonList(symbol));
        }
        this.chart.repaint();
    }

    private void initCandleRange() {
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        for (Candle candle : this.candles.getEventsList()) {
            this.minY = Math.min(this.minY, candle.getLow());
            this.maxY = Math.max(this.maxY, candle.getHigh());
        }
    }

    private double getX(int index) {
        int n = this.candles.getEventsList().size();
        return n <= 1 ? (double)this.chart.getWidth() / 2.0 : (double)(5 + index * (this.chart.getWidth() - 10) / (n - 1));
    }

    private double getY(double value) {
        return this.minY == this.maxY ? (double)this.chart.getHeight() / 2.0 : 5.0 + (this.maxY - value) * (double)(this.chart.getHeight() - 10) / (this.maxY - this.minY);
    }

    private void paintChart(Graphics g1) {
        this.initCandleRange();
        Graphics2D g = (Graphics2D)g1;
        g.setColor(this.chart.getBackground());
        g.fillRect(0, 0, this.chart.getWidth(), this.chart.getHeight());
        int index = 0;
        for (Candle candle : this.candles.getEventsList()) {
            boolean up = candle.getClose() >= candle.getOpen();
            g.setColor(up ? Color.green : Color.red);
            double x = this.getX(index++);
            double open = this.getY(candle.getOpen());
            double close = this.getY(candle.getClose());
            double low = this.getY(candle.getLow());
            double high = this.getY(candle.getHigh());
            if (up) {
                g.fill(new Rectangle2D.Double(x - 1.0, close, 2.0, open - close));
                g.draw(new Line2D.Double(x, low, x, open));
                g.draw(new Line2D.Double(x, close, x, high));
                continue;
            }
            g.draw(new Rectangle2D.Double(x - 1.0, open, 2.0, close - open));
            g.draw(new Line2D.Double(x, low, x, close));
            g.draw(new Line2D.Double(x, open, x, high));
        }
    }

    private void profilesReceived(List<Profile> events) {
        for (Profile event : events) {
            if (event.getDescription() == null) continue;
            this.description.setText(event.getDescription());
        }
    }

    private void setupUI() {
        this.form = new JPanel();
        this.form.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer1, gbc);
        this.symbolText = new JTextField();
        this.symbolText.setColumns(10);
        this.symbolText.setMaximumSize(this.symbolText.getPreferredSize());
        this.symbolText.setMinimumSize(this.symbolText.getPreferredSize());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel1.add((Component)this.symbolText, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer2, gbc);
        this.description = new JLabel();
        this.description.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel1.add((Component)this.description, gbc);
        JLabel symbolLabel = new JLabel();
        symbolLabel.setHorizontalAlignment(2);
        symbolLabel.setText("Symbol");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel1.add((Component)symbolLabel, gbc);
        this.periodComboBox = new JComboBox<String>(new String[]{"1D", "15m"});
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel1.add(this.periodComboBox, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer3, gbc);
        this.chart = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                DXFeedCandleChart.this.paintChart(g);
            }
        };
        this.chart.setPreferredSize(new Dimension(500, 300));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)this.chart, gbc);
        this.chart.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
    }
}

