/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ui.swing;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.model.IndexedEventModel;
import com.dxfeed.sample.ui.swing.SwingExecutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DXFeedTimeAndSales {
    private static final int NUMBER_OF_PRESENT_TRADES = 30;
    private JPanel form;
    private JTextField symbolText;
    private JLabel description;
    private JTable timeAndSalesTable;
    private final IndexedEventModel<TimeAndSale> timeAndSales = new IndexedEventModel(TimeAndSale.class);
    private final DXFeedSubscription<Profile> profileSub = new DXFeedSubscription(Profile.class);
    private final DefaultTableModel tableModel = new DefaultTableModel();

    public static void main(String[] args) {
        DXEndpoint.getInstance().executor((Executor)new SwingExecutor(20));
        DXFeedTimeAndSales instance = new DXFeedTimeAndSales();
        SwingUtilities.invokeLater(instance::go);
    }

    private DXFeedTimeAndSales() {
        DXFeed feed = DXFeed.getInstance();
        this.timeAndSales.setSizeLimit(30);
        this.timeAndSales.attach(feed);
        this.profileSub.attach(feed);
    }

    private void go() {
        this.setupUI();
        this.initTableModel();
        this.initListeners();
        this.createFrame();
    }

    private void initListeners() {
        this.timeAndSales.getEventsList().addListener(change -> this.timeAndSalesReceived());
        this.profileSub.addEventListener(this::profilesReceived);
        this.symbolText.addActionListener(e -> this.symbolChanged());
    }

    private void createFrame() {
        JFrame frame = new JFrame("DXFeed Time & Sales");
        frame.add(this.form);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void initTableModel() {
        this.tableModel.addColumn("Time");
        this.tableModel.addColumn("Index");
        this.tableModel.addColumn("EX");
        this.tableModel.addColumn("Price");
        this.tableModel.addColumn("Size");
        this.tableModel.addColumn("Bid");
        this.tableModel.addColumn("Ask");
        this.tableModel.addColumn("SC");
        this.timeAndSalesTable.setModel(this.tableModel);
    }

    private void symbolChanged() {
        this.timeAndSales.clear();
        this.profileSub.clear();
        this.timeAndSales.clear();
        this.description.setText("");
        this.tableModel.setRowCount(0);
        String symbol = this.symbolText.getText();
        if (symbol.length() > 0) {
            this.timeAndSales.setSymbol((Object)symbol);
            this.profileSub.setSymbols(Collections.singletonList(symbol));
        }
    }

    private synchronized void timeAndSalesReceived() {
        ArrayList rows = new ArrayList(this.timeAndSales.getEventsList());
        Collections.sort(rows, Comparator.comparing(TimeAndSale::getTime));
        this.tableModel.setRowCount(0);
        for (TimeAndSale timeAndSale : rows) {
            this.tableModel.addRow(new Object[]{timeAndSale.getTime(), timeAndSale.getIndex(), Character.valueOf(timeAndSale.getExchangeCode()), timeAndSale.getPrice(), timeAndSale.getSizeAsDouble(), timeAndSale.getBidPrice(), timeAndSale.getAskPrice(), timeAndSale.getExchangeSaleConditions()});
        }
    }

    private void profilesReceived(List<Profile> events) {
        for (Profile event : events) {
            if (event.getDescription() == null) continue;
            this.description.setText(event.getDescription());
        }
    }

    private void setupUI() {
        this.form = new JPanel();
        this.form.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer1, gbc);
        this.symbolText = new JTextField();
        this.symbolText.setColumns(10);
        this.symbolText.setMaximumSize(this.symbolText.getPreferredSize());
        this.symbolText.setMinimumSize(this.symbolText.getPreferredSize());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel1.add((Component)this.symbolText, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer2, gbc);
        this.description = new JLabel();
        this.description.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 3.0;
        gbc.anchor = 17;
        panel1.add((Component)this.description, gbc);
        JLabel symbolLabel = new JLabel();
        symbolLabel.setHorizontalAlignment(10);
        symbolLabel.setText("Symbol");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel1.add((Component)symbolLabel, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel2, gbc);
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)scrollPane1, gbc);
        this.timeAndSalesTable = new JTable();
        scrollPane1.setViewportView(this.timeAndSalesTable);
    }
}

