/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ipf.option;

import com.dxfeed.api.DXFeed;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Trade;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import com.dxfeed.ipf.option.OptionChain;
import com.dxfeed.ipf.option.OptionChainsBuilder;
import com.dxfeed.ipf.option.OptionSeries;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.Promises;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DXFeedOptionChain {
    public static void main(String[] args) throws IOException {
        InstrumentProfile put;
        InstrumentProfile call;
        List strikes;
        if (args.length != 4) {
            System.err.println("usage: DXFeedOptionChain <ipf-file> <symbol> <n> <k>");
            System.err.println("       <ipf-file> is name of instrument profiles file");
            System.err.println("       <symbol>   is the product or underlying symbol");
            System.err.println("       <nStrikes> number of strikes to print for each series");
            System.err.println("       <nMonths>  number of months to print");
            return;
        }
        String argIpfFile = args[0];
        String argSymbol = args[1];
        int nStrikes = Integer.parseInt(args[2]);
        int nMonths = Integer.parseInt(args[3]);
        DXFeed feed = DXFeed.getInstance();
        System.out.printf("Waiting for price of %s ...%n", argSymbol);
        Trade trade = (Trade)feed.getLastEventPromise(Trade.class, (Object)argSymbol).await(1L, TimeUnit.SECONDS);
        double price = trade.getPrice();
        System.out.printf(Locale.US, "Price of %s is %f%n", argSymbol, price);
        System.out.printf("Reading instruments from %s ...%n", argIpfFile);
        List instruments = new InstrumentProfileReader().readFromFile(argIpfFile);
        System.out.printf("Building option chains ...%n", new Object[0]);
        Map chains = OptionChainsBuilder.build((Collection)instruments).getChains();
        OptionChain chain = (OptionChain)chains.get(argSymbol);
        nMonths = Math.min(nMonths, chain.getSeries().size());
        List seriesList = new ArrayList(chain.getSeries()).subList(0, nMonths);
        System.out.printf("Requesting option quotes ...%n", new Object[0]);
        HashMap<InstrumentProfile, Promise> quotes = new HashMap<InstrumentProfile, Promise>();
        for (OptionSeries series : seriesList) {
            strikes = series.getNStrikesAround(nStrikes, price);
            for (Double strike : strikes) {
                call = (InstrumentProfile)series.getCalls().get(strike);
                put = (InstrumentProfile)series.getPuts().get(strike);
                if (call != null) {
                    quotes.put(call, feed.getLastEventPromise(Quote.class, (Object)call.getSymbol()));
                }
                if (put == null) continue;
                quotes.put(put, feed.getLastEventPromise(Quote.class, (Object)put.getSymbol()));
            }
        }
        Promises.allOf(quotes.values()).awaitWithoutException(1L, TimeUnit.SECONDS);
        System.out.printf("Printing option series ...%n", new Object[0]);
        for (OptionSeries series : seriesList) {
            System.out.printf("Option series %s%n", series);
            strikes = series.getNStrikesAround(nStrikes, price);
            System.out.printf("    %10s %10s %10s %10s %10s%n", "C.BID", "C.ASK", "STRIKE", "P.BID", "P.ASK");
            for (Double strike : strikes) {
                Quote putQuote;
                call = (InstrumentProfile)series.getCalls().get(strike);
                put = (InstrumentProfile)series.getPuts().get(strike);
                Quote callQuote = call == null ? null : (Quote)((Promise)quotes.get(call)).getResult();
                Quote quote = putQuote = put == null ? null : (Quote)((Promise)quotes.get(put)).getResult();
                if (callQuote == null) {
                    callQuote = new Quote();
                }
                if (putQuote == null) {
                    putQuote = new Quote();
                }
                System.out.printf(Locale.US, "    %10.3f %10.3f %10.3f %10.3f %10.3f%n", callQuote.getBidPrice(), callQuote.getAskPrice(), strike, putQuote.getBidPrice(), putQuote.getAskPrice());
            }
        }
        System.exit(0);
    }
}

