/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample._simple_;

import com.dxfeed.api.DXFeed;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.IndexedEventTxModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SimpleOrderBookSample {
    public static void main(String[] args) throws InterruptedException {
        if (args.length < 2) {
            System.err.println("usage: SimpleOrderBookSample <symbol> <source> [<limit>] [<period>]");
            System.err.println("where: <symbol> is the security symbol to get events for (e.g. \"AAPL,IBM\")");
            System.err.println("       <source> is the order source (e.g. \"ntv,dex\")");
            System.err.println("example: AAPL ntv");
            return;
        }
        String symbol = args[0];
        OrderSource source = OrderSource.valueOf((String)args[1]);
        OrderListener listener = new OrderListener();
        IndexedEventTxModel model = IndexedEventTxModel.newBuilder(Order.class).withFeed(DXFeed.getInstance()).withSymbol(symbol).withSource((IndexedEventSource)source).withListener((IndexedEventTxModel.Listener)listener).build();
        int depthLimit = 5;
        while (true) {
            SimpleOrderBookSample.printBook(listener.getBook(), depthLimit);
            Thread.sleep(1000L);
        }
    }

    private static void printBook(OrderBook book, int depthLimit) {
        if (book.buyOrders.isEmpty() && book.sellOrders.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Order> buyIterator = book.buyOrders.iterator();
        Iterator<Order> sellIterator = book.sellOrders.iterator();
        int limit = Math.min(Math.max(book.buyOrders.size(), book.sellOrders.size()), depthLimit);
        for (int i = 0; i < limit && (buyIterator.hasNext() || sellIterator.hasNext()); ++i) {
            String buyTable = SimpleOrderBookSample.getOrderInfo(buyIterator, Side.BUY);
            String sellTable = SimpleOrderBookSample.getOrderInfo(sellIterator, Side.SELL);
            sb.append(buyTable).append("\t").append(sellTable).append("\n");
        }
        System.out.println(sb);
    }

    private static String getOrderInfo(Iterator<Order> iterator, Side side) {
        if (iterator.hasNext()) {
            Order order = iterator.next();
            return String.format("%s [Source: %s, Size: %8.4f, Price: %8.2f]", side, order.getSource(), order.getSizeAsDouble(), order.getPrice());
        }
        return String.format("%s [None]", side);
    }

    private static class OrderListener
    implements IndexedEventTxModel.Listener<Order> {
        private final Map<Long, Order> ordersByIndex = new HashMap<Long, Order>();
        private final Set<Order> buyOrders = new TreeSet<Order>(Comparator.comparingDouble(OrderBase::getPrice).reversed().thenComparingLong(OrderBase::getIndex));
        private final Set<Order> sellOrders = new TreeSet<Order>(Comparator.comparingDouble(OrderBase::getPrice).thenComparingLong(OrderBase::getIndex));

        private OrderListener() {
        }

        public synchronized void eventsReceived(List<Order> events, boolean isSnapshot) {
            if (isSnapshot) {
                this.ordersByIndex.clear();
                this.buyOrders.clear();
                this.sellOrders.clear();
            }
            for (Order order : events) {
                Order oldOrder = this.ordersByIndex.remove(order.getIndex());
                if (oldOrder != null) {
                    this.selectSideSet(oldOrder).remove(oldOrder);
                }
                if ((order.getEventFlags() & 2) != 0) continue;
                this.ordersByIndex.put(order.getIndex(), order);
                if (!this.shallAddToBook(order)) continue;
                this.selectSideSet(order).add(order);
            }
        }

        public synchronized OrderBook getBook() {
            return new OrderBook(new ArrayList<Order>(this.buyOrders), new ArrayList<Order>(this.sellOrders));
        }

        private boolean shallAddToBook(Order order) {
            return order.hasSize();
        }

        private Set<Order> selectSideSet(Order order) {
            return order.getOrderSide() == Side.BUY ? this.buyOrders : this.sellOrders;
        }
    }

    private static class OrderBook {
        private final List<Order> buyOrders;
        private final List<Order> sellOrders;

        public OrderBook(List<Order> buyOrders, List<Order> sellOrders) {
            this.buyOrders = buyOrders;
            this.sellOrders = sellOrders;
        }
    }
}

