/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.api;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.MarketEvent;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DXFeedFileParser {
    public static void main(String[] args) throws InterruptedException {
        if (args.length != 3) {
            String eventTypeNames = DXFeedFileParser.getEventTypeNames();
            System.err.println("usage: DXFeedFileParser <file> <type> <symbol>");
            System.err.println("where: <file>    is a file name");
            System.err.println("       <type>    is a dxfeed event type (" + eventTypeNames + ")");
            System.err.println("       <symbol>  is a security symbols to get events for (e.g. \"IBM\", \"C\", etc)");
            return;
        }
        String argFile = args[0];
        String argType = args[1];
        String argSymbol = args[2];
        DXEndpoint endpoint = DXEndpoint.create((DXEndpoint.Role)DXEndpoint.Role.STREAM_FEED);
        DXFeed feed = endpoint.getFeed();
        DXFeedSubscription sub = feed.createSubscription(DXFeedFileParser.findEventType(argType));
        sub.addEventListener((DXFeedEventListener)new PrintListener());
        sub.addSymbols((Object)argSymbol);
        endpoint.connect("file:" + argFile + "[speed=max]");
        endpoint.awaitNotConnected();
        endpoint.closeAndAwaitTermination();
    }

    private static Class<?> findEventType(String type) {
        Class<?> result = DXFeedFileParser.getEventTypesMap().get(type);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find type '" + type + "'");
        }
        return result;
    }

    private static Map<String, Class<?>> getEventTypesMap() {
        TreeMap result = new TreeMap();
        for (Class eventType : DXEndpoint.getInstance((DXEndpoint.Role)DXEndpoint.Role.STREAM_FEED).getEventTypes()) {
            if (!MarketEvent.class.isAssignableFrom(eventType)) continue;
            result.put(eventType.getSimpleName(), eventType);
        }
        return result;
    }

    private static String getEventTypeNames() {
        StringBuilder sb = new StringBuilder();
        for (String s : DXFeedFileParser.getEventTypesMap().keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static class PrintListener
    implements DXFeedEventListener<Object> {
        private int eventCounter;

        private PrintListener() {
        }

        public void eventsReceived(List<Object> events) {
            for (Object event : events) {
                System.out.println(++this.eventCounter + ": " + event);
            }
        }
    }
}

