/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ui.swing;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Profile;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.market.OrderBookModel;
import com.dxfeed.sample.ui.swing.SwingExecutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DXFeedMarketDepth {
    private JTextField symbolText;
    private JTable bidTable;
    private JTable askTable;
    private JPanel form;
    private JLabel description;
    private final OrderBookModel orderBook = new OrderBookModel();
    private final DXFeedSubscription<Profile> profileSub = new DXFeedSubscription(Profile.class);
    private final BookTableModel bidModel = new BookTableModel();
    private final BookTableModel askModel = new BookTableModel();

    public static void main(String[] args) {
        DXEndpoint.getInstance().executor((Executor)new SwingExecutor(20));
        DXFeedMarketDepth instance = new DXFeedMarketDepth();
        SwingUtilities.invokeLater(instance::go);
    }

    private DXFeedMarketDepth() {
        DXFeed feed = DXFeed.getInstance();
        this.orderBook.attach(feed);
        this.profileSub.attach(feed);
    }

    private void go() {
        this.setupUI();
        this.initTableModel(this.bidTable, this.bidModel, (ObservableListModel<Order>)this.orderBook.getBuyOrders());
        this.initTableModel(this.askTable, this.askModel, (ObservableListModel<Order>)this.orderBook.getSellOrders());
        this.initListeners();
        this.createFrame();
    }

    private void initListeners() {
        this.profileSub.addEventListener(this::profilesReceived);
        this.symbolText.addActionListener(this::symbolChanged);
    }

    private void createFrame() {
        JFrame frame = new JFrame("DXFeed Market Depth");
        frame.add(this.form);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void initTableModel(JTable table, BookTableModel model, ObservableListModel<Order> book) {
        table.setModel(model);
        book.addListener(change -> model.updateOrders((List<Order>)book));
    }

    private void symbolChanged(ActionEvent e) {
        this.profileSub.clear();
        this.description.setText("");
        String symbol = this.symbolText.getText();
        if (symbol.length() > 0) {
            this.orderBook.setSymbol(symbol);
            this.profileSub.setSymbols(Collections.singletonList(symbol));
        }
    }

    private void profilesReceived(List<Profile> events) {
        for (Profile event : events) {
            if (event.getDescription() == null) continue;
            this.description.setText(event.getDescription());
        }
    }

    private void setupUI() {
        this.form = new JPanel();
        this.form.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JLabel bidLabel = new JLabel();
        bidLabel.setText("Bid");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel1.add((Component)bidLabel, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel1.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        panel1.add((Component)spacer2, gbc);
        JLabel askLabel = new JLabel();
        askLabel.setText("Ask");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        panel1.add((Component)askLabel, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)scrollPane1, gbc);
        this.bidTable = new JTable();
        scrollPane1.setViewportView(this.bidTable);
        JScrollPane scrollPane2 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)scrollPane2, gbc);
        this.askTable = new JTable();
        scrollPane2.setViewportView(this.askTable);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel2, gbc);
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JLabel symbolLabel = new JLabel();
        symbolLabel.setText("Symbol");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel2.add((Component)symbolLabel, gbc);
        this.symbolText = new JTextField();
        this.symbolText.setColumns(10);
        this.symbolText.setMaximumSize(this.symbolText.getPreferredSize());
        this.symbolText.setMinimumSize(this.symbolText.getPreferredSize());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel2.add((Component)this.symbolText, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel2.add((Component)spacer3, gbc);
        this.description = new JLabel();
        this.description.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 3.0;
        gbc.anchor = 17;
        panel2.add((Component)this.description, gbc);
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel2.add((Component)spacer4, gbc);
    }

    static class BookTableModel
    extends DefaultTableModel {
        BookTableModel() {
            this.addColumn("EX");
            this.addColumn("MM");
            this.addColumn("Price");
            this.addColumn("Size");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        void updateOrders(List<Order> orders) {
            Vector<Vector> data = this.getDataVector();
            data.clear();
            for (Order order : orders) {
                Vector<Object> row = new Vector<Object>(4);
                row.add(Character.valueOf(order.getExchangeCode()));
                row.add(order.getMarketMaker());
                row.add(order.getPrice());
                row.add(order.getSizeAsDouble());
                data.add(row);
            }
            this.fireTableDataChanged();
        }
    }
}

