/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.model;

import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.model.ChildEntity;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated
public final class SchemeRecord
extends NamedEntity<SchemeRecord> {
    private final String base;
    private final String parentGenerator;
    private Boolean hasRegionals;
    private Boolean disabled;
    @Deprecated
    private String eventName = null;
    private String index1 = null;
    private String index2 = null;
    private final Map<String, Field> fields = new LinkedHashMap<String, Field>();

    public SchemeRecord(String name, NamedEntity.Mode mode, String parentGenerator, Boolean hasRegionals, String doc, String file) {
        this(name, mode, parentGenerator, null, hasRegionals, doc, file);
    }

    public SchemeRecord(String name, NamedEntity.Mode mode, Boolean hasRegionals, String doc, String file) {
        this(name, mode, null, null, hasRegionals, doc, file);
    }

    private SchemeRecord(String name, NamedEntity.Mode mode, String parentGenerator, String base, Boolean hasRegionals, String doc, String file) {
        super(name, mode, doc, file);
        this.base = base;
        this.parentGenerator = parentGenerator;
        this.hasRegionals = hasRegionals;
        this.disabled = null;
    }

    public String getBase() {
        return this.base;
    }

    public boolean hasBase() {
        return this.base != null;
    }

    public boolean isTemplate() {
        return this.parentGenerator != null;
    }

    public String getParentGenerator() {
        return this.parentGenerator;
    }

    public boolean hasRegionals() {
        return this.hasRegionals != null && this.hasRegionals != false;
    }

    public boolean hasEventFlags() {
        return this.index1 != null || this.index2 != null;
    }

    public boolean isDisabled() {
        return this.disabled != null && this.disabled != false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setIndex(String index1, String index2) {
        this.index1 = index1;
        this.index2 = index2;
    }

    public String getIndex1() {
        return this.index1;
    }

    public String getIndex2() {
        return this.index2;
    }

    @Deprecated
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Deprecated
    public String getEventName() {
        return this.eventName == null || this.eventName.isEmpty() ? this.getName() : this.eventName;
    }

    public Field addField(String fieldName, NamedEntity.Mode mode, Boolean disabled, String type, boolean hasBitfields, Boolean compositeOnly, String doc) throws SchemeException {
        Objects.requireNonNull(fieldName, "fieldName");
        if (this.fields.containsKey(fieldName)) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Field \"" + fieldName + "\" already exists"), this.getFilesList());
        }
        Field f = new Field(this, fieldName, mode, disabled, type, hasBitfields, compositeOnly, doc, this.getLastFile());
        this.fields.put(fieldName, f);
        return f;
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public Field getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public SchemeRecord copyFrom(String parentGenerator, String to, NamedEntity.Mode mode, String file) throws SchemeException {
        if (this.getMode() != NamedEntity.Mode.NEW) {
            throw new SchemeException("Base record \"" + this.getName() + "\" for record \"" + to + "\" is update, not new record", file);
        }
        SchemeRecord clone = new SchemeRecord(to, mode, parentGenerator, this.getName(), this.hasRegionals, this.getDoc(), file);
        clone.setIndex(this.index1, this.index2);
        for (Field f : this.fields.values()) {
            Field nf = f.copyFrom(clone, file);
            clone.fields.put(nf.getName(), nf);
        }
        clone.eventName = this.eventName;
        return clone;
    }

    @Override
    void override(SchemeRecord newInstance) throws SchemeException {
        super.override(newInstance);
        if (newInstance.hasBase()) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Record with mode=\"update\" cannot have copyFrom=\"" + newInstance.getBase() + "\""), this.getFilesList());
        }
        if (newInstance.isTemplate() && !this.isTemplate()) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot update record with record template"), this.getFilesList());
        }
        if (!newInstance.isTemplate() && this.isTemplate()) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot update record template with record"), this.getFilesList());
        }
        if (!Objects.equals(newInstance.getParentGenerator(), this.getParentGenerator())) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Parent generators conflict"), this.getFilesList());
        }
        if (newInstance.hasRegionals != null) {
            this.hasRegionals = newInstance.hasRegionals;
        }
        if (newInstance.disabled != null) {
            this.disabled = newInstance.disabled;
        }
        if (newInstance.index1 != null || newInstance.index2 != null) {
            this.index1 = newInstance.index1;
            this.index2 = newInstance.index2;
        }
        if (newInstance.eventName != null) {
            this.eventName = newInstance.eventName;
        }
        for (Field newF : newInstance.fields.values()) {
            Field oldF = this.fields.get(newF.getName());
            if (oldF == null) {
                if (newF.getMode() != NamedEntity.Mode.NEW) {
                    throw new SchemeException(SchemeException.formatConflictMessage(this, newF.getLastFile(), "Cannot add new field with mode=\"update\"."), this.getFilesList());
                }
                newF.setParent(this);
                this.fields.put(newF.getName(), newF);
                continue;
            }
            oldF.override(newF);
        }
    }

    @Override
    void validateState(SchemeModel parent) throws SchemeException {
        super.validateState(parent);
        this.index1 = this.index1 == null || !this.index1.isEmpty() ? this.index1 : null;
        String string = this.index2 = this.index2 == null || !this.index2.isEmpty() ? this.index2 : null;
        if (this.index1 != null && !this.fields.containsKey(this.index1)) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Index1 field \"" + this.index1 + "\" is absent"), this.getFilesList());
        }
        if (this.index2 != null && !this.fields.containsKey(this.index2)) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Index2 field \"" + this.index2 + "\" is absent"), this.getFilesList());
        }
        HashMap<Field.Alias, Field> seen = new HashMap<Field.Alias, Field>();
        for (Field f : this.fields.values()) {
            f.validateState(parent);
            for (Field.Alias a : f.getAliases()) {
                Field of = (Field)seen.get(a);
                if (of != null) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Alias \"" + a + "\" exists for two fields \"" + f.getName() + "\" and \"" + of.getName() + "\""), this.getFilesList());
                }
                seen.put(a, f);
            }
        }
    }

    public static final class Field
    extends ChildEntity<SchemeRecord, Field> {
        private String type;
        private boolean hasBitfields;
        private boolean disabled;
        private boolean compositeOnly;
        private final Set<Alias> aliases = new HashSet<Alias>();
        private final List<Alias> aliasesAsAdded = new ArrayList<Alias>();
        private Alias mainAlias = null;
        private final Set<Tag> tags = new HashSet<Tag>();
        private final Map<String, Bitfield> bitFields = new HashMap<String, Bitfield>();
        @Deprecated
        private String eventName = null;

        private Field(SchemeRecord parent, String name, NamedEntity.Mode mode, boolean disabled, String type, boolean hasBitfields, boolean compositeOnly, String doc, String file) {
            super(parent, name, mode, doc, file);
            this.disabled = disabled;
            this.type = type;
            this.hasBitfields = hasBitfields;
            this.compositeOnly = compositeOnly;
        }

        public String getType() {
            return this.type;
        }

        public boolean hasBitfields() {
            return this.hasBitfields && !this.bitFields.isEmpty();
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isCompositeOnly() {
            return this.compositeOnly;
        }

        public List<Alias> getAliases() {
            return Collections.unmodifiableList(this.aliasesAsAdded);
        }

        public String getMainAlias() {
            if (this.mainAlias != null) {
                return this.mainAlias.getValue();
            }
            if (!this.aliasesAsAdded.isEmpty()) {
                return this.aliasesAsAdded.get(0).getValue();
            }
            return this.getName();
        }

        public Set<String> getTags() {
            return this.tags.stream().map(Tag::getValue).collect(Collectors.toSet());
        }

        public Collection<Bitfield> getBitfields() {
            if (!this.hasBitfields) {
                throw new IllegalStateException("Cannot return bitfields for type without bitfields");
            }
            return Collections.unmodifiableCollection(this.bitFields.values());
        }

        public void addAlias(String alias, boolean main, AliasOrTagMode mode) throws SchemeException {
            Objects.requireNonNull(alias, "alias");
            Objects.requireNonNull(mode, "mode");
            Alias a = new Alias(alias.trim(), mode, main);
            if (mode == AliasOrTagMode.REMOVE && this.getMode() == NamedEntity.Mode.NEW) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Alias \"" + a.toString() + "\" has mode REMOVE but field has mode NEW"), this.getFilesList());
            }
            if (this.mainAlias != null && main) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Alias \"" + a.toString() + "\" is second main alias, first one was \"" + this.mainAlias.getValue() + "\""), this.getFilesList());
            }
            if (!this.aliases.add(a)) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Alias \"" + a.toString() + "\" is duplicate"), this.getFilesList());
            }
            this.aliasesAsAdded.add(a);
            if (main) {
                this.mainAlias = a;
            }
        }

        public void addTag(String tag, AliasOrTagMode mode) throws SchemeException {
            Objects.requireNonNull(tag, "tag");
            Objects.requireNonNull(mode, "mode");
            Tag t = new Tag(tag.trim(), mode);
            if (mode == AliasOrTagMode.REMOVE && this.getMode() == NamedEntity.Mode.NEW) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Tag \"" + t.toString() + "\" has mode REMOVE but field has mode NEW"), this.getFilesList());
            }
            if (!this.tags.add(t)) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Tag \"" + t.toString() + "\" is duplicate"), this.getFilesList());
            }
        }

        public void addBitfield(String fieldName, NamedEntity.Mode mode, Integer offset, Integer size, String doc, String file) throws SchemeException {
            Objects.requireNonNull(fieldName, "fieldName");
            Objects.requireNonNull(mode, "mode");
            if (!this.hasBitfields) {
                throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Cannot add bitfield for type without bitfields"), this.getFilesList());
            }
            this.bitFields.put(fieldName, new Bitfield(this, fieldName, mode, offset, size, doc, file));
        }

        @Deprecated
        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Deprecated
        public String getEventName() {
            return this.eventName == null || this.eventName.isEmpty() ? ((SchemeRecord)this.getParent()).getEventName() : this.eventName;
        }

        private Field copyFrom(SchemeRecord target, String file) throws SchemeException {
            if (this.getMode() != NamedEntity.Mode.NEW) {
                throw new SchemeException("Base record \"" + this.getName() + "\" for record \"" + target.getName() + "\" has update field \"" + this.getName(), file);
            }
            Field clone = new Field(target, this.getName(), this.getMode(), this.disabled, this.type, this.hasBitfields, this.compositeOnly, this.getDoc(), file);
            clone.aliases.addAll(this.aliases);
            clone.aliasesAsAdded.addAll(this.aliasesAsAdded);
            clone.tags.addAll(this.tags);
            for (Bitfield f : this.bitFields.values()) {
                clone.bitFields.put(f.getName(), f.copyFrom(clone, file));
            }
            clone.eventName = this.eventName;
            return clone;
        }

        @Override
        void override(Field newInstance) throws SchemeException {
            super.override(newInstance);
            if (newInstance.type != null) {
                this.type = newInstance.type;
                this.hasBitfields = newInstance.hasBitfields;
            }
            this.compositeOnly = newInstance.compositeOnly;
            this.disabled = newInstance.disabled;
            if (!this.hasBitfields) {
                this.bitFields.clear();
            } else {
                for (Bitfield newF : newInstance.bitFields.values()) {
                    Bitfield oldF = this.bitFields.get(newF.getName());
                    if (oldF == null) {
                        if (newF.getMode() != NamedEntity.Mode.NEW) {
                            throw new SchemeException(SchemeException.formatConflictMessage(this, newF.getLastFile(), "Cannot add new bitfield with mode=\"update\"."), this.getFilesList());
                        }
                        newF.setParent(this);
                        this.bitFields.put(newF.getName(), newF);
                        continue;
                    }
                    oldF.override(newF);
                }
            }
            for (Alias a : newInstance.aliases) {
                switch (a.getMode()) {
                    case ADD: {
                        if (!this.aliases.add(a)) {
                            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot add new Alias \"" + a.getValue() + "\", already exist"), this.getFilesList());
                        }
                        this.aliasesAsAdded.add(a);
                        if (!a.isMain()) break;
                        this.mainAlias = a;
                        break;
                    }
                    case REMOVE: {
                        if (!this.aliases.remove(a)) {
                            throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot remove Alias \"" + a.getValue() + "\", doesn't exist"), this.getFilesList());
                        }
                        this.aliasesAsAdded.remove(a);
                        if (!a.isMain() || !a.equals(this.mainAlias)) break;
                        this.mainAlias = null;
                    }
                }
            }
            for (Tag t : newInstance.tags) {
                switch (t.getMode()) {
                    case ADD: {
                        if (this.tags.add(t)) break;
                        throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot add new Tag \"" + t.getValue() + "\", already exist"), this.getFilesList());
                    }
                    case REMOVE: {
                        if (this.tags.remove(t)) break;
                        throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Cannot remove Tag \"" + t.getValue() + "\", doesn't exist"), this.getFilesList());
                    }
                }
            }
            if (newInstance.eventName != null) {
                this.eventName = newInstance.eventName;
            }
        }

        @Override
        void validateState(SchemeModel parent) throws SchemeException {
            super.validateState(parent);
            if (this.type == null) {
                throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Field without type"), this.getFilesList());
            }
            if (!parent.hasType(this.type)) {
                throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Unknown type \"" + this.type + "\""), this.getFilesList());
            }
            for (Alias a : this.aliases) {
                if (a.getMode() == AliasOrTagMode.ADD) continue;
                throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Alias \"" + a.getValue() + "\" with mode=\"" + a.getMode().name().toLowerCase() + "\" must be used in update"), this.getFilesList());
            }
            for (Tag t : this.tags) {
                if (t.getMode() == AliasOrTagMode.ADD) continue;
                throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Tag \"" + t.getValue() + "\" with mode=\"" + t.getMode().name().toLowerCase() + "\" must be used in update"), this.getFilesList());
            }
            if (this.hasBitfields && !this.bitFields.isEmpty()) {
                Bitfield[] bits = new Bitfield[64];
                for (Bitfield f : this.bitFields.values()) {
                    f.validateState(parent);
                    for (int i = f.getOffset(); i < f.getOffset() + f.getSize(); ++i) {
                        if (bits[i] != null) {
                            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Bitfields \"" + f.getName() + "\" and \"" + bits[i].getName() + "\" overlap."), this.getFilesList());
                        }
                        bits[i] = f;
                    }
                }
            }
        }

        private static final class Tag {
            private final String tag;
            private final AliasOrTagMode mode;

            public Tag(String tag, AliasOrTagMode mode) {
                Objects.requireNonNull(tag, "tag");
                Objects.requireNonNull(mode, "mode");
                this.tag = tag;
                this.mode = mode;
            }

            public String getValue() {
                return this.tag;
            }

            public AliasOrTagMode getMode() {
                return this.mode;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Tag other = (Tag)o;
                return this.tag.equals(other.tag);
            }

            public int hashCode() {
                return Objects.hash(this.tag);
            }

            public String toString() {
                return this.tag;
            }
        }

        public static final class Alias {
            private final String alias;
            private final AliasOrTagMode mode;
            private final boolean main;

            private Alias(String alias, AliasOrTagMode mode, boolean main) {
                Objects.requireNonNull(alias, "alias");
                Objects.requireNonNull(mode, "mode");
                this.alias = alias;
                this.mode = mode;
                this.main = main;
            }

            public String getValue() {
                return this.alias;
            }

            public AliasOrTagMode getMode() {
                return this.mode;
            }

            public boolean isMain() {
                return this.main;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Alias other = (Alias)o;
                return this.alias.equals(other.alias);
            }

            public int hashCode() {
                return Objects.hash(this.alias);
            }

            public String toString() {
                return this.alias;
            }
        }

        public static final class Bitfield
        extends ChildEntity<Field, Bitfield> {
            private Integer offset;
            private Integer size;

            private Bitfield(Field parent, String name, NamedEntity.Mode mode, Integer offset, Integer size, String doc, String file) throws SchemeException {
                super(parent, name, mode, doc, file);
                if (mode == NamedEntity.Mode.NEW && (offset == null || size == null)) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "New bitfield must have size and offset"), this.getFilesList());
                }
                this.offset = offset;
                this.size = size;
            }

            public int getOffset() {
                return this.offset == null ? -1 : this.offset;
            }

            public int getSize() {
                return this.size == null ? -1 : this.size;
            }

            public boolean defined() {
                return this.offset != null && this.size != null;
            }

            Bitfield copyFrom(Field target, String file) {
                try {
                    return new Bitfield(target, this.getName(), this.getMode(), this.offset, this.size, this.getDoc(), file);
                }
                catch (SchemeException e) {
                    return null;
                }
            }

            @Override
            void override(Bitfield newInstance) throws SchemeException {
                super.override(newInstance);
                if (newInstance.offset != null) {
                    this.offset = newInstance.offset;
                }
                if (newInstance.size != null) {
                    this.size = newInstance.size;
                }
            }

            @Override
            void validateState(SchemeModel parent) throws SchemeException {
                super.validateState(parent);
                if (this.offset == null) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Bitfield must have non-zero offset"), this.getFilesList());
                }
                if (this.offset < 0 || this.offset > 63) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Bitfield must have offset between 0 and 63"), this.getFilesList());
                }
                if (this.size == null) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Bitfield must have non-zero size"), this.getFilesList());
                }
                if (this.size < 1 || this.size > 64) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "Bitfield must have size between 1 and 64"), this.getFilesList());
                }
            }
        }

        public static enum AliasOrTagMode {
            ADD,
            REMOVE;

        }
    }
}

