/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.model;

import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.model.ChildEntity;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeModel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

@Deprecated
public final class SchemeEnum
extends NamedEntity<SchemeEnum> {
    private final Map<String, Value> valuesByName = new LinkedHashMap<String, Value>();
    private final SortedMap<Integer, Value> valuesByOrd = new TreeMap<Integer, Value>();

    public SchemeEnum(String name, NamedEntity.Mode mode, String doc, String file) {
        super(name, mode, doc, file);
    }

    public Map<String, Value> getValuesByName() {
        return Collections.unmodifiableMap(this.valuesByName);
    }

    public Collection<Value> getValuesByOrd() {
        return Collections.unmodifiableCollection(this.valuesByOrd.values());
    }

    public void addValue(String valueName, NamedEntity.Mode mode, int ord, String valueDoc) throws SchemeException {
        Objects.requireNonNull(valueName, "valueName");
        if (this.valuesByName.containsKey(valueName)) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Value \"" + valueName + "\" already exist"), this.getFilesList());
        }
        if (ord < 0 && mode == NamedEntity.Mode.NEW) {
            throw new SchemeException(SchemeException.formatInconsistencyMessage(this, "New value \"" + valueName + "\" must have ordinal number"), this.getFilesList());
        }
        if (ord >= 0 && this.valuesByOrd.containsKey(ord)) {
            throw new SchemeException(SchemeException.formatConflictMessage(this, this.getLastFile(), "Value \"" + valueName + "\" has duplicate ordinal number " + ord), this.getFilesList());
        }
        Value v = new Value(this, valueName, mode, ord, valueDoc, this.getLastFile());
        this.valuesByName.put(valueName, v);
        if (v.hasValidOrd()) {
            this.valuesByOrd.put(ord, v);
        }
    }

    @Override
    void override(SchemeEnum newInstance) throws SchemeException {
        super.override(newInstance);
        for (Value newVal : newInstance.valuesByName.values()) {
            Value oldByName = this.valuesByName.get(newVal.getName());
            if (oldByName == null) {
                Value oldByOrd = (Value)this.valuesByOrd.get(newVal.getOrd());
                if (oldByOrd != null) {
                    throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Name could not be changed for value with ordinal number " + newVal.getOrd() + " from \"" + oldByOrd.getName() + "\" to \"" + newVal.getName() + "\""), this.getFilesList());
                }
                this.valuesByName.put(newVal.getName(), newVal);
                if (!newVal.hasValidOrd()) continue;
                this.valuesByOrd.put(newVal.getOrd(), newVal);
                continue;
            }
            oldByName.override(newVal);
        }
    }

    @Override
    void validateState(SchemeModel parent) throws SchemeException {
        super.validateState(parent);
        int ord = 0;
        for (Value v : this.valuesByName.values()) {
            v.validateState(parent);
            if (v.getOrd() != ord) {
                throw new SchemeException(SchemeException.formatInconsistencyMessage(v, "Value #" + ord + " has ordinal number " + v.getOrd()), v.getFilesList());
            }
            ++ord;
        }
    }

    public String toString() {
        return "SchemeEnum{from=" + this.getFrom() + ", name='" + this.getFullName() + '\'' + ", values=" + this.valuesByName.values().stream().map(v -> v.getName() + '(' + v.getOrd() + ')').collect(Collectors.joining(", ", "{", "}")) + '}';
    }

    public static final class Value
    extends ChildEntity<SchemeEnum, Value> {
        private final int ord;

        private Value(SchemeEnum parent, String name, NamedEntity.Mode mode, int ord, String doc, String file) {
            super(parent, name, mode, doc, file);
            this.ord = ord;
        }

        public int getOrd() {
            return this.ord;
        }

        boolean hasValidOrd() {
            return this.ord >= 0;
        }

        @Override
        void override(Value newInstance) throws SchemeException {
            super.override(newInstance);
            if (newInstance.hasValidOrd() && this.ord != newInstance.ord) {
                throw new SchemeException(SchemeException.formatConflictMessage(this, newInstance.getLastFile(), "Ordinal number cannot be changed from " + this.ord + " to " + newInstance.ord), this.getFilesList());
            }
        }

        public String toString() {
            return "Value{from=" + this.getFrom() + ", name='" + this.getFullName() + '\'' + ", ord=" + this.ord + '}';
        }
    }
}

